/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.apache.commons.collections.map.MultiValueMap;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.controller.jvm.Controller;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.wrapper.WrappedProcess;

public abstract class AbstractController
implements Constants,
Controller {
    Logger _logger = Logger.getLogger(this.getClass().getName());
    protected Map _listeners = Collections.synchronizedMap(MultiValueMap.decorate(new HashMap(), HashSet.class));
    public WrappedProcess _wrappedProcess;
    protected static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("controller"));
    public int _state = 0;
    protected boolean _debug = false;

    public AbstractController(WrappedProcess wrappedProcess) {
        this._wrappedProcess = wrappedProcess;
    }

    @Override
    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    @Override
    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public Logger getLog() {
        return this._logger;
    }

    @Override
    public abstract boolean start();

    @Override
    public void addListener(int state, ControllerListener listener) {
        this._listeners.put(state, listener);
    }

    protected void handleListeners(int state) {
        if (this._listeners != null) {
            ArrayList listeners = (ArrayList)this._listeners.get(state);
            if (listeners == null) {
                return;
            }
            listeners = new ArrayList(listeners);
            for (ControllerListener listener : listeners) {
                try {
                    listener.fire();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public int getState() {
        return this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int state) {
        AbstractController abstractController = this;
        synchronized (abstractController) {
            if (this._state == state) {
                return;
            }
            this._logger.info("Controller State: " + this.stateAsStr(this._state) + " -> " + this.stateAsStr(state));
            this._state = state;
        }
        this.logStateChange(state);
        this.handleListeners(state);
    }

    public abstract void logStateChange(int var1);

    public abstract String stateAsStr(int var1);

    public static interface ControllerListener {
        public void fire();
    }
}

