/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.config;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationBinding;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.FileOptionsProvider;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.GInterpolator;
import org.apache.commons.configuration.Interpolator;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.VFSFileSystem;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.rzo.yajsw.config.YajswConfiguration;
import org.rzo.yajsw.config.jnlp.JnlpSupport;
import org.rzo.yajsw.util.VFSUtils;

public class YajswConfigurationImpl
extends CompositeConfiguration
implements YajswConfiguration {
    InternalLogger log = InternalLoggerFactory.getInstance(this.getClass().getName());
    Configuration _systemProperties;
    Configuration _localConfiguration;
    CompositeConfiguration _systemConfiguration = new CompositeConfiguration();
    boolean debug = false;
    boolean _useSystemProperties = true;
    boolean _isStopper = false;
    boolean _init = false;
    PropertiesConfiguration _fileConfiguration = null;
    Interpolator _interpolator;
    Set _interpolated = new HashSet();
    Map _scriptUtils = null;
    boolean _isJavaDebug = false;

    public YajswConfigurationImpl() {
        this.init();
    }

    public YajswConfigurationImpl(boolean debug) {
        this.setDebug(debug);
        this.init();
    }

    public YajswConfigurationImpl(Configuration localConfiguration, boolean useSystemProperties) {
        this(localConfiguration, useSystemProperties, null);
    }

    public YajswConfigurationImpl(Configuration localConfiguration, boolean useSystemProperties, Map scriptUtils) {
        this._localConfiguration = localConfiguration;
        this._useSystemProperties = useSystemProperties;
        this._scriptUtils = scriptUtils;
        this.init();
    }

    public Interpolator getYajswInterpolator() {
        return this._interpolator;
    }

    @Override
    public void init() {
        if (this._init) {
            return;
        }
        this._interpolator = new GInterpolator(this, true, null, this._scriptUtils);
        try {
            this.setInterpolator(this._interpolator);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (this._localConfiguration != null) {
            this._systemConfiguration.addConfiguration(this._localConfiguration);
            if (this.debug) {
                this.log.debug("added local configuration ");
            }
        }
        if (this._useSystemProperties) {
            this._systemProperties = ConfigurationConverter.getConfiguration((Properties)System.getProperties().clone());
            this._systemConfiguration.addConfiguration(this._systemProperties);
            if (this.debug) {
                this.log.debug("added system configuration ");
            }
        }
        this.addConfiguration(this._systemConfiguration);
        String configFile = (String)this.getProperty("wrapper.config");
        if (configFile != null && configFile.contains("\"")) {
            configFile = configFile.replaceAll("\"", "");
        }
        if (configFile == null) {
            if (this.debug) {
                this.log.warn("configuration file not set");
            }
        } else if (!this.fileExists(configFile)) {
            this.log.error("configuration file not found: " + configFile);
        } else {
            if (configFile.endsWith(".jnlp")) {
                try {
                    JnlpSupport jnlp = new JnlpSupport(configFile);
                    this._fileConfiguration = jnlp.toConfiguration((String)this.getProperty("wrapperx.default.config"));
                    this._fileConfiguration.setFileName(configFile);
                    this.addConfiguration(this._fileConfiguration);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
            if (this._fileConfiguration == null) {
                try {
                    VFSFileSystem fs = new VFSFileSystem();
                    fs.setFileOptionsProvider(new FileOptionsProvider(){

                        @Override
                        public Map getOptions() {
                            HashMap<String, Object> result = new HashMap<String, Object>();
                            String httpProxy = System.getProperty("http.proxyHost");
                            String httpPort = System.getProperty("http.proxyPort");
                            if (httpProxy != null) {
                                int port = 8080;
                                if (httpPort != null) {
                                    try {
                                        port = Integer.parseInt(httpPort);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                result.put("proxyHost", httpProxy);
                                result.put("proxyPort", port);
                            }
                            return result;
                        }
                    });
                    FileSystem.setDefaultFileSystem(fs);
                    this._fileConfiguration = new PropertiesConfiguration();
                    this._fileConfiguration.setFileName(configFile);
                    try {
                        this._fileConfiguration.setBasePath(new File(".").getCanonicalPath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this._fileConfiguration.append(this._systemProperties);
                    this._fileConfiguration.load();
                    this.addConfiguration(this._fileConfiguration);
                }
                catch (ConfigurationException e) {
                    this.log.error("error loading configuration file <init>AsjwConfiguration", e);
                }
            }
            if (!this.isLocalFile()) {
                if (this._fileConfiguration.getProperty("wrapper.working.dir") == null) {
                    try {
                        this._fileConfiguration.setProperty("wrapper.working.dir", new File(this.getCache()).getCanonicalPath().replaceAll("\\\\", "/"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this._fileConfiguration.containsKey("wrapper.cache")) {
                    this._fileConfiguration.setProperty("wrapper.cache", this.getCache());
                }
            }
        }
        this._systemConfiguration.addConfiguration(new EnvironmentConfiguration());
        this._isStopper = this.getBoolean("wrapper.stopper", false);
        try {
            this._isJavaDebug = this.getInt("wrapper.java.debug.port", -1) != -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this._init = true;
    }

    private boolean fileExists(String file) {
        try {
            String current = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            DefaultFileSystemManager fsManager = (DefaultFileSystemManager)VFS.getManager();
            if (current != null) {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", current);
            } else {
                System.clearProperty("javax.xml.parsers.DocumentBuilderFactory");
            }
            FileObject f = VFSUtils.resolveFile(".", file);
            return f.exists();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    protected Object resolveContainerStore(String key) {
        Object result = null;
        if (key == null) {
            result = null;
        }
        if (this._isJavaDebug) {
            if (key.equals("wrapper.startup.timeout")) {
                result = 2147483;
            } else if (key.equals("wrapper.shutdown.timeout")) {
                result = 2147483;
            } else if (key.equals("wrapper.ping.timeout")) {
                result = 2147483;
            }
        }
        if (result != null) {
            return result;
        }
        if (!this._isStopper) {
            result = super.resolveContainerStore(key);
        } else {
            if (key.startsWith("wrapper.on_exit")) {
                return null;
            }
            result = key.startsWith("wrapper.exit_on_main_terminate") ? "0" : (key.startsWith("wrapper.daemon") ? null : (key.contains(".script") ? null : (key.contains(".filter") ? null : (key.contains(".pidfile") ? null : (key.contains(".ntservice") ? null : (key.contains(".jmx") ? null : (key.contains(".lockfile") ? null : (key.contains(".stop.conf") ? null : (key.equals("wrapper.tray") ? null : super.resolveContainerStore(key))))))))));
        }
        if (this._interpolator != null && result != null && !result.equals(this._interpolator.interpolate(result))) {
            this._interpolated.add(key);
        }
        return result;
    }

    public Set getLookupSet() {
        return this._interpolated;
    }

    public Map<String, String> getEnvLookupSet() {
        if (this._interpolator != null) {
            return ((ConfigurationBinding)((GInterpolator)this._interpolator).getBinding()).getUsedEnvVars();
        }
        return new HashMap<String, String>();
    }

    public static void main(String[] args) {
        YajswConfigurationImpl c = new YajswConfigurationImpl();
        c.setProperty("t1", "x");
        c.setProperty("t2", "${t1}");
        System.out.println(c.getString("t2"));
        Iterator it = c.getInterpolator().prefixSet().iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    public CompositeConfiguration getSystemConfiguration() {
        return this._systemConfiguration;
    }

    public void reload() {
        if (this._fileConfiguration != null) {
            this._fileConfiguration.reload();
        }
    }

    public boolean isLocalFile() {
        if (this._fileConfiguration == null) {
            return true;
        }
        try {
            String name = this._fileConfiguration.getFileName();
            if (name.endsWith(".jnlp")) {
                return false;
            }
            FileObject f = VFSUtils.resolveFile(".", name);
            return f instanceof LocalFile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }

    public String getCache() {
        return this.getString("wrapper.cache", "yajsw_cache");
    }

    @Override
    public String getCachedPath() {
        return this.getCachedPath(true);
    }

    public String getCachedPath(boolean save) {
        if (this._fileConfiguration == null) {
            return null;
        }
        if (this.isLocalFile()) {
            try {
                return new File(this._fileConfiguration.getURL().toURI()).getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                return this._fileConfiguration.getFileName();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        try {
            String cache = this.getCache() + "/conf";
            String fileName = this._fileConfiguration.getFileSystem().getFileName(this._fileConfiguration.getFileName());
            File cf = new File(cache);
            if (!cf.exists()) {
                cf.mkdirs();
            }
            if (fileName.endsWith(".jnlp")) {
                fileName = fileName + ".conf";
            }
            File cn = new File(cf, fileName);
            if (save) {
                PropertiesConfiguration c2 = (PropertiesConfiguration)this._fileConfiguration.interpolatedConfiguration();
                c2.save(cn);
            }
            return cn.getCanonicalPath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return this._fileConfiguration.getFileName();
        }
    }

    public Configuration getFileConfiguration() {
        return this._fileConfiguration;
    }

    @Override
    public String getString(String key) {
        String value = super.getString(key);
        return value;
    }

    public long getConfigFileTime() {
        return -1L;
    }

    public boolean isStopper() {
        return this._isStopper;
    }
}

