/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.mcast.discovery;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Iterator;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.ipfilter.IpFilterRule;
import org.jboss.netty.handler.ipfilter.IpFilterRuleList;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.mcast.MulticastEndpoint;

public class DiscoveryServer
extends MulticastEndpoint {
    private String name;
    private String host;
    private int port;
    private IpFilterRuleList firewall;

    public void init() throws Exception {
        if (this.host == null) {
            this.host = this.whatIsMyIp();
        }
        ChannelPipelineFactory factory = new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("discoveryServer", new SimpleChannelUpstreamHandler(){

                    @Override
                    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                        String request = DiscoveryServer.this.getStringMessage(e);
                        if (request == null) {
                            return;
                        }
                        if (DiscoveryServer.this.name != null && DiscoveryServer.this.name.equals(request) && DiscoveryServer.this.host != null && DiscoveryServer.this.port > 0 && DiscoveryServer.this.validate(e)) {
                            DiscoveryServer.this.send(ChannelBuffers.wrappedBuffer((DiscoveryServer.this.name + "&" + DiscoveryServer.this.host + "&" + DiscoveryServer.this.port).getBytes()));
                        }
                    }
                });
                return pipeline;
            }
        };
        super.init(factory);
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setIpSet(IpFilterRuleList ipSet) {
        this.firewall = ipSet;
    }

    private String whatIsMyIp() {
        String result = null;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ne = e.nextElement();
                Enumeration<InetAddress> e2 = ne.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ia = e2.nextElement();
                    if (ia.isAnyLocalAddress() || ia.isLinkLocalAddress() || ia.isLoopbackAddress() || ia.isMulticastAddress() || result != null && ia.isSiteLocalAddress()) continue;
                    result = ia.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", ex);
        }
        return result;
    }

    private boolean validate(MessageEvent e) {
        if (this.firewall == null) {
            return true;
        }
        InetAddress inetAddress = ((InetSocketAddress)e.getRemoteAddress()).getAddress();
        Iterator iterator = this.firewall.iterator();
        IpFilterRule ipFilterRule = null;
        while (iterator.hasNext()) {
            ipFilterRule = (IpFilterRule)iterator.next();
            if (!ipFilterRule.contains(inetAddress)) continue;
            return ipFilterRule.isAllowRule();
        }
        return true;
    }
}

