/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.timeout;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class IntervalTimer {
    private final Timer _timer;
    private final TimerTask _task;
    private volatile Timeout _timeout;
    private final long _interval;
    private volatile String _name = "?";
    private final Lock _lock = new ReentrantLock();

    public IntervalTimer(Timer timer, final TimerTask task, final long interval) {
        this._timer = timer;
        this._task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(Timeout timeout) throws Exception {
                IntervalTimer.this._lock.lock();
                try {
                    if (!timeout.equals(IntervalTimer.this.getTimeout())) {
                        return;
                    }
                    try {
                        task.run(timeout);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    if (IntervalTimer.this.getTimeout() != null) {
                        IntervalTimer.this.setTimeout(IntervalTimer.this._timer.newTimeout(this, interval, TimeUnit.MILLISECONDS));
                    }
                }
                finally {
                    IntervalTimer.this._lock.unlock();
                }
            }
        };
        this._interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        this._lock.lock();
        try {
            if (this._timeout != null) {
                return;
            }
            this.setTimeout(this._timer.newTimeout(this._task, this._interval, TimeUnit.MILLISECONDS));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this._lock.lock();
        try {
            if (this.getTimeout() == null) {
                return;
            }
            this.getTimeout().cancel();
            this.setTimeout(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this._lock.unlock();
        }
    }

    public synchronized boolean isActive() {
        return this._timeout != null;
    }

    public long getInterval() {
        return this._interval;
    }

    public void setName(String name) {
        this._name = name;
    }

    private Timeout getTimeout() {
        return this._timeout;
    }

    private void setTimeout(Timeout timeout) {
        this._timeout = timeout;
    }
}

