/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.session;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.session.Session;
import org.rzo.netty.ahessian.session.SessionImpl;

class SessionFactory {
    private static final String DEFAULT_ALGORITHM = "MD5";
    private Random random;
    private String entropy;
    private int sessionIdLength = 16;
    private int duplicates = 0;
    private MessageDigest digest;
    private static Map<String, Session> _sessions = Collections.synchronizedMap(new HashMap());

    SessionFactory() {
    }

    public Session createSession(String id) {
        if (id == null) {
            id = this.generateSessionId();
        }
        SessionImpl session = new SessionImpl(id);
        _sessions.put(id, session);
        return session;
    }

    private synchronized String generateSessionId() {
        byte[] random = new byte[16];
        String jvmRoute = this.getJvmRoute();
        String result = null;
        StringBuffer buffer = new StringBuffer();
        do {
            int resultLenBytes = 0;
            if (result != null) {
                buffer = new StringBuffer();
                ++this.duplicates;
            }
            while (resultLenBytes < this.sessionIdLength) {
                this.getRandomBytes(random);
                random = this.getDigest().digest(random);
                for (int j = 0; j < random.length && resultLenBytes < this.sessionIdLength; ++resultLenBytes, ++j) {
                    byte b1 = (byte)((random[j] & 0xF0) >> 4);
                    byte b2 = (byte)(random[j] & 0xF);
                    if (b1 < 10) {
                        buffer.append((char)(48 + b1));
                    } else {
                        buffer.append((char)(65 + (b1 - 10)));
                    }
                    if (b2 < 10) {
                        buffer.append((char)(48 + b2));
                        continue;
                    }
                    buffer.append((char)(65 + (b2 - 10)));
                }
            }
            if (jvmRoute == null) continue;
            buffer.append('.').append(jvmRoute);
        } while (_sessions.containsKey(result = buffer.toString()));
        return result;
    }

    private MessageDigest getDigest() {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                Constants.ahessianLogger.warn("", e);
            }
        }
        return this.digest;
    }

    private String getJvmRoute() {
        return System.getProperty("jvmRoute");
    }

    private void getRandomBytes(byte[] bytes) {
        this.getRandom().nextBytes(bytes);
    }

    private Random getRandom() {
        if (this.random == null) {
            long seed;
            long t1 = seed = System.currentTimeMillis();
            char[] entropy = this.getEntropy().toCharArray();
            for (int i = 0; i < entropy.length; ++i) {
                long update = (byte)entropy[i] << i % 8 * 8;
                seed ^= update;
            }
            this.random = new Random();
            this.random.setSeed(seed);
        }
        return this.random;
    }

    private String getEntropy() {
        if (this.entropy == null) {
            this.entropy = this.toString();
        }
        return this.entropy;
    }

    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    public Session getSession(String id) {
        return _sessions.get(id);
    }

    public Session removeSession(String id) {
        return _sessions.remove(id);
    }
}

