/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.message;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import com.caucho.hessian4.io.SerializerFactory;
import java.io.OutputStream;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.OutputStreamEncoder;
import org.rzo.netty.ahessian.rpc.io.Hessian2Output;
import org.rzo.netty.ahessian.rpc.message.FlushRequestMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.session.ClientSessionFilter;

@ChannelPipelineCoverage(value="all")
public class HessianRPCCallEncoder
extends SimpleChannelHandler {
    SerializerFactory sFactory = new SerializerFactory();
    Hessian2Output hOut = null;
    boolean _hasSessionFilter = false;

    public HessianRPCCallEncoder() {
    }

    public HessianRPCCallEncoder(AbstractSerializerFactory serializerFactory) {
        if (serializerFactory != null) {
            this.sFactory.addFactory(serializerFactory);
        }
    }

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            Object msg = e.getMessage();
            if (msg instanceof FlushRequestMessage) {
                this.hOut.flush(e.getFuture());
                e.getFuture().await(5000L);
                return;
            }
            HessianRPCCallMessage message = (HessianRPCCallMessage)e.getMessage();
            message.setHasSessionFilter(this._hasSessionFilter);
            this.hOut.resetReferences();
            this.hOut.call(message);
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", ex);
            e.getFuture().setFailure(ex);
        }
    }

    private OutputStream getOutputStream(ChannelHandlerContext ctx) {
        return (OutputStream)ctx.getPipeline().getContext(OutputStreamEncoder.class).getAttachment();
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        boolean bl = this._hasSessionFilter = ctx.getPipeline().getContext(ClientSessionFilter.class) != null;
        if (this.hOut == null) {
            OutputStream out = (OutputStream)ctx.getPipeline().getContext(OutputStreamEncoder.class).getAttachment();
            this.hOut = new Hessian2Output(out);
            this.hOut.getSerializerFactory().addFactory(this.sFactory);
        } else {
            this.hOut.reset();
        }
        ctx.sendUpstream(e);
    }
}

