/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.rzo.netty.ahessian.io.CRCOutputStream;
import org.rzo.netty.ahessian.io.OutputStreamBuffer;
import org.rzo.netty.ahessian.stopable.StopableHandler;

public class OutputStreamEncoder
extends SimpleChannelHandler
implements StopableHandler {
    volatile OutputStreamBuffer _buffer = null;
    private boolean _stopEnabled = true;
    boolean _crcCheck = false;

    public OutputStreamEncoder() {
    }

    public OutputStreamEncoder(boolean crcCheck) {
        this._crcCheck = crcCheck;
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this._buffer == null) {
            this._buffer = this._crcCheck ? new CRCOutputStream(ctx) : new OutputStreamBuffer(ctx);
            ctx.setAttachment(this._buffer);
        } else {
            this._buffer.setContext(ctx);
        }
        ctx.sendUpstream(e);
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this._buffer != null) {
            this._buffer.close();
        }
        ctx.sendUpstream(e);
    }

    public static OutputStream getOutputStream(ChannelHandlerContext ctx) {
        return (OutputStream)ctx.getPipeline().getContext(OutputStreamEncoder.class).getAttachment();
    }

    public static OutputStreamEncoder getOutputEncoder(ChannelHandlerContext ctx) {
        return (OutputStreamEncoder)ctx.getPipeline().getContext(OutputStreamEncoder.class).getHandler();
    }

    public OutputStreamBuffer getBuffer() {
        return this._buffer;
    }

    @Override
    public boolean isStopEnabled() {
        return this._stopEnabled;
    }

    @Override
    public void setStopEnabled(boolean stopEnabled) {
        this._stopEnabled = stopEnabled;
    }

    @Override
    public void stop() {
        try {
            this._buffer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._buffer = null;
    }
}

