/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.application.jmx.remote.server;

import com.caucho.hessian4.io.SerializerFactory;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.rzo.netty.ahessian.application.jmx.remote.service.JmxSerializerFactory;
import org.rzo.netty.ahessian.io.InputStreamDecoder;
import org.rzo.netty.ahessian.io.OutputStreamEncoder;
import org.rzo.netty.ahessian.io.PullInputStreamConsumer;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallDecoder;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyEncoder;
import org.rzo.netty.ahessian.rpc.message.OutputProducer;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.ImmediateInvokeService;
import org.rzo.netty.ahessian.session.MixinPipeline;

public class RPCServerMixinPipelineFactory
implements ChannelPipelineFactory {
    Executor _executor;
    SerializerFactory _serializerFactory = new JmxSerializerFactory();

    RPCServerMixinPipelineFactory(Executor executor) {
        this._executor = executor;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        MixinPipeline pipeline = new MixinPipeline();
        pipeline.addLast("inputStream", new InputStreamDecoder());
        pipeline.addLast("outputStream", new OutputStreamEncoder());
        pipeline.addLast("callDecoder", new PullInputStreamConsumer(new HessianRPCCallDecoder(this._serializerFactory), this._executor));
        pipeline.addLast("replyEncoder", new HessianRPCReplyEncoder(this._serializerFactory));
        pipeline.addLast("outputProducer", new OutputProducer(this._executor));
        HessianRPCServiceHandler factory = new HessianRPCServiceHandler(this._executor);
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        MBeanServer server = null;
        if (servers != null && servers.size() > 0) {
            server = servers.get(0);
        }
        if (server == null) {
            server = MBeanServerFactory.createMBeanServer();
        }
        factory.addService("default", new ImmediateInvokeService(server, MBeanServerConnection.class, factory));
        pipeline.addLast("hessianRPCServer", factory);
        return pipeline;
    }
}

