/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.application.jmx.remote.client;

import com.caucho.hessian4.io.SerializerFactory;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.rzo.netty.ahessian.application.jmx.remote.service.JmxSerializerFactory;
import org.rzo.netty.ahessian.io.InputStreamDecoder;
import org.rzo.netty.ahessian.io.OutputStreamEncoder;
import org.rzo.netty.ahessian.io.PullInputStreamConsumer;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFactory;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallEncoder;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyDecoder;
import org.rzo.netty.ahessian.rpc.message.OutputProducer;
import org.rzo.netty.ahessian.session.MixinPipeline;

public class RPCClientMixinPipelineFactory
implements ChannelPipelineFactory {
    Executor _executor;
    HessianProxyFactory _factory;
    SerializerFactory _serializerFactory = new JmxSerializerFactory();

    RPCClientMixinPipelineFactory(Executor executor, HessianProxyFactory factory) {
        this._executor = executor;
        this._factory = factory;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        MixinPipeline pipeline = new MixinPipeline();
        pipeline.addLast("inputStream", new InputStreamDecoder());
        pipeline.addLast("outputStream", new OutputStreamEncoder());
        pipeline.addLast("hessianReplyDecoder", new PullInputStreamConsumer(new HessianRPCReplyDecoder(this._factory, this._serializerFactory), this._executor));
        pipeline.addLast("hessianCallEncoder", new HessianRPCCallEncoder(this._serializerFactory));
        pipeline.addLast("outputProducer", new OutputProducer(this._executor));
        pipeline.addLast("hessianHandler", this._factory);
        return pipeline;
    }
}

