/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.utils.Key;
import org.quartz.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLSchedulingDataProcessor
implements ErrorHandler {
    public static final String QUARTZ_NS = "http://www.quartz-scheduler.org/xml/JobSchedulingData";
    public static final String QUARTZ_SCHEMA_WEB_URL = "http://www.quartz-scheduler.org/xml/job_scheduling_data_1_8.xsd";
    public static final String QUARTZ_XSD_PATH_IN_JAR = "org/quartz/xml/job_scheduling_data_1_8.xsd";
    public static final String QUARTZ_XML_DEFAULT_FILE_NAME = "quartz_data.xml";
    public static final String QUARTZ_SYSTEM_ID_JAR_PREFIX = "jar:";
    protected static final String XSD_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    protected List<String> jobGroupsToDelete = new LinkedList<String>();
    protected List<String> triggerGroupsToDelete = new LinkedList<String>();
    protected List<Key> jobsToDelete = new LinkedList<Key>();
    protected List<Key> triggersToDelete = new LinkedList<Key>();
    protected List<JobDetail> loadedJobs = new LinkedList<JobDetail>();
    protected List<Trigger> loadedTriggers = new LinkedList<Trigger>();
    private boolean overWriteExistingData = true;
    private boolean ignoreDuplicates = false;
    protected Collection validationExceptions = new ArrayList();
    protected ClassLoadHelper classLoadHelper;
    protected List<String> jobGroupsToNeverDelete = new LinkedList<String>();
    protected List<String> triggerGroupsToNeverDelete = new LinkedList<String>();
    private DocumentBuilder docBuilder = null;
    private XPath xpath = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public XMLSchedulingDataProcessor(ClassLoadHelper clh) throws ParserConfigurationException {
        this.classLoadHelper = clh;
        this.initDocumentParser();
    }

    protected void initDocumentParser() throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setValidating(true);
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        docBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.resolveSchemaSource());
        this.docBuilder = docBuilderFactory.newDocumentBuilder();
        this.docBuilder.setErrorHandler(this);
        NamespaceContext nsContext = new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new IllegalArgumentException("Null prefix");
                }
                if ("xml".equals(prefix)) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                if ("xmlns".equals(prefix)) {
                    return "http://www.w3.org/2000/xmlns/";
                }
                if ("q".equals(prefix)) {
                    return XMLSchedulingDataProcessor.QUARTZ_NS;
                }
                return "";
            }

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException();
            }
        };
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xpath.setNamespaceContext(nsContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object resolveSchemaSource() {
        InputSource inputSource = null;
        InputStream is = null;
        Object url = null;
        try {
            is = this.classLoadHelper.getResourceAsStream(QUARTZ_XSD_PATH_IN_JAR);
        }
        finally {
            if (is == null) {
                this.log.info("Unable to load local schema packaged in quartz distribution jar. Utilizing schema online at http://www.quartz-scheduler.org/xml/job_scheduling_data_1_8.xsd");
                return QUARTZ_SCHEMA_WEB_URL;
            }
            inputSource = new InputSource(is);
            inputSource.setSystemId(QUARTZ_SCHEMA_WEB_URL);
            this.log.debug("Utilizing schema packaged in local quartz distribution jar.");
        }
        return inputSource;
    }

    public boolean isOverWriteExistingData() {
        return this.overWriteExistingData;
    }

    protected void setOverWriteExistingData(boolean overWriteExistingData) {
        this.overWriteExistingData = overWriteExistingData;
    }

    public boolean isIgnoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public void setIgnoreDuplicates(boolean ignoreDuplicates) {
        this.ignoreDuplicates = ignoreDuplicates;
    }

    public void addJobGroupToNeverDelete(String group2) {
        if (group2 != null) {
            this.jobGroupsToNeverDelete.add(group2);
        }
    }

    public boolean removeJobGroupToNeverDelete(String group2) {
        if (group2 != null) {
            return this.jobGroupsToNeverDelete.remove(group2);
        }
        return false;
    }

    public List<String> getJobGroupsToNeverDelete() {
        return Collections.unmodifiableList(this.jobGroupsToDelete);
    }

    public void addTriggerGroupToNeverDelete(String group2) {
        if (group2 != null) {
            this.triggerGroupsToNeverDelete.add(group2);
        }
    }

    public boolean removeTriggerGroupToNeverDelete(String group2) {
        if (group2 != null) {
            return this.triggerGroupsToNeverDelete.remove(group2);
        }
        return false;
    }

    public List<String> getTriggerGroupsToNeverDelete() {
        return Collections.unmodifiableList(this.triggerGroupsToDelete);
    }

    protected void processFile() throws Exception {
        this.processFile(QUARTZ_XML_DEFAULT_FILE_NAME);
    }

    protected void processFile(String fileName) throws Exception {
        this.processFile(fileName, this.getSystemIdForFileName(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSystemIdForFileName(String fileName) {
        InputStream fileInputStream = null;
        try {
            String string;
            String urlPath = null;
            File file = new File(fileName);
            if (!file.exists()) {
                URL url = this.getURL(fileName);
                if (url != null) {
                    try {
                        urlPath = URLDecoder.decode(url.getPath(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.warn("Unable to decode file path URL", e);
                    }
                    try {
                        if (url != null) {
                            fileInputStream = url.openStream();
                        }
                    }
                    catch (IOException ignore) {}
                }
            } else {
                try {
                    fileInputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException ignore) {
                    // empty catch block
                }
            }
            if (fileInputStream == null) {
                this.log.debug("Unable to resolve '" + fileName + "' to full path, so using it as is for system id.");
                string = fileName;
                return string;
            }
            string = urlPath != null ? urlPath : file.getAbsolutePath();
            return string;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ioe) {
                this.log.warn("Error closing jobs file: " + fileName, ioe);
            }
        }
    }

    protected URL getURL(String fileName) {
        return this.classLoadHelper.getResource(fileName);
    }

    protected void prepForProcessing() {
        this.clearValidationExceptions();
        this.setOverWriteExistingData(true);
        this.setIgnoreDuplicates(false);
        this.jobGroupsToDelete.clear();
        this.jobsToDelete.clear();
        this.triggerGroupsToDelete.clear();
        this.triggersToDelete.clear();
        this.loadedJobs.clear();
        this.loadedTriggers.clear();
    }

    protected void processFile(String fileName, String systemId) throws ValidationException, ParserConfigurationException, SAXException, IOException, SchedulerException, ClassNotFoundException, ParseException, XPathException {
        this.prepForProcessing();
        this.log.info("Parsing XML file: " + fileName + " with systemId: " + systemId);
        InputSource is = new InputSource(this.getInputStream(fileName));
        is.setSystemId(systemId);
        this.process(is);
        this.maybeThrowValidationException();
    }

    public void processStreamAndScheduleJobs(InputStream stream, String systemId, Scheduler sched) throws ValidationException, ParserConfigurationException, SAXException, XPathException, IOException, SchedulerException, ClassNotFoundException, ParseException {
        this.prepForProcessing();
        this.log.info("Parsing XML from stream with systemId: " + systemId);
        InputSource is = new InputSource(stream);
        is.setSystemId(systemId);
        this.process(is);
        this.executePreProcessCommands(sched);
        this.scheduleJobs(sched);
        this.maybeThrowValidationException();
    }

    protected void process(InputSource is) throws SAXException, IOException, ParseException, XPathException, ClassNotFoundException {
        Document document = this.docBuilder.parse(is);
        NodeList deleteJobGroupNodes = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-jobs-in-group", document, XPathConstants.NODESET);
        this.log.debug("Found " + deleteJobGroupNodes.getLength() + " delete job group commands.");
        for (int i = 0; i < deleteJobGroupNodes.getLength(); ++i) {
            Node node = deleteJobGroupNodes.item(i);
            String t = node.getTextContent();
            if (t == null || (t = t.trim()).length() == 0) continue;
            this.jobGroupsToDelete.add(t);
        }
        NodeList deleteTriggerGroupNodes = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-triggers-in-group", document, XPathConstants.NODESET);
        this.log.debug("Found " + deleteTriggerGroupNodes.getLength() + " delete trigger group commands.");
        for (int i = 0; i < deleteTriggerGroupNodes.getLength(); ++i) {
            Node node = deleteTriggerGroupNodes.item(i);
            String t = node.getTextContent();
            if (t == null || (t = t.trim()).length() == 0) continue;
            this.triggerGroupsToDelete.add(t);
        }
        NodeList deleteJobNodes = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-job", document, XPathConstants.NODESET);
        this.log.debug("Found " + deleteJobNodes.getLength() + " delete job commands.");
        for (int i = 0; i < deleteJobNodes.getLength(); ++i) {
            Node node = deleteJobNodes.item(i);
            String name = this.getTrimmedToNullString(this.xpath, "q:name", node);
            String group2 = this.getTrimmedToNullString(this.xpath, "q:group", node);
            if (name == null) {
                throw new ParseException("Encountered a 'delete-job' command without a name specified.", -1);
            }
            this.jobsToDelete.add(new Key(name, group2));
        }
        NodeList deleteTriggerNodes = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:pre-processing-commands/q:delete-trigger", document, XPathConstants.NODESET);
        this.log.debug("Found " + deleteTriggerNodes.getLength() + " delete trigger commands.");
        for (int i = 0; i < deleteTriggerNodes.getLength(); ++i) {
            Node node = deleteTriggerNodes.item(i);
            String name = this.getTrimmedToNullString(this.xpath, "q:name", node);
            String group3 = this.getTrimmedToNullString(this.xpath, "q:group", node);
            if (name == null) {
                throw new ParseException("Encountered a 'delete-trigger' command without a name specified.", -1);
            }
            this.triggersToDelete.add(new Key(name, group3));
        }
        Boolean overWrite = this.getBoolean(this.xpath, "/q:job-scheduling-data/q:processing-directives/q:overwrite-existing-data", document);
        if (overWrite == null) {
            this.log.debug("Directive 'overwrite-existing-data' not specified, defaulting to " + this.isOverWriteExistingData());
        } else {
            this.log.debug("Directive 'overwrite-existing-data' specified as: " + overWrite);
            this.setOverWriteExistingData(overWrite);
        }
        Boolean ignoreDupes = this.getBoolean(this.xpath, "/q:job-scheduling-data/q:processing-directives/q:ignore-duplicates", document);
        if (ignoreDupes == null) {
            this.log.debug("Directive 'ignore-duplicates' not specified, defaulting to " + this.isIgnoreDuplicates());
        } else {
            this.log.debug("Directive 'ignore-duplicates' specified as: " + ignoreDupes);
            this.setIgnoreDuplicates(ignoreDupes);
        }
        NodeList jobNodes = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:schedule/q:job", document, XPathConstants.NODESET);
        this.log.debug("Found " + jobNodes.getLength() + " job definitions.");
        for (int i = 0; i < jobNodes.getLength(); ++i) {
            Node jobDetailNode = jobNodes.item(i);
            String t = null;
            String jobName = this.getTrimmedToNullString(this.xpath, "q:name", jobDetailNode);
            String jobGroup = this.getTrimmedToNullString(this.xpath, "q:group", jobDetailNode);
            String jobDescription = this.getTrimmedToNullString(this.xpath, "q:description", jobDetailNode);
            String jobClassName = this.getTrimmedToNullString(this.xpath, "q:job-class", jobDetailNode);
            t = this.getTrimmedToNullString(this.xpath, "q:volatility", jobDetailNode);
            boolean jobVolatility = t != null && t.equals("true");
            t = this.getTrimmedToNullString(this.xpath, "q:durability", jobDetailNode);
            boolean jobDurability = t != null && t.equals("true");
            t = this.getTrimmedToNullString(this.xpath, "q:recover", jobDetailNode);
            boolean jobRecoveryRequested = t != null && t.equals("true");
            Class jobClass = this.classLoadHelper.loadClass(jobClassName);
            JobDetail jobDetail = new JobDetail(jobName, jobGroup, jobClass, jobVolatility, jobDurability, jobRecoveryRequested);
            jobDetail.setDescription(jobDescription);
            NodeList jobListenerEntries = (NodeList)this.xpath.evaluate("q:job-listener-ref", jobDetailNode, XPathConstants.NODESET);
            for (int j = 0; j < jobListenerEntries.getLength(); ++j) {
                Node listenerRefNode = jobListenerEntries.item(j);
                String ref = listenerRefNode.getTextContent();
                if (ref != null && (ref = ref.trim()).length() == 0) {
                    ref = null;
                }
                if (ref == null) continue;
                jobDetail.addJobListener(ref);
            }
            NodeList jobDataEntries = (NodeList)this.xpath.evaluate("q:job-data-map/q:entry", jobDetailNode, XPathConstants.NODESET);
            for (int k = 0; k < jobDataEntries.getLength(); ++k) {
                Node entryNode = jobDataEntries.item(k);
                String key = this.getTrimmedToNullString(this.xpath, "q:key", entryNode);
                String value = this.getTrimmedToNullString(this.xpath, "q:value", entryNode);
                jobDetail.getJobDataMap().put(key, value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Parsed job definition: " + jobDetail);
            }
            this.addJobToSchedule(jobDetail);
        }
        NodeList triggerEntries = (NodeList)this.xpath.evaluate("/q:job-scheduling-data/q:schedule/q:trigger/*", document, XPathConstants.NODESET);
        this.log.debug("Found " + triggerEntries.getLength() + " trigger definitions.");
        for (int j = 0; j < triggerEntries.getLength(); ++j) {
            Node triggerNode = triggerEntries.item(j);
            String triggerName = this.getTrimmedToNullString(this.xpath, "q:name", triggerNode);
            String triggerGroup = this.getTrimmedToNullString(this.xpath, "q:group", triggerNode);
            String triggerDescription = this.getTrimmedToNullString(this.xpath, "q:description", triggerNode);
            String triggerMisfireInstructionConst = this.getTrimmedToNullString(this.xpath, "q:misfire-instruction", triggerNode);
            String triggerCalendarRef = this.getTrimmedToNullString(this.xpath, "q:calendar-name", triggerNode);
            String triggerJobName = this.getTrimmedToNullString(this.xpath, "q:job-name", triggerNode);
            String triggerJobGroup = this.getTrimmedToNullString(this.xpath, "q:job-group", triggerNode);
            String t = this.getTrimmedToNullString(this.xpath, "q:volatility", triggerNode);
            boolean triggerVolatility = t != null && t.equals("true");
            String startTimeString = this.getTrimmedToNullString(this.xpath, "q:start-time", triggerNode);
            String endTimeString = this.getTrimmedToNullString(this.xpath, "q:end-time", triggerNode);
            Date triggerStartTime = startTimeString == null || startTimeString.length() == 0 ? new Date() : dateFormat.parse(startTimeString);
            Date triggerEndTime = endTimeString == null || endTimeString.length() == 0 ? null : dateFormat.parse(endTimeString);
            Trigger trigger = null;
            if (triggerNode.getNodeName().equals("simple")) {
                String repeatCountString = this.getTrimmedToNullString(this.xpath, "q:repeat-count", triggerNode);
                String repeatIntervalString = this.getTrimmedToNullString(this.xpath, "q:repeat-interval", triggerNode);
                int repeatCount = repeatCountString == null ? -1 : Integer.parseInt(repeatCountString);
                long repeatInterval = repeatIntervalString == null ? 0L : Long.parseLong(repeatIntervalString);
                trigger = new SimpleTrigger(triggerName, triggerGroup, triggerJobName, triggerJobGroup, triggerStartTime, triggerEndTime, repeatCount, repeatInterval);
            } else if (triggerNode.getNodeName().equals("cron")) {
                String cronExpression = this.getTrimmedToNullString(this.xpath, "q:cron-expression", triggerNode);
                String timezoneString = this.getTrimmedToNullString(this.xpath, "q:time-zone", triggerNode);
                TimeZone tz = timezoneString == null ? null : TimeZone.getTimeZone(timezoneString);
                trigger = new CronTrigger(triggerName, triggerGroup, triggerJobName, triggerJobGroup, triggerStartTime, triggerEndTime, cronExpression, tz);
            } else {
                throw new ParseException("Unknown trigger type: " + triggerNode.getNodeName(), -1);
            }
            trigger.setVolatility(triggerVolatility);
            trigger.setDescription(triggerDescription);
            trigger.setCalendarName(triggerCalendarRef);
            if (triggerMisfireInstructionConst != null && triggerMisfireInstructionConst.length() != 0) {
                Class<?> clazz = trigger.getClass();
                try {
                    Field field = clazz.getField(triggerMisfireInstructionConst);
                    int misfireInst = field.getInt(trigger);
                    trigger.setMisfireInstruction(misfireInst);
                }
                catch (Exception e) {
                    throw new ParseException("Unexpected/Unhandlable Misfire Instruction encountered '" + triggerMisfireInstructionConst + "', for trigger: " + trigger.getFullName(), -1);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Parsed trigger definition: " + trigger);
            }
            this.addTriggerToSchedule(trigger);
        }
    }

    protected String getTrimmedToNullString(XPath xpath, String elementName, Node parentNode) throws XPathExpressionException {
        String str = (String)xpath.evaluate(elementName, parentNode, XPathConstants.STRING);
        if (str != null) {
            str = str.trim();
        }
        if (str != null && str.length() == 0) {
            str = null;
        }
        return str;
    }

    protected Boolean getBoolean(XPath xpath, String elementName, Document document) throws XPathExpressionException {
        Node directive = (Node)xpath.evaluate(elementName, document, XPathConstants.NODE);
        if (directive == null || directive.getTextContent() == null) {
            return null;
        }
        String val = directive.getTextContent();
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("y")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void processFileAndScheduleJobs(Scheduler sched, boolean overWriteExistingJobs) throws SchedulerException, Exception {
        this.processFileAndScheduleJobs(QUARTZ_XML_DEFAULT_FILE_NAME, sched);
    }

    public void processFileAndScheduleJobs(String fileName, Scheduler sched) throws Exception {
        this.processFileAndScheduleJobs(fileName, this.getSystemIdForFileName(fileName), sched);
    }

    public void processFileAndScheduleJobs(String fileName, String systemId, Scheduler sched) throws Exception {
        this.processFile(fileName, systemId);
        this.executePreProcessCommands(sched);
        this.scheduleJobs(sched);
    }

    protected List<JobDetail> getLoadedJobs() {
        return Collections.unmodifiableList(this.loadedJobs);
    }

    protected List<Trigger> getLoadedTriggers() {
        return Collections.unmodifiableList(this.loadedTriggers);
    }

    protected InputStream getInputStream(String fileName) {
        return this.classLoadHelper.getResourceAsStream(fileName);
    }

    protected void addJobToSchedule(JobDetail job) {
        this.loadedJobs.add(job);
    }

    protected void addTriggerToSchedule(Trigger trigger) {
        this.loadedTriggers.add(trigger);
    }

    private Map<String, List<Trigger>> buildTriggersByFQJobNameMap(List<Trigger> triggers) {
        HashMap<String, List<Trigger>> triggersByFQJobName = new HashMap<String, List<Trigger>>();
        for (Trigger trigger : triggers) {
            LinkedList<Trigger> triggersOfJob = (LinkedList<Trigger>)triggersByFQJobName.get(trigger.getFullJobName());
            if (triggersOfJob == null) {
                triggersOfJob = new LinkedList<Trigger>();
                triggersByFQJobName.put(trigger.getFullJobName(), triggersOfJob);
            }
            triggersOfJob.add(trigger);
        }
        return triggersByFQJobName;
    }

    protected void executePreProcessCommands(Scheduler scheduler) throws SchedulerException {
        for (String group2 : this.jobGroupsToDelete) {
            if (group2.equals("*")) {
                this.log.info("Deleting all jobs in ALL groups.");
                for (String groupName : scheduler.getJobGroupNames()) {
                    if (this.jobGroupsToNeverDelete.contains(groupName)) continue;
                    for (String jobName : scheduler.getJobNames(groupName)) {
                        scheduler.deleteJob(jobName, groupName);
                    }
                }
                continue;
            }
            if (this.jobGroupsToNeverDelete.contains(group2)) continue;
            this.log.info("Deleting all jobs in group: {}", (Object)group2);
            for (String jobName : scheduler.getJobNames(group2)) {
                scheduler.deleteJob(jobName, group2);
            }
        }
        for (String group2 : this.triggerGroupsToDelete) {
            if (group2.equals("*")) {
                this.log.info("Deleting all triggers in ALL groups.");
                for (String groupName : scheduler.getTriggerGroupNames()) {
                    if (this.triggerGroupsToNeverDelete.contains(groupName)) continue;
                    for (String triggerName : scheduler.getTriggerNames(groupName)) {
                        scheduler.unscheduleJob(triggerName, groupName);
                    }
                }
                continue;
            }
            if (this.triggerGroupsToNeverDelete.contains(group2)) continue;
            this.log.info("Deleting all triggers in group: {}", (Object)group2);
            for (String triggerName : scheduler.getTriggerNames(group2)) {
                scheduler.unscheduleJob(triggerName, group2);
            }
        }
        for (Key key : this.jobsToDelete) {
            if (this.jobGroupsToNeverDelete.contains(key.getGroup())) continue;
            this.log.info("Deleting job: {}", key);
            scheduler.deleteJob(key.getName(), key.getGroup());
        }
        for (Key key : this.triggersToDelete) {
            if (this.triggerGroupsToNeverDelete.contains(key.getGroup())) continue;
            this.log.info("Deleting trigger: {}", key);
            scheduler.unscheduleJob(key.getName(), key.getGroup());
        }
    }

    protected void scheduleJobs(Scheduler sched) throws SchedulerException {
        LinkedList<JobDetail> jobs = new LinkedList<JobDetail>(this.getLoadedJobs());
        LinkedList<Trigger> triggers = new LinkedList<Trigger>(this.getLoadedTriggers());
        this.log.info("Adding " + jobs.size() + " jobs, " + triggers.size() + " triggers.");
        Map<String, List<Trigger>> triggersByFQJobName = this.buildTriggersByFQJobNameMap(triggers);
        Iterator itr = jobs.iterator();
        while (itr.hasNext()) {
            JobDetail detail = (JobDetail)itr.next();
            itr.remove();
            JobDetail dupeJ = sched.getJobDetail(detail.getName(), detail.getGroup());
            if (dupeJ != null) {
                if (!this.isOverWriteExistingData() && this.isIgnoreDuplicates()) {
                    this.log.info("Not overwriting existing job: " + dupeJ.getFullName());
                    continue;
                }
                if (!this.isOverWriteExistingData() && !this.isIgnoreDuplicates()) {
                    throw new ObjectAlreadyExistsException(detail);
                }
            }
            if (dupeJ != null) {
                this.log.info("Replacing job: " + detail.getFullName());
            } else {
                this.log.info("Adding job: " + detail.getFullName());
            }
            List<Trigger> triggersOfJob = triggersByFQJobName.get(detail.getFullName());
            if (!(detail.isDurable() || triggersOfJob != null && triggersOfJob.size() != 0)) {
                if (dupeJ == null) {
                    throw new SchedulerException("A new job defined without any triggers must be durable: " + detail.getFullName());
                }
                if (dupeJ.isDurable() && sched.getTriggersOfJob(detail.getName(), detail.getGroup()).length == 0) {
                    throw new SchedulerException("Can't change existing durable job without triggers to non-durable: " + detail.getFullName());
                }
            }
            boolean addJobWithFirstSchedule = false;
            if (dupeJ != null || detail.isDurable()) {
                sched.addJob(detail, true);
            } else {
                addJobWithFirstSchedule = true;
            }
            for (Trigger trigger : triggersOfJob) {
                triggers.remove(trigger);
                if (trigger.getStartTime() == null) {
                    trigger.setStartTime(new Date());
                }
                boolean addedTrigger = false;
                while (!addedTrigger) {
                    Trigger dupeT = sched.getTrigger(trigger.getName(), trigger.getGroup());
                    if (dupeT != null) {
                        if (this.isOverWriteExistingData()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Rescheduling job: " + trigger.getFullJobName() + " with updated trigger: " + trigger.getFullName());
                            }
                        } else {
                            if (this.isIgnoreDuplicates()) {
                                this.log.info("Not overwriting existing trigger: " + dupeT.getFullName());
                                continue;
                            }
                            throw new ObjectAlreadyExistsException(trigger);
                        }
                        if (!dupeT.getJobGroup().equals(trigger.getJobGroup()) || !dupeT.getJobName().equals(trigger.getJobName())) {
                            this.log.warn("Possibly duplicately named ({}) triggers in jobs xml file! ", (Object)trigger.getFullName());
                        }
                        sched.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
                    } else {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Scheduling job: " + trigger.getFullJobName() + " with trigger: " + trigger.getFullName());
                        }
                        try {
                            if (addJobWithFirstSchedule) {
                                sched.scheduleJob(detail, trigger);
                                addJobWithFirstSchedule = false;
                            } else {
                                sched.scheduleJob(trigger);
                            }
                        }
                        catch (ObjectAlreadyExistsException e) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Adding trigger: " + trigger.getFullName() + " for job: " + detail.getFullName() + " failed because the trigger already existed.  " + "This is likely due to a race condition between multiple instances " + "in the cluster.  Will try to reschedule instead.");
                            continue;
                        }
                    }
                    addedTrigger = true;
                }
            }
        }
        for (Trigger trigger : triggers) {
            if (trigger.getStartTime() == null) {
                trigger.setStartTime(new Date());
            }
            boolean addedTrigger = false;
            while (!addedTrigger) {
                Trigger dupeT = sched.getTrigger(trigger.getName(), trigger.getGroup());
                if (dupeT != null) {
                    if (this.isOverWriteExistingData()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Rescheduling job: " + trigger.getFullJobName() + " with updated trigger: " + trigger.getFullName());
                        }
                    } else {
                        if (this.isIgnoreDuplicates()) {
                            this.log.info("Not overwriting existing trigger: " + dupeT.getFullName());
                            continue;
                        }
                        throw new ObjectAlreadyExistsException(trigger);
                    }
                    if (!dupeT.getJobGroup().equals(trigger.getJobGroup()) || !dupeT.getJobName().equals(trigger.getJobName())) {
                        this.log.warn("Possibly duplicately named ({}) triggers in jobs xml file! ", (Object)trigger.getFullName());
                    }
                    sched.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Scheduling job: " + trigger.getFullJobName() + " with trigger: " + trigger.getFullName());
                    }
                    try {
                        sched.scheduleJob(trigger);
                    }
                    catch (ObjectAlreadyExistsException e) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Adding trigger: " + trigger.getFullName() + " for job: " + trigger.getFullJobName() + " failed because the trigger already existed.  " + "This is likely due to a race condition between multiple instances " + "in the cluster.  Will try to reschedule instead.");
                        continue;
                    }
                }
                addedTrigger = true;
            }
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.addValidationException(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.addValidationException(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.addValidationException(e);
    }

    protected void addValidationException(SAXException e) {
        this.validationExceptions.add(e);
    }

    protected void clearValidationExceptions() {
        this.validationExceptions.clear();
    }

    protected void maybeThrowValidationException() throws ValidationException {
        if (this.validationExceptions.size() > 0) {
            throw new ValidationException("Encountered " + this.validationExceptions.size() + " validation exceptions.", this.validationExceptions);
        }
    }
}

