/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.NullSampledStatisticsImpl;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.SampledStatistics;
import org.quartz.core.SampledStatisticsImpl;
import org.quartz.core.SchedulingContext;
import org.quartz.core.jmx.JobDetailSupport;
import org.quartz.core.jmx.JobExecutionContextSupport;
import org.quartz.core.jmx.QuartzSchedulerMBean;
import org.quartz.core.jmx.TriggerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzSchedulerMBeanImpl
extends StandardMBean
implements NotificationEmitter,
QuartzSchedulerMBean,
JobListener,
SchedulerListener {
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final QuartzScheduler scheduler;
    private boolean sampledStatisticsEnabled;
    private SampledStatistics sampledStatistics;
    private static final SampledStatistics NULL_SAMPLED_STATISTICS;
    protected final Emitter emitter = new Emitter();
    protected final AtomicLong sequenceNumber = new AtomicLong();

    protected QuartzSchedulerMBeanImpl(QuartzScheduler scheduler) throws NotCompliantMBeanException {
        super(QuartzSchedulerMBean.class);
        this.scheduler = scheduler;
        this.scheduler.addGlobalJobListener(this);
        this.scheduler.addSchedulerListener(this);
        this.sampledStatistics = NULL_SAMPLED_STATISTICS;
        this.sampledStatisticsEnabled = false;
    }

    @Override
    public TabularData getCurrentlyExecutingJobs() throws SchedulerException {
        return JobExecutionContextSupport.toTabularData(this.scheduler.getCurrentlyExecutingJobs());
    }

    @Override
    public TabularData getAllJobDetails(String instanceId) throws SchedulerException {
        SchedulingContext cntx = new SchedulingContext(instanceId);
        ArrayList<JobDetail> detailList = new ArrayList<JobDetail>();
        for (String jobGroupName : this.scheduler.getJobGroupNames(cntx)) {
            for (String jobName : this.scheduler.getJobNames(cntx, jobGroupName)) {
                detailList.add(this.scheduler.getJobDetail(cntx, jobName, jobGroupName));
            }
        }
        return JobDetailSupport.toTabularData(detailList.toArray(new JobDetail[detailList.size()]));
    }

    @Override
    public TabularData getAllTriggers(String instanceId) throws SchedulerException {
        SchedulingContext cntx = new SchedulingContext(instanceId);
        ArrayList<Trigger> triggerList = new ArrayList<Trigger>();
        for (String triggerGroupName : this.scheduler.getTriggerGroupNames(cntx)) {
            for (String triggerName : this.scheduler.getTriggerNames(cntx, triggerGroupName)) {
                triggerList.add(this.scheduler.getTrigger(cntx, triggerName, triggerGroupName));
            }
        }
        return TriggerSupport.toTabularData(triggerList.toArray(new Trigger[triggerList.size()]));
    }

    @Override
    public void addJob(String instanceId, CompositeData jobDetail, boolean replace) throws SchedulerException {
        this.scheduler.addJob(new SchedulingContext(instanceId), JobDetailSupport.newJobDetail(jobDetail), replace);
    }

    @Override
    public void deleteCalendar(String instanceId, String name) throws SchedulerException {
        this.scheduler.deleteCalendar(new SchedulingContext(instanceId), name);
    }

    @Override
    public boolean deleteJob(String instanceId, String jobName, String jobGroupName) throws SchedulerException {
        return this.scheduler.deleteJob(new SchedulingContext(instanceId), jobName, jobGroupName);
    }

    @Override
    public String[] getCalendarNames(String instanceId) throws SchedulerException {
        return this.scheduler.getCalendarNames(new SchedulingContext(instanceId));
    }

    @Override
    public CompositeData getJobDetail(String instanceId, String jobName, String jobGroupName) throws SchedulerException {
        return JobDetailSupport.toCompositeData(this.scheduler.getJobDetail(new SchedulingContext(instanceId), jobName, jobGroupName));
    }

    @Override
    public String[] getJobGroupNames(String instanceId) throws SchedulerException {
        return this.scheduler.getJobGroupNames(new SchedulingContext(instanceId));
    }

    @Override
    public String[] getJobNames(String instanceId, String groupName) throws SchedulerException {
        return this.scheduler.getJobNames(new SchedulingContext(instanceId), groupName);
    }

    @Override
    public String getJobStoreClassName() {
        return this.scheduler.getJobStoreClass().getName();
    }

    @Override
    public Set<String> getPausedTriggerGroups(String instanceId) throws SchedulerException {
        return this.scheduler.getPausedTriggerGroups(new SchedulingContext(instanceId));
    }

    @Override
    public CompositeData getTrigger(String instanceId, String triggerName, String triggerGroupName) throws SchedulerException {
        return TriggerSupport.toCompositeData(this.scheduler.getTrigger(new SchedulingContext(instanceId), triggerName, triggerGroupName));
    }

    @Override
    public String[] getTriggerGroupNames(String instanceId) throws SchedulerException {
        return this.scheduler.getTriggerGroupNames(new SchedulingContext(instanceId));
    }

    @Override
    public String[] getTriggerNames(String instanceId, String triggerGroupName) throws SchedulerException {
        return this.scheduler.getTriggerNames(new SchedulingContext(instanceId), triggerGroupName);
    }

    @Override
    public int getTriggerState(String instanceId, String triggerName, String triggerGroupName) throws SchedulerException {
        return this.scheduler.getTriggerState(new SchedulingContext(instanceId), triggerName, triggerGroupName);
    }

    @Override
    public TabularData getTriggersOfJob(String instanceId, String jobName, String jobGroupName) throws SchedulerException {
        return TriggerSupport.toTabularData(this.scheduler.getTriggersOfJob(new SchedulingContext(instanceId), jobName, jobGroupName));
    }

    @Override
    public boolean interruptJob(String instanceId, String jobName, String jobGroupName) throws UnableToInterruptJobException {
        return this.scheduler.interrupt(new SchedulingContext(instanceId), jobName, jobGroupName);
    }

    @Override
    public Date scheduleJob(String instanceId, String jobName, String jobGroup, String triggerName, String triggerGroup) throws SchedulerException {
        SchedulingContext cntx = new SchedulingContext(instanceId);
        JobDetail jobDetail = this.scheduler.getJobDetail(cntx, jobName, jobGroup);
        if (jobDetail == null) {
            throw new SchedulerException("No such job: " + jobName + "." + jobGroup);
        }
        Trigger trigger = this.scheduler.getTrigger(cntx, triggerName, triggerGroup);
        if (trigger == null) {
            throw new SchedulerException("No such trigger: " + triggerName + "." + triggerGroup);
        }
        return this.scheduler.scheduleJob(cntx, jobDetail, trigger);
    }

    @Override
    public boolean unscheduleJob(String instanceId, String triggerName, String triggerGroup) throws SchedulerException {
        SchedulingContext cntx = new SchedulingContext(instanceId);
        return this.scheduler.unscheduleJob(cntx, triggerName, triggerGroup);
    }

    @Override
    public String getVersion() {
        return this.scheduler.getVersion();
    }

    @Override
    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    @Override
    public boolean isStarted() {
        return this.scheduler.isStarted();
    }

    @Override
    public void start() throws SchedulerException {
        this.scheduler.start();
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
    }

    @Override
    public void standby() {
        this.scheduler.standby();
    }

    @Override
    public boolean isStandbyMode() {
        return this.scheduler.isInStandbyMode();
    }

    @Override
    public String getSchedulerName() {
        return this.scheduler.getSchedulerName();
    }

    @Override
    public String getSchedulerInstanceId() {
        return this.scheduler.getSchedulerInstanceId();
    }

    @Override
    public String getThreadPoolClassName() {
        return this.scheduler.getThreadPoolClass().getName();
    }

    @Override
    public int getThreadPoolSize() {
        return this.scheduler.getThreadPoolSize();
    }

    @Override
    public void pauseJob(String instanceId, String jobName, String groupName) throws SchedulerException {
        this.scheduler.pauseJob(new SchedulingContext(instanceId), jobName, groupName);
    }

    @Override
    public void pauseJobGroup(String instanceId, String jobGroupName) throws SchedulerException {
        this.scheduler.pauseJobGroup(new SchedulingContext(instanceId), jobGroupName);
    }

    @Override
    public void pauseAllTriggers(String instanceId) throws SchedulerException {
        this.scheduler.pauseAll(new SchedulingContext(instanceId));
    }

    @Override
    public void pauseTriggerGroup(String instanceId, String groupName) throws SchedulerException {
        this.scheduler.pauseTriggerGroup(new SchedulingContext(instanceId), groupName);
    }

    @Override
    public void pauseTrigger(String instanceId, String triggerName, String triggerGroup) throws SchedulerException {
        this.scheduler.pauseTrigger(new SchedulingContext(instanceId), triggerName, triggerGroup);
    }

    @Override
    public void resumeAllTriggers(String instanceId) throws SchedulerException {
        this.scheduler.resumeAll(new SchedulingContext(instanceId));
    }

    @Override
    public void resumeJob(String instanceId, String jobName, String jobGroupName) throws SchedulerException {
        this.scheduler.resumeJob(new SchedulingContext(instanceId), jobName, jobGroupName);
    }

    @Override
    public void resumeJobGroup(String instanceId, String jobGroupName) throws SchedulerException {
        this.scheduler.resumeJobGroup(new SchedulingContext(instanceId), jobGroupName);
    }

    @Override
    public void resumeTrigger(String instanceId, String triggerName, String triggerGroupName) throws SchedulerException {
        this.scheduler.resumeTrigger(new SchedulingContext(instanceId), triggerName, triggerGroupName);
    }

    @Override
    public void resumeTriggerGroup(String instanceId, String groupName) throws SchedulerException {
        this.scheduler.resumeTriggerGroup(new SchedulingContext(instanceId), groupName);
    }

    @Override
    public void triggerJobWithVolatileTrigger(String instanceId, String jobName, String jobGroupName, Map<String, String> jobDataMap) throws SchedulerException {
        this.scheduler.triggerJobWithVolatileTrigger(new SchedulingContext(instanceId), jobName, jobGroupName, new JobDataMap(jobDataMap));
    }

    @Override
    public void triggerJob(String instanceId, String jobName, String jobGroupName, Map<String, String> jobDataMap) throws SchedulerException {
        this.scheduler.triggerJob(new SchedulingContext(instanceId), jobName, jobGroupName, new JobDataMap(jobDataMap));
    }

    @Override
    public void jobAdded(JobDetail jobDetail) {
        this.sendNotification("jobAdded", JobDetailSupport.toCompositeData(jobDetail));
    }

    @Override
    public void jobDeleted(String jobName, String groupName) {
        this.sendNotification("jobDeleted", groupName + "." + jobName);
    }

    @Override
    public void jobScheduled(Trigger trigger) {
        this.sendNotification("jobScheduled", TriggerSupport.toCompositeData(trigger));
    }

    @Override
    public void jobUnscheduled(String triggerName, String triggerGroup) {
        this.sendNotification("jobUnscheduled", triggerGroup + "." + triggerName);
    }

    @Override
    public void jobsPaused(String jobName, String jobGroup) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobName", jobName);
        map.put("jobGroup", jobGroup);
        this.sendNotification("jobsPaused", map);
    }

    @Override
    public void jobsResumed(String jobName, String jobGroup) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobName", jobName);
        map.put("jobGroup", jobGroup);
        this.sendNotification("jobsResumed", map);
    }

    @Override
    public void schedulerError(String msg, SchedulerException cause) {
        this.sendNotification("schedulerError", cause.getErrorCode(), cause.getMessage());
    }

    @Override
    public void schedulerStarted() {
        this.sendNotification("schedulerStarted");
    }

    @Override
    public void schedulerInStandbyMode() {
        this.sendNotification("schedulerPaused");
    }

    @Override
    public void schedulerShutdown() {
        this.scheduler.removeSchedulerListener(this);
        this.scheduler.removeGlobalJobListener(this.getName());
        this.sendNotification("schedulerShutdown");
    }

    @Override
    public void triggerFinalized(Trigger trigger) {
        this.sendNotification("triggerFinalized", trigger.getFullName());
    }

    @Override
    public void triggersPaused(String triggerName, String triggerGroup) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("triggerName", triggerName);
        map.put("triggerGroup", triggerGroup);
        this.sendNotification("triggersPaused", map);
    }

    @Override
    public void triggersResumed(String triggerName, String triggerGroup) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("triggerName", triggerName);
        map.put("triggerGroup", triggerGroup);
        this.sendNotification("triggersResumed", map);
    }

    @Override
    public String getName() {
        return "QuartzSchedulerMBeanImpl.listener";
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext context) {
        try {
            this.sendNotification("jobExecutionVetoed", JobExecutionContextSupport.toCompositeData(context));
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext context) {
        try {
            this.sendNotification("jobToBeExecuted", JobExecutionContextSupport.toCompositeData(context));
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    @Override
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        try {
            this.sendNotification("jobWasExecuted", JobExecutionContextSupport.toCompositeData(context));
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    public void sendNotification(String eventType) {
        this.sendNotification(eventType, null, null);
    }

    public void sendNotification(String eventType, Object data) {
        this.sendNotification(eventType, data, null);
    }

    public void sendNotification(String eventType, Object data, String msg) {
        Notification notif = new Notification(eventType, this, this.sequenceNumber.incrementAndGet(), System.currentTimeMillis(), msg);
        if (data != null) {
            notif.setUserData(data);
        }
        this.emitter.sendNotification(notif);
    }

    @Override
    public void addNotificationListener(NotificationListener notif, NotificationFilter filter, Object callBack) {
        this.emitter.addNotificationListener(notif, filter, callBack);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notif, NotificationFilter filter, Object callBack) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(notif, filter, callBack);
    }

    @Override
    public synchronized boolean isSampledStatisticsEnabled() {
        return this.sampledStatisticsEnabled;
    }

    @Override
    public void setSampledStatisticsEnabled(boolean enabled) {
        if (enabled != this.sampledStatisticsEnabled) {
            this.sampledStatisticsEnabled = enabled;
            if (enabled) {
                this.sampledStatistics = new SampledStatisticsImpl(this.scheduler);
            } else {
                this.sampledStatistics.shutdown();
                this.sampledStatistics = NULL_SAMPLED_STATISTICS;
            }
            this.sendNotification("sampledStatisticsEnabled", enabled);
        }
    }

    @Override
    public long getJobsCompletedMostRecentSample() {
        return this.sampledStatistics.getJobsCompletedMostRecentSample();
    }

    @Override
    public long getJobsExecutedMostRecentSample() {
        return this.sampledStatistics.getJobsExecutingMostRecentSample();
    }

    @Override
    public long getJobsScheduledMostRecentSample() {
        return this.sampledStatistics.getJobsScheduledMostRecentSample();
    }

    @Override
    public Map<String, Long> getPerformanceMetrics() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("JobsCompleted", this.getJobsCompletedMostRecentSample());
        result.put("JobsExecuted", this.getJobsExecutedMostRecentSample());
        result.put("JobsScheduled", this.getJobsScheduledMostRecentSample());
        return result;
    }

    static {
        NULL_SAMPLED_STATISTICS = new NullSampledStatisticsImpl();
        String[] notifTypes = new String[]{"schedulerStarted", "schedulerPaused", "schedulerShutdown"};
        String name = Notification.class.getName();
        String description = "QuartzScheduler JMX Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "QuartzScheduler JMX Event")};
    }

    private class Emitter
    extends NotificationBroadcasterSupport {
        private Emitter() {
        }

        public MBeanNotificationInfo[] getNotificationInfo() {
            return QuartzSchedulerMBeanImpl.this.getNotificationInfo();
        }
    }
}

