/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractWritePropertiesMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputFile;

    protected void writeProperties(Properties properties, File file) throws MojoExecutionException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            properties.store(fos, "Properties");
        }
        catch (FileNotFoundException e) {
            this.getLog().error("Could not create FileOutputStream: " + fos);
            throw new MojoExecutionException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.getLog().error("Error writing properties: " + fos);
            throw new MojoExecutionException(e.getMessage(), e);
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            this.getLog().error("Error closing FileOutputStream: " + fos);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void validateOutputFile() throws MojoExecutionException {
        if (this.outputFile.isDirectory()) {
            throw new MojoExecutionException("outputFile must be a file and not a directory");
        }
        if (this.outputFile.getParentFile() != null) {
            this.outputFile.getParentFile().mkdirs();
        }
    }
}

