/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileNotFoundException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs.provider.sftp.SftpRandomAccessContent;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

public class SftpFileObject
extends AbstractFileObject
implements FileObject {
    private final SftpFileSystem fileSystem;
    private SftpATTRS attrs;
    private final String relPath;
    private boolean inRefresh;

    protected SftpFileObject(FileName name, SftpFileSystem fileSystem) throws FileSystemException {
        super(name, fileSystem);
        this.fileSystem = fileSystem;
        this.relPath = UriParser.decode(fileSystem.getRootName().getRelativeName(name));
    }

    protected void doDetach() throws Exception {
        this.attrs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                try {
                    this.attrs = null;
                    this.getType();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    protected FileType doGetType() throws Exception {
        if (this.attrs == null) {
            this.statSelf();
        }
        if (this.attrs == null) {
            return FileType.IMAGINARY;
        }
        if ((this.attrs.getFlags() & 4) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-permissions.error");
        }
        if (this.attrs.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected void onChange() throws Exception {
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statSelf() throws Exception {
        block8: {
            ChannelSftp channel = this.fileSystem.getChannel();
            try {
                this.setStat(channel.stat(this.relPath));
            }
            catch (SftpException e) {
                try {
                    if (e.id != 2) {
                        channel.disconnect();
                        channel = this.fileSystem.getChannel();
                        this.setStat(channel.stat(this.relPath));
                        break block8;
                    }
                    this.attrs = null;
                }
                catch (SftpException e2) {
                    this.attrs = null;
                }
            }
            finally {
                this.fileSystem.putChannel(channel);
            }
        }
    }

    private void setStat(SftpATTRS attrs) {
        this.attrs = attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            channel.mkdir(this.relPath);
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 8) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-modtime.error");
        }
        return (long)this.attrs.getMTime() * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetLastModifiedTime(long modtime) throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            int newMTime = (int)(modtime / 1000L);
            this.attrs.setACMODTIME(this.attrs.getATime(), newMTime);
            channel.setStat(this.relPath, this.attrs);
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            if (this.getType() == FileType.FILE) {
                channel.rm(this.relPath);
            } else {
                channel.rmdir(this.relPath);
            }
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRename(FileObject newfile) throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            channel.rename(this.relPath, ((SftpFileObject)newfile).relPath);
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject[] doListChildrenResolved() throws Exception {
        Vector vector;
        ChannelSftp channel = this.fileSystem.getChannel();
        String workingDirectory = null;
        try {
            try {
                if (this.relPath != null) {
                    workingDirectory = channel.pwd();
                    channel.cd(this.relPath);
                }
            }
            catch (SftpException e) {
                FileObject[] fileObjectArray = null;
                this.fileSystem.putChannel(channel);
                return fileObjectArray;
            }
            vector = channel.ls(".");
            try {
                if (this.relPath != null) {
                    channel.cd(workingDirectory);
                }
            }
            catch (SftpException e) {
                throw new FileSystemException("vfs.provider.sftp/change-work-directory-back.error", workingDirectory);
            }
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
        if (vector == null) {
            throw new FileSystemException("vfs.provider.sftp/list-children.error");
        }
        ArrayList<FileObject> children = new ArrayList<FileObject>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ChannelSftp.LsEntry stat2 = (ChannelSftp.LsEntry)iterator.next();
            String name = stat2.getFilename();
            if (VFS.isUriStyle() && stat2.getAttrs().isDir() && name.charAt(name.length() - 1) != '/') {
                name = name + "/";
            }
            if (name.equals(".") || name.equals("..") || name.equals("./") || name.equals("../")) continue;
            FileObject fo = this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), UriParser.encode(name), NameScope.CHILD));
            ((SftpFileObject)FileObjectUtils.getAbstractFileObject(fo)).setStat(stat2.getAttrs());
            children.add(fo);
        }
        return children.toArray(new FileObject[children.size()]);
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected long doGetContentSize() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 1) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-size.error");
        }
        return this.attrs.getSize();
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new SftpRandomAccessContent(this, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream getInputStream(long filePointer) throws IOException {
        ChannelSftp channel = this.fileSystem.getChannel();
        try {
            ByteArrayOutputStream outstr = new ByteArrayOutputStream();
            try {
                channel.get(this.getName().getPathDecoded(), (OutputStream)outstr, null, 1, filePointer);
            }
            catch (SftpException e) {
                throw new FileSystemException(e);
            }
            outstr.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outstr.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            this.fileSystem.putChannel(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream() throws Exception {
        SftpFileSystem sftpFileSystem = this.fileSystem;
        synchronized (sftpFileSystem) {
            InputStream is;
            ChannelSftp channel = this.fileSystem.getChannel();
            try {
                if (!this.getType().hasContent()) {
                    throw new FileSystemException("vfs.provider/read-not-file.error", this.getName());
                }
                is = channel.get(this.relPath);
            }
            catch (SftpException e) {
                if (e.id == 2) {
                    throw new FileNotFoundException(this.getName());
                }
                throw new FileSystemException(e);
            }
            SftpInputStream sftpInputStream = new SftpInputStream(channel, is);
            return sftpInputStream;
        }
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        ChannelSftp channel = this.fileSystem.getChannel();
        return new SftpOutputStream(channel, channel.put(this.relPath));
    }

    private class SftpOutputStream
    extends MonitorOutputStream {
        private final ChannelSftp channel;

        public SftpOutputStream(ChannelSftp channel, OutputStream out) {
            super(out);
            this.channel = channel;
        }

        protected void onClose() throws IOException {
            SftpFileObject.this.fileSystem.putChannel(this.channel);
        }
    }

    private class SftpInputStream
    extends MonitorInputStream {
        private final ChannelSftp channel;

        public SftpInputStream(ChannelSftp channel, InputStream in) {
            super(in);
            this.channel = channel;
        }

        protected void onClose() throws IOException {
            SftpFileObject.this.fileSystem.putChannel(this.channel);
        }
    }
}

