/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.option.GroupImpl;

public class GroupBuilder {
    private String name;
    private String description;
    private List options;
    private int minimum;
    private int maximum;
    private boolean required;

    public GroupBuilder() {
        this.reset();
    }

    public Group create() {
        GroupImpl group2 = new GroupImpl(this.options, this.name, this.description, this.minimum, this.maximum, this.required);
        this.reset();
        return group2;
    }

    public GroupBuilder reset() {
        this.name = null;
        this.description = null;
        this.options = new ArrayList();
        this.minimum = 0;
        this.maximum = Integer.MAX_VALUE;
        this.required = true;
        return this;
    }

    public GroupBuilder withDescription(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public GroupBuilder withName(String newName) {
        this.name = newName;
        return this;
    }

    public GroupBuilder withMinimum(int newMinimum) {
        this.minimum = newMinimum;
        return this;
    }

    public GroupBuilder withMaximum(int newMaximum) {
        this.maximum = newMaximum;
        return this;
    }

    public GroupBuilder withOption(Option option) {
        this.options.add(option);
        return this;
    }

    public GroupBuilder withRequired(boolean newRequired) {
        this.required = newRequired;
        return this;
    }
}

