/*
 * Decompiled with CFR 0.152.
 */
package jnacontrib.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.util.ArrayList;
import jnacontrib.jna.Options;
import jnacontrib.jna.WINBASE;

public interface Advapi32
extends StdCallLibrary {
    public static final Advapi32 INSTANCE = (Advapi32)Native.loadLibrary("Advapi32", Advapi32.class, Options.UNICODE_OPTIONS);
    public static final int SC_STATUS_PROCESS_INFO = 0;
    public static final int SERVICE_CONFIG_DESCRIPTION = 1;
    public static final int SERVICE_RUNNING = 4;
    public static final int SERVICE_STOPPED = 1;
    public static final int SERVICE_PAUSED = 7;
    public static final int SERVICE_START_PENDING = 2;
    public static final int SERVICE_STOP_PENDING = 3;
    public static final int SC_ACTION_NONE = 0;
    public static final int SC_ACTION_REBOOT = 2;
    public static final int SC_ACTION_RESTART = 1;
    public static final int SC_ACTION_RUN_COMMAND = 3;
    public static final int SERVICE_DISABLED = 4;
    public static final int SERVICE_INTERACTIVE_PROCESS = 256;
    public static final int SERVICE_AUTO_START = 2;
    public static final int SERVICE_BOOT_START = 0;
    public static final int SERVICE_DEMAND_START = 3;
    public static final int SERVICE_SYSTEM_START = 1;

    public boolean LookupAccountName(String var1, String var2, byte[] var3, IntByReference var4, char[] var5, IntByReference var6, PointerByReference var7);

    public boolean LookupAccountSid(String var1, byte[] var2, char[] var3, IntByReference var4, char[] var5, IntByReference var6, PointerByReference var7);

    public boolean ConvertSidToStringSid(byte[] var1, PointerByReference var2);

    public boolean ConvertStringSidToSid(String var1, PointerByReference var2);

    public Pointer OpenSCManager(String var1, WString var2, int var3);

    public boolean CloseServiceHandle(Pointer var1);

    public Pointer OpenService(Pointer var1, String var2, int var3);

    public boolean StartService(Pointer var1, int var2, char[] var3);

    public boolean ControlService(Pointer var1, int var2, SERVICE_STATUS var3);

    public boolean StartServiceCtrlDispatcher(Structure[] var1);

    public Pointer RegisterServiceCtrlHandler(String var1, Handler var2);

    public Pointer RegisterServiceCtrlHandlerEx(String var1, HandlerEx var2, Pointer var3);

    public boolean SetServiceStatus(Pointer var1, SERVICE_STATUS var2);

    public Pointer CreateService(Pointer var1, String var2, String var3, int var4, int var5, int var6, int var7, String var8, String var9, IntByReference var10, String var11, String var12, String var13);

    public boolean DeleteService(Pointer var1);

    public boolean ChangeServiceConfig2(Pointer var1, int var2, ChangeServiceConfig2Info var3);

    public int RegOpenKeyEx(int var1, String var2, int var3, int var4, IntByReference var5);

    public int RegQueryValueEx(int var1, String var2, IntByReference var3, IntByReference var4, byte[] var5, IntByReference var6);

    public int RegCloseKey(int var1);

    public int RegDeleteValue(int var1, String var2);

    public int RegSetValueEx(int var1, String var2, int var3, int var4, byte[] var5, int var6);

    public int RegCreateKeyEx(int var1, String var2, int var3, String var4, int var5, int var6, WINBASE.SECURITY_ATTRIBUTES var7, IntByReference var8, IntByReference var9);

    public int RegDeleteKey(int var1, String var2);

    public int RegEnumKeyEx(int var1, int var2, char[] var3, IntByReference var4, IntByReference var5, char[] var6, IntByReference var7, WINBASE.FILETIME var8);

    public int RegEnumValue(int var1, int var2, char[] var3, IntByReference var4, IntByReference var5, IntByReference var6, byte[] var7, IntByReference var8);

    public boolean QueryServiceConfig(Pointer var1, Memory var2, int var3, IntByReference var4);

    public boolean QueryServiceStatusEx(Pointer var1, short var2, Memory var3, int var4, IntByReference var5);

    public boolean QueryServiceConfig2(Pointer var1, short var2, Memory var3, int var4, IntByReference var5);

    public boolean EnumServicesStatusExW(Pointer var1, int var2, int var3, int var4, Memory var5, int var6, IntByReference var7, IntByReference var8, IntByReference var9, String var10);

    public static class SERVICE_FAILURE_ACTIONS
    extends ChangeServiceConfig2Info {
        public int dwResetPeriod;
        public String lpRebootMsg;
        public String lpCommand;
        public int cActions;
        public Pointer lpsaActions;
    }

    public static class SC_ACTION
    extends Structure {
        public int Type;
        public int Delay;

        public SC_ACTION() {
            this.setAutoWrite(true);
            this.setAutoRead(false);
        }
    }

    public static class SERVICE_DELAYED_AUTO_START_INFO
    extends ChangeServiceConfig2Info {
        public boolean fDelayedAutostart;

        public void init(Pointer pointer) {
            this.useMemory(pointer);
            this.read();
        }
    }

    public static class SERVICE_DESCRIPTION
    extends ChangeServiceConfig2Info {
        public String lpDescription;

        public void init(Pointer pointer) {
            this.useMemory(pointer);
            this.read();
        }
    }

    public static class QUERY_SERVICE_CONFIG
    extends Structure {
        public int dwServiceType;
        public int dwStartType;
        public int dwErrorControl;
        public String lpBinaryPathName;
        public String lpLoadOrderGroup;
        public int dwTagId;
        public Pointer lpDependencies;
        public String lpServiceStartName;
        public String lpDisplayName;

        public void init(Pointer pointer) {
            this.useMemory(pointer);
            this.read();
        }

        public String[] getDependencies() {
            ArrayList<String> result = new ArrayList<String>();
            Pointer ptr = this.lpDependencies;
            int offset = 0;
            String s = "";
            if (ptr != null) {
                do {
                    if ((s = ptr.getString(offset, true)) == null || "".equals(s)) continue;
                    result.add(s);
                    offset += s.getBytes().length * 2 + 2;
                } while (s != null && !"".equals(s));
            }
            return result.toArray(new String[0]);
        }
    }

    public static class SERVICE_STATUS_PROCESS
    extends Structure {
        public int dwServiceType;
        public int dwCurrentState;
        public int dwControlsAccepted;
        public int dwWin32ExitCode;
        public int dwServiceSpecificExitCode;
        public int dwCheckPoint;
        public int dwWaitHint;
        public int dwProcessId;
        public int dwServiceFlags;

        public void init(Pointer pointer) {
            this.useMemory(pointer);
            this.read();
        }
    }

    public static class ENUM_SERVICE_STATUS_PROCESS
    extends Structure {
        public Pointer lpServiceName;
        public Pointer lpDisplayName;
        public SERVICE_STATUS_PROCESS ServiceStatusProcess;

        public void init(Pointer pointer) {
            this.useMemory(pointer);
            this.read();
        }

        public ENUM_SERVICE_STATUS_PROCESS next() {
            ENUM_SERVICE_STATUS_PROCESS next = new ENUM_SERVICE_STATUS_PROCESS();
            next.useMemory(this.getPointer(), this.size());
            next.read();
            return next;
        }

        public String getServiceName() {
            return this.lpServiceName.getString(0L, true);
        }

        public String getDisplayName() {
            return this.lpDisplayName.getString(0L, true);
        }

        public int getProcessId() {
            return this.ServiceStatusProcess.dwProcessId;
        }

        public int getCurrentState() {
            return this.ServiceStatusProcess.dwCurrentState;
        }
    }

    public static class ChangeServiceConfig2Info
    extends Structure {
    }

    public static class SERVICE_TABLE_ENTRY
    extends Structure {
        public String lpServiceName;
        public SERVICE_MAIN_FUNCTION lpServiceProc;
    }

    public static class SERVICE_STATUS
    extends Structure {
        public int dwServiceType;
        public int dwCurrentState;
        public int dwControlsAccepted;
        public int dwWin32ExitCode;
        public int dwServiceSpecificExitCode;
        public int dwCheckPoint;
        public int dwWaitHint;
    }

    public static interface HandlerEx
    extends StdCallLibrary.StdCallCallback {
        public int callback(int var1, int var2, Pointer var3, Pointer var4);
    }

    public static interface Handler
    extends StdCallLibrary.StdCallCallback {
        public void callback(int var1);
    }

    public static interface SERVICE_MAIN_FUNCTION
    extends StdCallLibrary.StdCallCallback {
        public void callback(int var1, Pointer var2);
    }
}

