/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.mcast.discovery;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.ipfilter.IpFilterRule;
import org.jboss.netty.handler.ipfilter.IpFilterRuleList;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.mcast.MulticastEndpoint;
import org.rzo.netty.mcast.discovery.DiscoveryListener;

public class DiscoveryClient
extends MulticastEndpoint {
    private String name;
    private Set<String> hosts = Collections.synchronizedSet(new HashSet());
    private volatile boolean stop = false;
    private Set<DiscoveryListener> listeners = Collections.synchronizedSet(new HashSet());
    private static Executor executor = Executors.newCachedThreadPool();
    private IpFilterRuleList firewall;

    public void init() throws Exception {
        ChannelPipelineFactory factory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("discoveryClient", new SimpleChannelUpstreamHandler(){

                    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                        try {
                            String response = DiscoveryClient.this.getStringMessage(e);
                            if (response == null) {
                                return;
                            }
                            String[] resp = response.split("&");
                            if (resp.length == 3) {
                                String remoteName = resp[0];
                                if (!DiscoveryClient.this.name.equals(remoteName)) {
                                    return;
                                }
                                if (!DiscoveryClient.this.validate(e)) {
                                    return;
                                }
                                String host = resp[1];
                                InetAddress.getByName(host);
                                int port = Integer.parseInt(resp[2]);
                                if (!DiscoveryClient.this.hosts.contains(response)) {
                                    DiscoveryClient.this.hosts.add(response);
                                    for (DiscoveryListener listener : DiscoveryClient.this.listeners) {
                                        listener.newHost(DiscoveryClient.this.name, response);
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            Constants.ahessianLogger.warn("", ex);
                        }
                    }
                });
                return pipeline;
            }
        };
        super.init(factory);
    }

    public void start() throws Exception {
        this.stop = false;
        this.discoverServices();
    }

    private void discoverServices() throws Exception {
        executor.execute(new Runnable(){

            public void run() {
                while (!DiscoveryClient.this.stop) {
                    try {
                        DiscoveryClient.this.send(ChannelBuffers.wrappedBuffer(DiscoveryClient.this.name.getBytes()));
                    }
                    catch (Exception e) {
                        Constants.ahessianLogger.warn("", e);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Constants.ahessianLogger.warn("", e);
                    }
                }
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void stop() {
        this.stop = true;
    }

    public void addListener(DiscoveryListener listener) {
        this.listeners.add(listener);
    }

    public void removeHost(String host) {
        this.hosts.remove(host);
    }

    private boolean validate(MessageEvent e) {
        if (this.firewall == null) {
            return true;
        }
        InetAddress inetAddress = ((InetSocketAddress)e.getRemoteAddress()).getAddress();
        Iterator iterator = this.firewall.iterator();
        IpFilterRule ipFilterRule = null;
        while (iterator.hasNext()) {
            ipFilterRule = (IpFilterRule)iterator.next();
            if (!ipFilterRule.contains(inetAddress)) continue;
            return ipFilterRule.isAllowRule();
        }
        return true;
    }

    public void setIpSet(IpFilterRuleList ipSet) {
        this.firewall = ipSet;
    }
}

