/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.mcast;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.oio.OioDatagramChannelFactory;

public class MulticastEndpoint {
    private String mcastGroupIp = "228.10.10.10";
    private int mcastGroupPort = 12345;
    private String bindAddress = "192.168.0.10";
    private DatagramChannel datagramChannel;
    private ConnectionlessBootstrap connectionlessBootstrap;
    private InetSocketAddress multicastAddress;
    private static Executor executor = Executors.newCachedThreadPool();
    byte[] id;
    boolean init = false;

    public void init(ChannelPipelineFactory factory) throws Exception {
        this.id = String.format("%1$020d", Math.abs(new Random(System.currentTimeMillis()).nextLong())).getBytes();
        OioDatagramChannelFactory datagramChannelFactory = new OioDatagramChannelFactory(executor);
        this.connectionlessBootstrap = new ConnectionlessBootstrap(datagramChannelFactory);
        this.connectionlessBootstrap.setOption("broadcast", true);
        this.connectionlessBootstrap.setPipelineFactory(factory);
        this.datagramChannel = (DatagramChannel)this.connectionlessBootstrap.bind(new InetSocketAddress(this.mcastGroupPort));
        this.multicastAddress = new InetSocketAddress(this.mcastGroupIp, this.mcastGroupPort);
        NetworkInterface networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(this.bindAddress));
        this.datagramChannel.joinGroup(this.multicastAddress, networkInterface);
        this.init = true;
    }

    public boolean isInit() {
        return this.init;
    }

    public void send(ChannelBuffer msg) throws Exception {
        ChannelBuffer idbuf = ChannelBuffers.wrappedBuffer(this.id);
        this.datagramChannel.write(ChannelBuffers.wrappedBuffer(idbuf, msg), this.multicastAddress);
    }

    public String getMcastGroupIp() {
        return this.mcastGroupIp;
    }

    public int getMcastGroupPort() {
        return this.mcastGroupPort;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setMcastGroupIp(String mcastGroupIp) {
        this.mcastGroupIp = mcastGroupIp;
    }

    public void setMcastGroupPort(int mcastGroupPort) {
        this.mcastGroupPort = mcastGroupPort;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void close() {
        this.datagramChannel.close();
        this.connectionlessBootstrap.releaseExternalResources();
    }

    public ChannelBuffer getMessage(MessageEvent e) {
        if (this.checkMessage(e)) {
            ChannelBuffer m = (ChannelBuffer)e.getMessage();
            return m.slice(this.id.length, m.readableBytes() - this.id.length);
        }
        return null;
    }

    public String getStringMessage(MessageEvent e) {
        ChannelBuffer m = this.getMessage(e);
        if (m == null) {
            return null;
        }
        return m.toString(Charset.defaultCharset());
    }

    public boolean checkMessage(MessageEvent e) {
        byte[] eId = new byte[this.id.length];
        ((ChannelBuffer)e.getMessage()).getBytes(0, eId, 0, eId.length);
        return !Arrays.equals(this.id, eId);
    }
}

