/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.message;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import java.io.OutputStream;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.OutputStreamEncoder;
import org.rzo.netty.ahessian.rpc.io.Hessian2Output;
import org.rzo.netty.ahessian.rpc.message.FlushRequestMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;

@ChannelPipelineCoverage(value="one")
public class HessianRPCReplyEncoder
extends SimpleChannelHandler {
    volatile Hessian2Output hOut = null;
    volatile AbstractSerializerFactory _serializerFactory;

    public HessianRPCReplyEncoder() {
        this(null);
    }

    public HessianRPCReplyEncoder(AbstractSerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
    }

    public synchronized void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof FlushRequestMessage) {
            this.hOut.flush(e.getFuture());
            e.getFuture().await(5000L);
            return;
        }
        try {
            HessianRPCReplyMessage message = (HessianRPCReplyMessage)e.getMessage();
            this.hOut.resetReferences();
            this.hOut.writeReply(message);
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", ex);
            e.getFuture().setFailure(ex);
        }
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.hOut == null) {
            OutputStream out = OutputStreamEncoder.getOutputStream(ctx);
            this.hOut = new Hessian2Output(out);
            if (this._serializerFactory != null) {
                this.hOut.getSerializerFactory().addFactory(this._serializerFactory);
            }
        } else {
            this.hOut.reset();
        }
        ctx.sendUpstream(e);
    }
}

