/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.callback;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.Callback;
import org.rzo.netty.ahessian.rpc.callback.CallbackReplyMessage;

public class ClientCallback
implements Serializable {
    private transient Callback _callback;
    private Long _id;
    private String _callbackClass;
    private static final AtomicLong _idCounter = new AtomicLong();
    private transient boolean _done = false;

    public ClientCallback() {
    }

    public ClientCallback(Callback callback) {
        this._callback = callback;
        this._id = _idCounter.getAndIncrement();
        this._callbackClass = this._callback.getClass().getName();
    }

    public Long getId() {
        return this._id;
    }

    public void invoke(CallbackReplyMessage message) {
        try {
            Method[] methods;
            String methodName = message.getMethod();
            Object[] args = message.getArgs();
            for (Method method : methods = this._callback.getClass().getMethods()) {
                if (!methodName.equals(method.getName()) || method.getParameterTypes().length != args.length) continue;
                method.invoke((Object)this._callback, args);
                break;
            }
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", ex);
        }
    }

    public String getCallbackClass() {
        return this._callbackClass;
    }
}

