/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import com.caucho.hessian4.io.FlushableOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.rzo.netty.ahessian.Constants;

public class OutputStreamBuffer
extends OutputStream
implements FlushableOutput {
    private volatile ChannelHandlerContext _ctx;
    private volatile boolean _closed = false;
    private Lock _lock = new ReentrantLock();
    int _watermark = 0x100000;
    int _initialBuffSize = 1024;
    private ChannelBuffer _buf = ChannelBuffers.dynamicBuffer(this._initialBuffSize);

    OutputStreamBuffer(ChannelHandlerContext ctx) {
        this._ctx = ctx;
    }

    public void write(int b) throws IOException {
        if (this._closed) {
            throw new IOException("stream closed");
        }
        this._lock.lock();
        this._buf.writeByte((byte)b);
        if (this._buf.writerIndex() >= this._watermark) {
            this.sendDownstream(null);
        }
        this._lock.unlock();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this._closed) {
            throw new IOException("stream closed");
        }
        this._lock.lock();
        this._buf.writeBytes(b, off, len);
        if (this._buf.writerIndex() >= this._watermark) {
            this.sendDownstream(null);
        }
        this._lock.unlock();
    }

    public void flush() throws IOException {
        this.flush(null);
    }

    public void flush(ChannelFuture future) throws IOException {
        this._lock.lock();
        if (this._buf.readableBytes() > 0) {
            try {
                super.flush();
                if (future == null) {
                    ChannelFuture f = this.sendDownstream(null);
                    f.await(20000L);
                } else {
                    this.sendDownstream(future);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                this._lock.unlock();
            }
        }
    }

    private ChannelFuture sendDownstream(ChannelFuture future) throws IOException {
        if (!this._ctx.getChannel().isConnected()) {
            throw new IOException("channel disconnected");
        }
        while (!this._ctx.getChannel().isWritable()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                Constants.ahessianLogger.warn("", ex);
            }
        }
        if (future == null) {
            future = Channels.future(this._ctx.getChannel());
        }
        this._ctx.sendDownstream(new DownstreamMessageEvent(this._ctx.getChannel(), future, this._buf, this._ctx.getChannel().getRemoteAddress()));
        this._buf = ChannelBuffers.dynamicBuffer(1024);
        this._buf.clear();
        return future;
    }

    public void close() throws IOException {
        this._lock.lock();
        this._closed = true;
        this._lock.unlock();
    }

    public void setContext(ChannelHandlerContext ctx) {
        this._ctx = ctx;
        this.reset();
    }

    public ChannelHandlerContext getContext() {
        return this._ctx;
    }

    public void reset() {
        this._lock.lock();
        this._buf = ChannelBuffers.dynamicBuffer();
        this._closed = false;
        this._lock.unlock();
    }
}

