/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.rzo.netty.ahessian.io.CRCInputStream;
import org.rzo.netty.ahessian.io.InputStreamBuffer;
import org.rzo.netty.ahessian.stopable.StopableHandler;

public class InputStreamDecoder
extends SimpleChannelUpstreamHandler
implements StopableHandler {
    InputStreamBuffer _in = null;
    boolean _stopEnabled = true;
    boolean _crcCheck = false;

    public InputStreamDecoder() {
    }

    public InputStreamDecoder(boolean crcCheck) {
        this._crcCheck = crcCheck;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this._in.write((ChannelBuffer)e.getMessage());
        Channels.fireMessageReceived(ctx, (Object)this._in, e.getRemoteAddress());
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this._in == null) {
            this._in = this._crcCheck ? new CRCInputStream() : new InputStreamBuffer();
            ctx.setAttachment(this._in);
        }
        ctx.sendUpstream(e);
    }

    public static InputStreamBuffer getInputStream(ChannelHandlerContext ctx) {
        return (InputStreamBuffer)ctx.getPipeline().getContext(InputStreamDecoder.class).getAttachment();
    }

    public boolean isStopEnabled() {
        return this._stopEnabled;
    }

    public void setStopEnabled(boolean stopEnabled) {
        this._stopEnabled = stopEnabled;
    }

    public void stop() {
        try {
            this._in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._in = null;
    }
}

