/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.auth;

import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.rzo.netty.ahessian.auth.AuthToken;

public class SimpleAuthToken
implements AuthToken {
    byte[] _password;
    byte[] _receivedBytes;
    int _receivedLength = 0;
    boolean _loggedOn = false;
    int _length = -1;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SimpleAuthToken.class);

    public void setPassword(String password) {
        this._password = this.ensureLength(password.getBytes());
        this._receivedBytes = new byte[this._password.length];
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int authenticate(ChannelHandlerContext ctx, MessageEvent e) {
        ChannelBuffer b = (ChannelBuffer)e.getMessage();
        int toCopy = Math.min(this._receivedBytes.length - this._receivedLength, b.readableBytes());
        byte[] bytes = new byte[toCopy];
        b.readBytes(bytes);
        System.arraycopy(bytes, 0, this._receivedBytes, this._receivedLength, bytes.length);
        this._receivedLength += toCopy;
        if (this._receivedLength == this._password.length) {
            if (Arrays.equals(this._receivedBytes, this._password)) {
                logger.info("authenticated");
                if (b.readableBytes() != 0) {
                    ctx.sendUpstream(e);
                }
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public void sendPassword(ChannelHandlerContext ctx) {
        Channels.write(ctx, Channels.future(ctx.getChannel()), ChannelBuffers.wrappedBuffer(this._password));
    }

    public boolean isLoggedOn() {
        return this._loggedOn;
    }

    void setLoggedOn(boolean loggedOn) {
        this._loggedOn = loggedOn;
    }

    public void disconnected() {
        this.setLoggedOn(false);
    }

    byte[] ensureLength(byte[] bytes) {
        if (bytes.length == this._length || this._length <= 0) {
            return bytes;
        }
        return Arrays.copyOf(bytes, this._length);
    }

    byte[] getPassword() {
        return this._password;
    }
}

