/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobPersistenceException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.JobRunShellFactory;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.SchedulingContext;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunShell
implements Runnable {
    protected JobExecutionContext jec = null;
    protected QuartzScheduler qs = null;
    protected Scheduler scheduler = null;
    protected SchedulingContext schdCtxt = null;
    protected JobRunShellFactory jobRunShellFactory = null;
    protected boolean shutdownRequested = false;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public JobRunShell(JobRunShellFactory jobRunShellFactory, Scheduler scheduler, SchedulingContext schdCtxt) {
        this.jobRunShellFactory = jobRunShellFactory;
        this.scheduler = scheduler;
        this.schdCtxt = schdCtxt;
    }

    protected Logger getLog() {
        return this.log;
    }

    public void initialize(QuartzScheduler qs, TriggerFiredBundle firedBundle) throws SchedulerException {
        this.qs = qs;
        Job job = null;
        JobDetail jobDetail = firedBundle.getJobDetail();
        try {
            job = qs.getJobFactory().newJob(firedBundle);
        }
        catch (SchedulerException se) {
            qs.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getFullName() + "'", se);
            throw se;
        }
        catch (Throwable ncdfe) {
            SchedulerException se = new SchedulerException("Problem instantiating class '" + jobDetail.getJobClass().getName() + "' - ", ncdfe);
            qs.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + jobDetail.getFullName() + "'", se);
            throw se;
        }
        this.jec = new JobExecutionContext(this.scheduler, firedBundle, job);
    }

    public void requestShutdown() {
        this.shutdownRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block29: {
            try {
                int instCode;
                Trigger trigger = this.jec.getTrigger();
                JobDetail jobDetail = this.jec.getJobDetail();
                while (true) {
                    long startTime;
                    Job job;
                    JobExecutionException jobExEx;
                    block30: {
                        jobExEx = null;
                        job = this.jec.getJobInstance();
                        try {
                            this.begin();
                        }
                        catch (SchedulerException se) {
                            this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getFullName() + ": couldn't begin execution.", se);
                            break block29;
                        }
                        try {
                            if (!this.notifyListenersBeginning(this.jec)) {
                            }
                            break block30;
                        }
                        catch (VetoedException ve) {
                            try {
                                int instCode2 = trigger.executionComplete(this.jec, null);
                                try {
                                    this.qs.notifyJobStoreJobVetoed(this.schdCtxt, trigger, jobDetail, instCode2);
                                }
                                catch (JobPersistenceException jpe) {
                                    this.vetoedJobRetryLoop(trigger, jobDetail, instCode2);
                                }
                                this.complete(true);
                                break block29;
                            }
                            catch (SchedulerException se) {
                                this.qs.notifySchedulerListenersError("Error during veto of Job (" + this.jec.getJobDetail().getFullName() + ": couldn't finalize execution.", se);
                            }
                        }
                        break block29;
                    }
                    long endTime = startTime = System.currentTimeMillis();
                    try {
                        this.log.debug("Calling execute on job " + jobDetail.getFullName());
                        job.execute(this.jec);
                        endTime = System.currentTimeMillis();
                    }
                    catch (JobExecutionException jee) {
                        endTime = System.currentTimeMillis();
                        jobExEx = jee;
                        this.getLog().info("Job " + jobDetail.getFullName() + " threw a JobExecutionException: ", jobExEx);
                    }
                    catch (Throwable e) {
                        endTime = System.currentTimeMillis();
                        this.getLog().error("Job " + jobDetail.getFullName() + " threw an unhandled Exception: ", e);
                        SchedulerException se = new SchedulerException("Job threw an unhandled exception.", e);
                        se.setErrorCode(800);
                        this.qs.notifySchedulerListenersError("Job (" + this.jec.getJobDetail().getFullName() + " threw an exception.", se);
                        jobExEx = new JobExecutionException(se, false);
                        jobExEx.setErrorCode(800);
                    }
                    this.jec.setJobRunTime(endTime - startTime);
                    if (!this.notifyJobListenersComplete(this.jec, jobExEx)) {
                        break block29;
                    }
                    instCode = 0;
                    try {
                        instCode = trigger.executionComplete(this.jec, jobExEx);
                    }
                    catch (Exception e) {
                        SchedulerException se = new SchedulerException("Trigger threw an unhandled exception.", e);
                        se.setErrorCode(850);
                        this.qs.notifySchedulerListenersError("Please report this error to the Quartz developers.", se);
                    }
                    if (!this.notifyTriggerListenersComplete(this.jec, instCode)) {
                        break block29;
                    }
                    if (instCode == 1) {
                        this.jec.incrementRefireCount();
                        try {
                            this.complete(false);
                        }
                        catch (SchedulerException se) {
                            this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getFullName() + ": couldn't finalize execution.", se);
                        }
                        continue;
                    }
                    try {
                        this.complete(true);
                    }
                    catch (SchedulerException se) {
                        this.qs.notifySchedulerListenersError("Error executing Job (" + this.jec.getJobDetail().getFullName() + ": couldn't finalize execution.", se);
                        continue;
                    }
                    break;
                }
                try {
                    this.qs.notifyJobStoreJobComplete(this.schdCtxt, trigger, jobDetail, instCode);
                }
                catch (JobPersistenceException jpe) {
                    this.qs.notifySchedulerListenersError("An error occured while marking executed job complete. job= '" + jobDetail.getFullName() + "'", jpe);
                    if (!this.completeTriggerRetryLoop(trigger, jobDetail, instCode)) {
                        this.jobRunShellFactory.returnJobRunShell(this);
                        return;
                    }
                }
            }
            finally {
                this.jobRunShellFactory.returnJobRunShell(this);
            }
        }
    }

    protected void begin() throws SchedulerException {
    }

    protected void complete(boolean successfulExecution) throws SchedulerException {
    }

    public void passivate() {
        this.jec = null;
        this.qs = null;
    }

    private boolean notifyListenersBeginning(JobExecutionContext jec) throws VetoedException {
        boolean vetoed = false;
        try {
            vetoed = this.qs.notifyTriggerListenersFired(jec);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
            return false;
        }
        if (vetoed) {
            try {
                this.qs.notifyJobListenersWasVetoed(jec);
            }
            catch (SchedulerException se) {
                this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of vetoed execution while firing trigger (Trigger and Job will NOT be fired!). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
            }
            throw new VetoedException();
        }
        try {
            this.qs.notifyJobListenersToBeExecuted(jec);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job to be executed: (Job will NOT be executed!). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
            return false;
        }
        return true;
    }

    private boolean notifyJobListenersComplete(JobExecutionContext jec, JobExecutionException jobExEx) {
        try {
            this.qs.notifyJobListenersWasExecuted(jec, jobExEx);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify JobListener(s) of Job that was executed: (error will be ignored). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
            return false;
        }
        return true;
    }

    private boolean notifyTriggerListenersComplete(JobExecutionContext jec, int instCode) {
        try {
            this.qs.notifyTriggerListenersComplete(jec, instCode);
        }
        catch (SchedulerException se) {
            this.qs.notifySchedulerListenersError("Unable to notify TriggerListener(s) of Job that was executed: (error will be ignored). trigger= " + jec.getTrigger().getFullName() + " job= " + jec.getJobDetail().getFullName(), se);
            return false;
        }
        if (jec.getTrigger().getNextFireTime() == null) {
            this.qs.notifySchedulerListenersFinalized(jec.getTrigger());
        }
        return true;
    }

    public boolean completeTriggerRetryLoop(Trigger trigger, JobDetail jobDetail, int instCode) {
        long count = 0L;
        while (!this.shutdownRequested) {
            try {
                Thread.sleep(15000L);
                this.qs.notifyJobStoreJobComplete(this.schdCtxt, trigger, jobDetail, instCode);
                return true;
            }
            catch (JobPersistenceException jpe) {
                if (count % 4L == 0L) {
                    this.qs.notifySchedulerListenersError("An error occured while marking executed job complete (will continue attempts). job= '" + jobDetail.getFullName() + "'", jpe);
                }
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            ++count;
        }
        return false;
    }

    public boolean vetoedJobRetryLoop(Trigger trigger, JobDetail jobDetail, int instCode) {
        while (!this.shutdownRequested) {
            try {
                Thread.sleep(5000L);
                this.qs.notifyJobStoreJobVetoed(this.schdCtxt, trigger, jobDetail, instCode);
                return true;
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while marking executed job vetoed. job= '" + jobDetail.getFullName() + "'", jpe);
            }
            catch (InterruptedException ignore) {
            }
        }
        return false;
    }

    class VetoedException
    extends Exception {
    }
}

