/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.provider.AbstractVfsComponent;
import org.apache.commons.vfs.provider.FileReplicator;
import org.apache.commons.vfs.provider.TemporaryFileStore;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.util.Messages;

public class DefaultFileReplicator
extends AbstractVfsComponent
implements FileReplicator,
TemporaryFileStore {
    private static final Log log = LogFactory.getLog(DefaultFileReplicator.class);
    private final ArrayList copies = new ArrayList();
    private File tempDir;
    private long filecount;
    private boolean tempDirMessageLogged;
    private char[] TMP_RESERVED_CHARS = new char[]{'?', '/', '\\', ' ', '&', '\"', '\'', '*', '#', ';', ':', '<', '>', '|'};

    public DefaultFileReplicator(File tempDir) {
        this.tempDir = tempDir;
    }

    public DefaultFileReplicator() {
    }

    public void init() throws FileSystemException {
        if (this.tempDir == null) {
            String baseTmpDir = System.getProperty("java.io.tmpdir");
            this.tempDir = new File(baseTmpDir, "vfs_cache").getAbsoluteFile();
        }
        this.filecount = new Random().nextInt() & 0xFFFF;
        if (!this.tempDirMessageLogged) {
            String message = Messages.getString("vfs.impl/temp-dir.info", this.tempDir);
            VfsLog.info(this.getLogger(), log, message);
            this.tempDirMessageLogged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList arrayList = this.copies;
        synchronized (arrayList) {
            while (this.copies.size() > 0) {
                File file = (File)this.removeFile();
                this.deleteFile(file);
            }
        }
        if (this.tempDir != null && this.tempDir.exists() && this.tempDir.list().length == 0) {
            this.tempDir.delete();
            this.tempDir = null;
        }
    }

    protected void deleteFile(File file) {
        try {
            FileObject fileObject = this.getContext().toFileObject(file);
            fileObject.delete(Selectors.SELECT_ALL);
        }
        catch (FileSystemException e) {
            String message = Messages.getString("vfs.impl/delete-temp.warn", file.getName());
            VfsLog.warn(this.getLogger(), log, message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeFile() {
        ArrayList arrayList = this.copies;
        synchronized (arrayList) {
            return this.copies.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFile(Object file) {
        ArrayList arrayList = this.copies;
        synchronized (arrayList) {
            this.copies.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File allocateFile(String baseName) throws FileSystemException {
        String basename = this.createFilename(baseName);
        DefaultFileReplicator defaultFileReplicator = this;
        synchronized (defaultFileReplicator) {
            ++this.filecount;
        }
        File file = this.createAndAddFile(this.tempDir, basename);
        return file;
    }

    protected File createAndAddFile(File parent, String basename) throws FileSystemException {
        File file = this.createFile(this.tempDir, basename);
        this.addFile(file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFile(Object file) {
        ArrayList arrayList = this.copies;
        synchronized (arrayList) {
            this.copies.add(file);
        }
    }

    protected long getFilecount() {
        return this.filecount;
    }

    protected String createFilename(String baseName) {
        String safeBasename = UriParser.encode(baseName, this.TMP_RESERVED_CHARS).replace('%', '_');
        return "tmp_" + this.getFilecount() + "_" + safeBasename;
    }

    protected File createFile(File parent, String name) throws FileSystemException {
        return new File(parent, UriParser.decode(name));
    }

    public File replicateFile(FileObject srcFile, FileSelector selector) throws FileSystemException {
        String basename = srcFile.getName().getBaseName();
        File file = this.allocateFile(basename);
        FileObject destFile = this.getContext().toFileObject(file);
        destFile.copyFrom(srcFile, selector);
        return file;
    }
}

