/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.wrapper;

import com.karneim.util.collection.regex.Pattern;
import com.sun.jna.Platform;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.JdkLogger2Factory;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.action.Action;
import org.rzo.yajsw.action.ActionFactory;
import org.rzo.yajsw.cache.Cache;
import org.rzo.yajsw.condition.Condition;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.Controller;
import org.rzo.yajsw.io.CircularBuffer;
import org.rzo.yajsw.log.DateFileHandler;
import org.rzo.yajsw.log.MyLogger;
import org.rzo.yajsw.log.PatternFormatter;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.os.StopableService;
import org.rzo.yajsw.os.ms.win.w32.ClusterNodeChangeListener;
import org.rzo.yajsw.os.posix.bsd.BSDProcess;
import org.rzo.yajsw.script.Script;
import org.rzo.yajsw.script.ScriptFactory;
import org.rzo.yajsw.timer.Timer;
import org.rzo.yajsw.timer.TimerFactory;
import org.rzo.yajsw.tray.WrapperTrayIconFactory;
import org.rzo.yajsw.tray.ahessian.server.AHessianJmxServer;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.util.SimpleThreadFactory;
import org.rzo.yajsw.util.Utils;
import org.rzo.yajsw.wrapper.AbstractWrappedProcessMBean;
import org.rzo.yajsw.wrapper.AlphanumComparator;
import org.rzo.yajsw.wrapper.MissingTriggerAction;
import org.rzo.yajsw.wrapper.StateChangeListener;
import org.rzo.yajsw.wrapper.TrayIconProxy;
import org.rzo.yajsw.wrapper.TriggerAction;
import org.rzo.yajsw.wrapper.TriggerListener;
import org.rzo.yajsw.wrapper.WrappedJavaProcess;
import org.rzo.yajsw.wrapper.WrappedProcess;
import org.rzo.yajsw.wrapper.WrappedProcessFactory;

public abstract class AbstractWrappedProcess
implements WrappedProcess,
Constants,
AbstractWrappedProcessMBean {
    public volatile Process _osProcess;
    protected Controller _controller;
    protected boolean _debug = false;
    protected YajswConfigurationImpl _config;
    protected volatile Gobler _gobler_err;
    protected volatile Gobler _gobler_in;
    protected static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("wrappedProcess"));
    protected static final Executor scriptExecutor = Executors.newCachedThreadPool(new SimpleThreadFactory("scriptExecutor"));
    protected long _firstRestartTime;
    protected volatile int _state = 0;
    Set _startupExitCodes = new HashSet();
    Set _shutdownExitCodes = new HashSet();
    boolean _exitCodeDefaultRestart = false;
    protected Configuration _localConfiguration = new BaseConfiguration();
    Logger _appLogger;
    protected String _tmpPath;
    Logger _wrapperLogger;
    String _wrapperLoggerName = "wrapper";
    String _appLoggerName;
    String _appLoggerPid;
    boolean _useSystemProperties = true;
    protected static final String PATHSEP = System.getProperty("path.separator");
    int _restartCount;
    int _totalRestartCount = 0;
    Timer _timer;
    FileLock _lock;
    File _lockFile;
    FileChannel _lockFileChannel;
    File _pidFile;
    long _successfulInvocationTime;
    MultiMap _listeners = MultiValueMap.decorate(new HashMap(), HashSet.class);
    String _triggerLine;
    Condition _condition;
    Process _trayIconProcess;
    volatile Date _appStarted;
    volatile Date _appStopped;
    Date _wrapperStarted;
    volatile boolean _drainActive = false;
    volatile int _exitCode = -99;
    boolean _haltWrapperOnApp = false;
    boolean _haltAppOnWrapper = false;
    Object _cluster = null;
    ClusterNodeChangeListener _clusterListener;
    boolean _clusterTriggered = false;
    Cache _cache = null;
    boolean _exiting = false;
    volatile TrayIconProxy _trayIconMessages = null;
    Script _restartDelayScript = null;
    Object _service = null;
    volatile boolean _stopRequested = false;
    volatile boolean _startRequested = false;
    MBeanServer _mbeanServer = null;
    AHessianJmxServer _ahessianServer = null;
    boolean _reconnecting = false;
    boolean _init = false;
    public static final int MIN_PROCESS_LINES_TO_LOG = 40;
    List<Thread> _shutdownHooks = new ArrayList<Thread>();
    volatile boolean _stopper = false;
    Lock _stoppingHintLock = new ReentrantLock();
    volatile long _stoppingHint = 0L;
    volatile long _stoppingHintSetTime = 0L;
    volatile boolean _appReportedReady = false;
    volatile String _stopReason;
    JdkLogger2Factory _internalLoggerFactory = null;
    boolean _startByTimer = false;
    Handler _fileHandler;
    Handler _consoleHandler;
    boolean _timerRestart = false;

    @Override
    public void init() {
        String dbg;
        if (this._init) {
            return;
        }
        HashMap<String, Utils> utils = new HashMap<String, Utils>();
        utils.put("util", new Utils(this));
        this._config = new YajswConfigurationImpl(this._localConfiguration, this._useSystemProperties, utils);
        this.getWrapperLogger().info("init ");
        if (!this._config.isLocalFile() && this._cache == null) {
            this._cache = new Cache();
            this._cache.load(this._config);
        }
        this._debug = (dbg = this._config.getString("wrapper.debug")) == null ? false : dbg.equals("true");
        this._successfulInvocationTime = this._config.getLong("wrapper.successful_invocation_time", 60L) * 1000L;
        String control = this._config.getString("wrapper.control", "TIGHT");
        if ("TIGHT".equals(control) || "WRAPPER".equals(control)) {
            this._haltWrapperOnApp = true;
        }
        if ("TIGHT".equals(control) || "APPLICATION".equals(control)) {
            this._haltAppOnWrapper = true;
        }
        Iterator it = this._config.getKeys("wrapper.on_exit");
        while (it.hasNext()) {
            String postfix;
            String key = (String)it.next();
            String value = this._config.getString(key);
            if ("RESTART".equals(value)) {
                postfix = key.substring(key.lastIndexOf(".") + 1);
                if ("default".equals(postfix)) {
                    this._exitCodeDefaultRestart = true;
                } else {
                    try {
                        this._startupExitCodes.add(Integer.parseInt(postfix));
                    }
                    catch (Exception ex) {
                        this.getWrapperLogger().info("error evaluating " + key + " " + ex.getMessage());
                    }
                }
            }
            if (!"SHUTDOWN".equals(value) || "default".equals(postfix = key.substring(key.lastIndexOf(".") + 1))) continue;
            try {
                this._shutdownExitCodes.add(Integer.parseInt(postfix));
            }
            catch (Exception ex) {
                this.getWrapperLogger().info("error evaluating " + key + " " + ex.getMessage());
            }
        }
        if (this._timer == null) {
            this._timer = TimerFactory.createTimer(this._config, this);
        }
        this._timer.init();
        if (this._condition == null) {
            this._condition = new Condition(this._config, this, this.getInternalWrapperLogger());
        }
        this._condition.init();
        this._restartCount = 0;
        if (this._timer.isHasTrigger() || this._condition.isHasTrigger()) {
            this._haltWrapperOnApp = false;
        }
        if (this._config.getBoolean("wrapper.tray", false) || this._config.getBoolean("wrapper.jmx", false)) {
            this.registerMBean();
        }
        if (this._config.getBoolean("wrapper.tray", false)) {
            this.startAhessianService();
            this._trayIconMessages = new TrayIconProxy();
        }
        if (!this._reconnecting && this._config.getBoolean("wrapper.tray", false) && this._trayIconProcess == null && !this.isService()) {
            this._trayIconProcess = WrapperTrayIconFactory.startTrayIconProcess(this._config);
        }
        if (this._config.getBoolean("wrapper.jmx", false)) {
            this.startJMXRmiService();
        }
        this.configStateChangeListeners();
        this.configShutdownHook();
        String clusterScript = this._config.getString("wrapper.windows.cluster.script", null);
        this.configClusterScript(clusterScript);
        this._init = true;
    }

    private void configClusterScript(String clusterScript) {
        if (clusterScript != null && !"".equals(clusterScript)) {
            List args = this._config.getList("wrapper.windows.cluster.script.args", new ArrayList());
            int timeout = this._config.getInt("wrapper.windows.cluster.script.timeout", 0);
            final Script script = ScriptFactory.createScript(clusterScript, "", (WrappedProcess)this, args, this.getInternalWrapperLogger(), timeout);
            if (script == null) {
                return;
            }
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass("org.rzo.yajsw.os.ms.win.w32.Cluster");
                this._cluster = clazz.newInstance();
                this._clusterListener = new ClusterNodeChangeListener(){

                    @Override
                    public void nodeChanged() {
                        script.execute();
                    }
                };
                Method m = clazz.getMethod("addNodeChangeListener", ClusterNodeChangeListener.class);
                m.invoke(this._cluster, this._clusterListener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void startCluster() {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("org.rzo.yajsw.os.ms.win.w32.Cluster");
            this._clusterTriggered = true;
            this._clusterListener.nodeChanged();
            Method m = clazz.getMethod("start", new Class[0]);
            m.invoke(this._cluster, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configShutdownHook() {
        if (OperatingSystem.instance().getOperatingSystemName().toLowerCase().startsWith("windows") && this.isService()) {
            return;
        }
        if (this._haltAppOnWrapper) {
            Thread hook = new Thread(){

                @Override
                public void run() {
                    AbstractWrappedProcess.this.getWrapperLogger().info("Shutting down Wrapper");
                    if (!AbstractWrappedProcess.this._exiting) {
                        AbstractWrappedProcess.this.setExiting();
                        AbstractWrappedProcess.this.stop("WRAPPER SHUTDOWN");
                        AbstractWrappedProcess.this.shutdown();
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
            this._shutdownHooks.add(hook);
        }
    }

    private void configStateChangeListeners() {
        Iterator listeners;
        Iterator it = listeners = this._config.getKeys("wrapper.script");
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.endsWith(".args")) continue;
            String value = this._config.getString(key);
            List args = this._config.getList(key + ".args", new ArrayList());
            int timeout = this._config.getInt(key + ".timeout", 0);
            String state = key.substring(key.lastIndexOf(".") + 1);
            final Script script = ScriptFactory.createScript(value, state, (WrappedProcess)this, args, this.getInternalWrapperLogger(), timeout);
            int iState = this.toIntState(state);
            if (iState < 0 || script == null) continue;
            this.addStateChangeListener(iState, new StateChangeListener(){

                @Override
                public void stateChange(int newState, int oldState) {
                    script.executeWithTimeout();
                }
            });
        }
        if (this._haltWrapperOnApp) {
            this.addStateChangeListener(0, new StateChangeListener(){

                @Override
                public void stateChange(int newState, int oldState) {
                    if (AbstractWrappedProcess.this._exiting) {
                        return;
                    }
                    AbstractWrappedProcess.this._exiting = true;
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (AbstractWrappedProcess.this._stopper) {
                                return;
                            }
                            if (!AbstractWrappedProcess.this.isService()) {
                                System.exit(0);
                            } else {
                                Object service = AbstractWrappedProcess.this.getService();
                                if (service != null) {
                                    AbstractWrappedProcess.this.getWrapperLogger().info("calling onStop");
                                    ((StopableService)service).onStop();
                                    ((StopableService)service).waitOnStop();
                                    Runtime.getRuntime().halt(0);
                                } else if (AbstractWrappedProcess.this.isService() && AbstractWrappedProcess.this._haltWrapperOnApp) {
                                    try {
                                        Thread.sleep(5000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                    Runtime.getRuntime().halt(0);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    private int toIntState(String state) {
        if ("START".equals(state)) {
            return 1;
        }
        if ("RUN".equals(state)) {
            return 4;
        }
        if ("RESTART".equals(state)) {
            return 2;
        }
        if ("STOP".equals(state)) {
            return 8;
        }
        if ("ABORT".equals(state)) {
            return 9;
        }
        if ("SHUTDOWN".equals(state)) {
            return 10;
        }
        if ("IDLE".equals(state)) {
            return 0;
        }
        return -1;
    }

    private void startJMXRmiService() {
        try {
            int port = this._config.getInt("wrapper.jmx.rmi.port", 1099);
            if (port > 0) {
                Registry rmiRegistry = LocateRegistry.createRegistry(port);
                JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
                HashMap<String, 5> environment = null;
                if (this._config.getString("wrapper.jmx.rmi.user", null) != null) {
                    final String myUser = this._config.getString("wrapper.jmx.rmi.user");
                    final String myPassword = this._config.getString("wrapper.jmx.rmi.password", "");
                    environment = new HashMap<String, 5>();
                    JMXAuthenticator authenticator = new JMXAuthenticator(){

                        @Override
                        public Subject authenticate(Object credentials) {
                            if (!(credentials instanceof String[])) {
                                throw new SecurityException("Bad credentials");
                            }
                            String[] creds = (String[])credentials;
                            if (creds.length != 2) {
                                throw new SecurityException("Bad credentials");
                            }
                            String user = creds[0];
                            String password = creds[1];
                            if (password == null) {
                                password = "";
                            }
                            if (!myUser.equals(user)) {
                                throw new SecurityException("Unknown user " + user);
                            }
                            if (!myPassword.equals(password)) {
                                throw new SecurityException("Bad password");
                            }
                            HashSet<JMXPrincipal> principals = new HashSet<JMXPrincipal>();
                            principals.add(new JMXPrincipal(user));
                            return new Subject(true, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
                        }
                    };
                    environment.put("jmx.remote.authenticator", authenticator);
                }
                JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, environment, this._mbeanServer);
                cs.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void startAhessianService() {
        if (this._ahessianServer != null) {
            return;
        }
        try {
            String canonName = new File(this._config.getString("wrapper.config")).getCanonicalPath();
            this._ahessianServer = new AHessianJmxServer(this._mbeanServer, "+n:localhost, -n:*", canonName, this._config.getInt("wrapper.tray.port", 0), this.getWrapperLogger());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerMBean() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        try {
            if (servers != null && servers.size() > 0) {
                this._mbeanServer = servers.get(0);
            }
            if (this._mbeanServer == null) {
                this._mbeanServer = MBeanServerFactory.createMBeanServer();
            }
            if (this._mbeanServer != null) {
                String name = this._config.getString("wrapper.console.title");
                if (name == null) {
                    name = this._config.getString("wrapper.ntservice.name");
                }
                if (name == null) {
                    name = "yajsw.noname";
                }
                ObjectName oName = new ObjectName("org.rzo.yajsw", "name", name);
                this._mbeanServer.registerMBean(this, oName);
            } else {
                this.getWrapperLogger().severe("ERROR: no mbean server found ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getPriority(String priority) {
        if ("LOW".equals(priority)) {
            return -2;
        }
        if ("BELOW_NORMAL".equals(priority)) {
            return -1;
        }
        if ("NORMAL".equals(priority)) {
            return 0;
        }
        if ("ABOVE_NORMAL".equals(priority)) {
            return 1;
        }
        if ("HIGH".equals(priority)) {
            return 2;
        }
        return -99;
    }

    protected int getAffinity(String affinity) {
        try {
            return Integer.parseInt(affinity);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    protected boolean exitCodeRestart() {
        if (this._state == 8 || this._state == 10) {
            return false;
        }
        if (this._startupExitCodes.contains(this._osProcess.getExitCode())) {
            this.getWrapperLogger().info("restart process due to exit code rule");
            return true;
        }
        if (this._exitCodeDefaultRestart) {
            this.getWrapperLogger().info("restart process due to default exit code rule");
            return true;
        }
        return false;
    }

    protected boolean exitCodeShutdown() {
        if (this._shutdownExitCodes.contains(this._osProcess.getExitCode())) {
            this.getWrapperLogger().info("shutdown process due to exit code rule");
            return true;
        }
        return false;
    }

    protected void setState(int state) {
        int oldState = this._state;
        if (this._state != state) {
            this.getWrapperLogger().info("set state " + AbstractWrappedProcess.getStringState(this._state) + "->" + AbstractWrappedProcess.getStringState(state));
            this._state = state;
            if (this._trayIconMessages != null) {
                this._trayIconMessages.setUserColor(null);
                if (state == 0) {
                    this._trayIconMessages.messages.clear();
                }
            }
            if (state == 0) {
                this.removeLockFile();
            }
            Collection listeners = (Collection)this._listeners.get((Object)this._state);
            Collection listeners999 = (Collection)this._listeners.get((Object)999);
            HashSet allListeners = new HashSet();
            if (listeners != null) {
                allListeners.addAll(listeners);
            }
            if (listeners999 != null) {
                allListeners.addAll(listeners999);
            }
            for (StateChangeListener listener : allListeners) {
                if (listener == null) continue;
                listener.stateChange(state, oldState);
            }
            if (this._state == 0 && this._startRequested) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractWrappedProcess.this.start();
                    }
                });
            }
        }
    }

    public static String getStringState(int state) {
        switch (state) {
            case 0: {
                return "IDLE";
            }
            case 2: {
                return "RESTART";
            }
            case 5: {
                return "RESTART_START";
            }
            case 6: {
                return "RESTART_STOP";
            }
            case 7: {
                return "RESTART_WAIT";
            }
            case 4: {
                return "RUNNING";
            }
            case 1: {
                return "STARTING";
            }
            case 3: {
                return "STOP";
            }
            case 8: {
                return "STATE_USER_STOP";
            }
            case 9: {
                return "STATE_ABORT";
            }
            case 10: {
                return "STATE_SHUTDOWN";
            }
        }
        return "?";
    }

    @Override
    public synchronized void startByTimer() {
        this._startByTimer = true;
        this.start();
        this._startByTimer = false;
    }

    @Override
    public synchronized void start() {
        if (!this._init) {
            this.init();
        }
        if (this._debug) {
            this.getWrapperLogger().info("start from Thread " + Thread.currentThread().getName());
        }
        this._startRequested = true;
        this._stopRequested = false;
        if (this._state != 0) {
            this.getWrapperLogger().info("Process not IDLE -> Delaying start request");
        }
        this.startInternal();
    }

    public synchronized void startInternal() {
        this.setAppReportedReady(false);
        if (!this.saveLockFile()) {
            return;
        }
        this.savePidFile();
        if (this._timer.isHasTrigger() && !this._timer.isTriggered()) {
            this._timer.start();
        }
        if (this._condition.isHasTrigger() && !this._condition.isTriggered()) {
            this._condition.start();
            return;
        }
        if (!this._timer.isStartImmediate() && !this._startByTimer) {
            return;
        }
        if (this._cluster != null && !this._clusterTriggered) {
            this.startCluster();
            return;
        }
        this._startRequested = false;
        if (this._state == 0) {
            this.setState(1);
        } else if (this._state == 7) {
            this.setState(5);
        } else {
            return;
        }
        if (this._shutdownHooks.isEmpty()) {
            this.configShutdownHook();
        }
        long startTimeout = this._config.getLong("wrapper.startup.delay", 0L);
        if (this._state == 1 && startTimeout > 0L) {
            try {
                this.getWrapperLogger().info("startup delay " + startTimeout + "sec");
                Thread.sleep(startTimeout * 1000L);
                if (this._stopRequested) {
                    this.setState(0);
                    return;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        this.getWrapperLogger().info("starting Process");
        if (this._wrapperStarted == null) {
            this._wrapperStarted = new Date();
        }
        if (this._config.getBoolean("wrapper.restart.reload_configuration", false)) {
            this.reloadConfiguration();
        }
        if (this._debug) {
            this.getWrapperLogger().info("starting controller");
        }
        if (this._controller != null) {
            this._controller.reset();
            this._controller.setDebug(this.isDebug());
            this._controller.setLogger(this.getWrapperLogger());
            this.configController();
            if (!this._controller.start()) {
                this.getWrapperLogger().info("could not start controller -> abort");
                this.setState(9);
                this.setState(0);
                return;
            }
            if (this._debug) {
                this.getWrapperLogger().info("controller started");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        if (this._osProcess == null) {
            this.createOSProcess();
        } else {
            if (this._debug) {
                this.getWrapperLogger().info("_osProcess destroyed");
            }
            this._osProcess.destroy();
        }
        this.configProcess();
        this._firstRestartTime = System.currentTimeMillis();
        Map triggerActions = this.getTriggerActions();
        Map regexTriggerActions = this.getRegexTriggerActions();
        Map missingTriggerActions = this.getMissingTriggerActions();
        Map missingRegexTriggerActions = this.getMissingRegexTriggerActions();
        this._osProcess.setLogger(this.getWrapperLogger());
        this._exitCode = -3;
        this.getWrapperLogger().info("spawning wrapped process");
        this._controller.beginWaitForStartup();
        if (this._osProcess.start()) {
            this._controller.processStarted();
            ++this._totalRestartCount;
            this.postStart();
            this.getWrapperLogger().info("started process with pid " + this._osProcess.getPid());
            if (this.pipeStreams()) {
                this._gobler_in = new Gobler(this._osProcess.getInputStream(), this.getAppLogger(), triggerActions, regexTriggerActions, missingTriggerActions, missingRegexTriggerActions, "OUTPUT " + this._osProcess.getPid(), this._osProcess.getPid());
                this._gobler_err = new Gobler(this._osProcess.getErrorStream(), this.getAppLogger(), triggerActions, regexTriggerActions, missingTriggerActions, missingRegexTriggerActions, "ERROR " + this._osProcess.getPid(), this._osProcess.getPid());
                executor.execute(this._gobler_err);
                executor.execute(this._gobler_in);
            }
            if (this.getState() != 0 && this.getState() != 2) {
                this._appStarted = new Date();
                this.setState(4);
                this.updateAppLoggerName();
            }
        } else {
            this.getWrapperLogger().severe("failed to spawn wrapped process");
            this._controller.processFailed();
        }
    }

    protected void reloadConfiguration() {
        HashMap<String, Utils> utils = new HashMap<String, Utils>();
        utils.put("util", new Utils(this));
        this._config = new YajswConfigurationImpl(this._localConfiguration, this._useSystemProperties, utils);
        this.getWrapperLogger().info("reloaded configuration ");
    }

    abstract void configController();

    abstract void postStart();

    void configProcess() {
        String workingDir;
        String title;
        String affinity;
        String priority = this._config.getString("wrapper.priority");
        if (priority != null) {
            this._osProcess.setPriority(this.getPriority(priority));
        }
        if ((affinity = this._config.getString("wrapper.affinity")) != null) {
            this._osProcess.setCpuAffinity(this.getAffinity(affinity));
        }
        if ((title = this._config.getString("wrapper.console.title")) != null) {
            this._osProcess.setTitle(title);
        }
        this._osProcess.setVisible(this._config.getBoolean("wrapper.console.visible", false) && !this._config.getBoolean("wrapper.service", false));
        this._osProcess.setMinimized(this._config.getBoolean("wrapper.console.minimized", false) && !this._config.getBoolean("wrapper.service", false));
        this._osProcess.setUser(this._config.getString("wrapper.app.account"));
        this._osProcess.setPassword(this._config.getString("wrapper.app.password"));
        if (this._debug) {
            this._osProcess.setDebug(true);
        }
        if ((workingDir = this._config.getString("wrapper.working.dir", ".")) != null) {
            File wd = new File(workingDir);
            if (!wd.exists() || !wd.isDirectory()) {
                this.getWrapperLogger().warning("working directory " + workingDir + " not found");
            } else {
                this._osProcess.setWorkingDir(wd.getAbsolutePath());
            }
            this.getWrapperLogger().info("working dir " + wd.getAbsolutePath());
        }
        this._osProcess.setEnvironment(this.getProcessEnvironment(this._config));
        if (Platform.isWindows() && Platform.isWinVista() && this._config.getBoolean("wrapper.service", false) && this._config.getBoolean("wrapper.ntservice.logon_active_session", false)) {
            this._osProcess.setLogonActiveSession(true);
            if (this._debug) {
                this.getWrapperLogger().info("setLogonActiveSession");
            }
            if (!this._config.getBoolean("wrapper.ntservice.autoreport.startup", true)) {
                this.getWrapperLogger().warning("WARNING: do not set autoreport.startup & wrapper.ntservice.logon_active_session");
            }
            if (this._config.getString("wrapper.ntservice.account", null) != null) {
                this.getWrapperLogger().warning("WARNING: do not set wrapper.ntservice.account & wrapper.ntservice.logon_active_session");
            }
            if (this._config.getString("wrapper.app.account", null) != null) {
                this.getWrapperLogger().warning("WARNING: do not set wrapper.app.account & wrapper.ntservice.logon_active_session");
            }
        }
        String desktop = this._config.getString("wrapper.ntservice.desktop", null);
        if (Platform.isWindows() && Platform.isWinVista() && this._config.getBoolean("wrapper.service", false) && desktop != null) {
            this._osProcess.setDesktop(desktop);
        }
    }

    private List<String[]> getProcessEnvironment(YajswConfigurationImpl config) {
        if (!config.getKeys("wrapper.app.env").hasNext()) {
            return null;
        }
        List<String[]> env = OperatingSystem.instance().processManagerInstance().getProcess(OperatingSystem.instance().processManagerInstance().currentProcessId()).getEnvironment();
        Iterator keys = config.getKeys("wrapper.app.env");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = config.getString(key);
            String envKey = key.substring("wrapper.app.env.".length());
            this.updateEnvKey(envKey, value, env);
        }
        return env;
    }

    private void updateEnvKey(String envKey, String value, List<String[]> env) {
        String[] entry = this.findEnvEntry(envKey, env);
        if (entry != null) {
            entry[1] = value;
        } else {
            env.add(new String[]{envKey, value});
        }
    }

    private String[] findEnvEntry(String envKey, List<String[]> env) {
        for (String[] entry : env) {
            if (!this.envKeyEqual(envKey, entry[0])) continue;
            return entry;
        }
        return null;
    }

    private boolean envKeyEqual(String envKey1, String envKey2) {
        if (Platform.isWindows()) {
            return envKey1.toLowerCase().equals(envKey2.toLowerCase());
        }
        return envKey1.equals(envKey2);
    }

    protected boolean pipeStreams() {
        return true;
    }

    void restartLogFile() {
        boolean append;
        if (this._fileHandler == null) {
            return;
        }
        String rollMode = this._config.getString("wrapper.logfile.rollmode", "");
        boolean bl = append = !rollMode.contains("WRAPPER") && !rollMode.contains("JVM");
        if (!append && this._appLogger != null) {
            this._fileHandler.close();
            this.getFileHandler();
        }
    }

    public Handler getConsoleHandler() {
        if (this._consoleHandler != null) {
            return this._consoleHandler;
        }
        String consoleLogLevel = this._config.getString("wrapper.console.loglevel", "INFO");
        if (consoleLogLevel.equals("NONE")) {
            return null;
        }
        this._consoleHandler = new ConsoleHandler(){

            @Override
            protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
                super.setOutputStream(System.out);
            }
        };
        this._consoleHandler.setFormatter(this.getConsoleFormatter());
        this._consoleHandler.setLevel(this.getLogLevel(consoleLogLevel));
        return this._consoleHandler;
    }

    public Handler getFileHandler() {
        if (this._fileHandler != null) {
            return this._fileHandler;
        }
        String fileName = this.getLogFile();
        String fileLogLevel = this._config.getString("wrapper.logfile.loglevel", "INFO");
        if (fileName.equals("") || fileLogLevel.equals("NONE")) {
            return null;
        }
        File f = new File(fileName).getParentFile();
        if (!f.exists()) {
            try {
                f.mkdirs();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            String rollMode = this._config.getString("wrapper.logfile.rollmode", "");
            boolean append = !rollMode.contains("WRAPPER") && !rollMode.contains("JVM");
            int count = this._config.getInt("wrapper.logfile.maxfiles", 0);
            if (count == 0) {
                count = 16192;
            }
            int limit = this.getLogLimit();
            this._fileHandler = fileName.contains("%d") ? new DateFileHandler(fileName, limit, count, append) : new FileHandler(fileName, limit, count, append);
            this._fileHandler.setFormatter(this.getFileFormatter());
            this._fileHandler.setLevel(this.getLogLevel(fileLogLevel));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this._fileHandler;
    }

    private void updateAppLoggerName() {
        if (this._appLogger == null) {
            return;
        }
        this._appLoggerPid = this.getAppPid() + "/" + this._restartCount;
        ((MyLogger)this._appLogger).setPID(this._appLoggerPid);
        this._appLoggerName = this.getName() == null ? "" : this.getName();
        ((MyLogger)this._appLogger).setName(this._appLoggerName);
    }

    protected Logger getAppLogger() {
        if (this._appLogger != null) {
            return this._appLogger;
        }
        if (this._appLogger == null) {
            this._appLogger = new MyLogger();
            this.updateAppLoggerName();
            this._appLogger.setUseParentHandlers(false);
            if (this._controller != null) {
                this._controller.setLogger(this._appLogger);
            }
        }
        if (this.getFileHandler() != null) {
            this._appLogger.addHandler(this.getFileHandler());
        }
        if (this.getConsoleHandler() != null) {
            this._appLogger.addHandler(this.getConsoleHandler());
        }
        this._appLogger.setLevel(Level.ALL);
        return this._appLogger;
    }

    private Level getLogLevel(String logLevel) {
        if (logLevel.equals("INFO")) {
            return Level.ALL;
        }
        if (logLevel.equals("FATAL")) {
            return Level.SEVERE;
        }
        if (logLevel.equals("ERROR")) {
            return Level.WARNING;
        }
        if (logLevel.equals("STATUS")) {
            return Level.INFO;
        }
        return Level.INFO;
    }

    private int getLogLimit() {
        String res = this._config.getString("wrapper.logfile.maxsize");
        String units = "";
        if (res == null) {
            return 0;
        }
        if ((res = res.toLowerCase()).endsWith("m")) {
            res = res.substring(0, res.length() - 1);
            units = "m";
        } else if (res.endsWith("k")) {
            res = res.substring(0, res.length() - 1);
            units = "k";
        }
        int result = Integer.parseInt(res);
        if (units.equals("m")) {
            result = result * 1024 * 1024;
        } else if (units.equals("k")) {
            result *= 1024;
        }
        return result;
    }

    private PatternFormatter getFileFormatter() {
        String wFormat = this._config.getString("wrapper.logfile.format", "LPNTM");
        return this.getFormatter(wFormat);
    }

    private Formatter getConsoleFormatter() {
        String wFormat = this._config.getString("wrapper.console.format", "LPNTM");
        return this.getFormatter(wFormat);
    }

    private PatternFormatter getFormatter(String wFormat) {
        PatternFormatter formatter = new PatternFormatter();
        String pattern = "";
        if (wFormat.contains("Z")) {
            formatter.setTimeFormat("yy-MM-dd HH:mm:ss.SS");
        } else {
            formatter.setTimeFormat("yy-MM-dd HH:mm:ss");
        }
        block7: for (int i = 0; i < wFormat.length(); ++i) {
            if (i > 0) {
                pattern = pattern + "|";
            }
            char c = wFormat.charAt(i);
            switch (c) {
                case 'L': {
                    pattern = pattern + "%LEVEL%";
                    continue block7;
                }
                case 'P': {
                    pattern = pattern + "%PARAM0%";
                    continue block7;
                }
                case 'N': {
                    pattern = pattern + "%PARAM1%";
                    continue block7;
                }
                case 'T': 
                case 'Z': {
                    pattern = pattern + "%TIME%";
                    continue block7;
                }
                case 'M': {
                    pattern = pattern + "%MESSAGE%";
                    continue block7;
                }
            }
        }
        pattern = pattern + "\n";
        formatter.setLogPattern(pattern);
        return formatter;
    }

    private String getLogFile() {
        String result = this._config.getString("wrapper.logfile", "wrapper.log");
        File r = new File(result);
        File f = null;
        if (!r.isAbsolute()) {
            String wDir = this._config.getString("wrapper.working.dir", ".");
            f = new File(wDir, result);
        } else {
            f = new File(result);
        }
        result = f.getAbsolutePath();
        result = result.contains("ROLLNUM") ? result.replace("ROLLNUM", "%g") : result + ".%g";
        if (result.contains("YYYYMMDD")) {
            result = result.replace("YYYYMMDD", "%d");
        }
        return result;
    }

    protected Map getMissingTriggerActions() {
        HashMap<String, MissingTriggerAction> result = new HashMap<String, MissingTriggerAction>();
        Iterator it = this._config.getKeys("wrapper.filter.missing.trigger");
        while (it.hasNext()) {
            String tKey = (String)it.next();
            List lValue = this._config.getList(tKey);
            if (lValue == null || lValue.size() != 3) {
                this.getWrapperLogger().info("check parameters for " + tKey);
                continue;
            }
            String tValue = (String)lValue.get(0);
            if ("*".equals(tValue)) {
                tValue = "";
            }
            int countValue = -1;
            try {
                countValue = Integer.parseInt((String)lValue.get(1));
            }
            catch (Exception ex) {
                this.getWrapperLogger().log(Level.SEVERE, "check parameters for " + tKey, ex);
            }
            long periodValue = -1L;
            try {
                periodValue = Long.parseLong((String)lValue.get(2)) * 1000L;
            }
            catch (Exception ex) {
                this.getWrapperLogger().log(Level.SEVERE, "check parameters for " + tKey, ex);
            }
            String tName = tKey.substring("wrapper.filter.missing.trigger.".length());
            boolean autoStop = this._config.getBoolean("wrapper.filter.missing.autostop." + tName, true);
            String aKey = "wrapper.filter.missing.action." + tName;
            String aValue = this._config.getString(aKey, "");
            Object action = this.getTriggerAction(aValue);
            String sKey = "wrapper.filter.missing.script." + tName;
            String sValue = this._config.getString(sKey, "");
            List args = this._config.getList(sKey + ".args", null);
            int timeout = this._config.getInt(sKey + ".timeout", 0);
            String[] strArgs = null;
            if (args != null && args.size() > 0) {
                strArgs = new String[args.size()];
                for (int i = 0; i < strArgs.length; ++i) {
                    strArgs[i] = args.get(i).toString();
                }
            }
            Object script = this.getTriggerScript(sValue, tKey.substring(tKey.lastIndexOf(46)), strArgs, timeout);
            if (action == null && script == null) continue;
            result.put(tValue, new MissingTriggerAction(executor, periodValue, countValue, new TriggerAction[]{(TriggerAction)script, (TriggerAction)action}, autoStop, this.getWrapperLogger()));
        }
        return result;
    }

    protected Map getMissingRegexTriggerActions() {
        HashMap<String, MissingTriggerAction> result = new HashMap<String, MissingTriggerAction>();
        Iterator it = this._config.getKeys("wrapper.filter.missing.trigger-regex");
        while (it.hasNext()) {
            String tKey = (String)it.next();
            List lValue = this._config.getList(tKey);
            if (lValue == null || lValue.size() != 3) {
                this.getWrapperLogger().info("check parameters for " + tKey);
                continue;
            }
            String tValue = (String)lValue.get(0);
            int countValue = -1;
            try {
                countValue = Integer.parseInt((String)lValue.get(1));
            }
            catch (Exception ex) {
                this.getWrapperLogger().log(Level.SEVERE, "check parameters for " + tKey, ex);
            }
            long periodValue = -1L;
            try {
                this.getWrapperLogger().info("check parameters for " + tKey);
                periodValue = Long.parseLong((String)lValue.get(2)) * 1000L;
            }
            catch (Exception ex) {
                this.getWrapperLogger().log(Level.SEVERE, "check parameters for " + tKey, ex);
            }
            String tName = tKey.substring("wrapper.filter.missing.trigger-regex.".length());
            boolean autoStop = this._config.getBoolean("wrapper.filter.missing.autostop." + tName, true);
            String aKey = "wrapper.filter.missing.action." + tName;
            String aValue = this._config.getString(aKey, "");
            Object action = this.getTriggerAction(aValue);
            String sKey = "wrapper.filter.missing.script." + tName;
            String sValue = this._config.getString(sKey, "");
            List args = this._config.getList(sKey + ".args", null);
            int timeout = this._config.getInt(sKey + ".timeout", 0);
            String[] strArgs = null;
            if (args != null && args.size() > 0) {
                strArgs = new String[args.size()];
                for (int i = 0; i < strArgs.length; ++i) {
                    strArgs[i] = args.get(i).toString();
                }
            }
            Object script = this.getTriggerScript(sValue, tKey.substring(tKey.lastIndexOf(46)), strArgs, timeout);
            if (action == null && script == null) continue;
            result.put(tValue, new MissingTriggerAction(executor, periodValue, countValue, new TriggerAction[]{(TriggerAction)script, (TriggerAction)action}, autoStop, this.getWrapperLogger()));
        }
        return result;
    }

    protected Map getTriggerActions() {
        HashMap result = new HashMap();
        ArrayList configList = new ArrayList();
        ListIterator it = this._config.getKeys("wrapper.filter.trigger");
        while (it.hasNext()) {
            configList.add(it.next());
        }
        Collections.sort(configList, new AlphanumComparator());
        it = configList.listIterator();
        while (it.hasNext()) {
            String tKey = (String)it.next();
            String tValue = this._config.getString(tKey);
            if (tValue == null || tValue.length() == 0) continue;
            String tName = tKey.substring("wrapper.filter.trigger.".length());
            String aKey = "wrapper.filter.action." + tName;
            String aValue = this._config.getString(aKey, "");
            Object action = this.getTriggerAction(aValue);
            String sKey = "wrapper.filter.script." + tName;
            String sValue = this._config.getString(sKey, "");
            List args = this._config.getList(sKey + ".args", null);
            int timeout = this._config.getInt(sKey + ".timeout", 0);
            String[] strArgs = null;
            if (args != null && args.size() > 0) {
                strArgs = new String[args.size()];
                for (int i = 0; i < strArgs.length; ++i) {
                    strArgs[i] = args.get(i).toString();
                }
            }
            Object script = this.getTriggerScript(sValue, tKey.substring(tKey.lastIndexOf(46)), strArgs, timeout);
            if (action != null && script != null) {
                this.addToActionMap(result, tValue, Arrays.asList(script, action));
                continue;
            }
            if (action != null) {
                this.addToActionMap(result, tValue, action);
                continue;
            }
            if (script != null) {
                this.addToActionMap(result, tValue, script);
                continue;
            }
            this.addToActionMap(result, aKey, "RESTART");
        }
        return result;
    }

    private void addToActionMap(Map actionsMap, String key, Object value) {
        Object c = actionsMap.get(key);
        if (c == null) {
            actionsMap.put(key, value);
        } else if (c instanceof Collection && value instanceof Collection) {
            ArrayList l = new ArrayList();
            l.addAll((Collection)c);
            l.addAll((Collection)value);
            actionsMap.put(key, l);
        } else if (c instanceof Collection && !(value instanceof Collection)) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.addAll((Collection)c);
            l.add(value);
            actionsMap.put(key, l);
        } else if (!(c instanceof Collection) && value instanceof Collection) {
            ArrayList<Collection> l = new ArrayList<Collection>();
            l.add((Collection)c);
            l.addAll((Collection)value);
            actionsMap.put(key, l);
        } else {
            actionsMap.put(key, Arrays.asList(c, value));
        }
    }

    protected Map getRegexTriggerActions() {
        HashMap result = new HashMap();
        Iterator it = this._config.getKeys("wrapper.filter.trigger-regex");
        while (it.hasNext()) {
            String tKey = (String)it.next();
            String tValue = this._config.getString(tKey);
            if (tValue == null || tValue.length() == 0) continue;
            String tName = tKey.substring("wrapper.filter.trigger-regex.".length());
            String aKey = "wrapper.filter.action." + tName;
            String aValue = this._config.getString(aKey, "");
            Object action = this.getTriggerAction(aValue);
            String sKey = "wrapper.filter.script." + tName;
            String sValue = this._config.getString(sKey, "");
            List args = this._config.getList(sKey + ".args", null);
            int timeout = this._config.getInt(sKey + ".timeout", 0);
            String[] strArgs = null;
            if (args != null && args.size() > 0) {
                strArgs = new String[args.size()];
                for (int i = 0; i < strArgs.length; ++i) {
                    strArgs[i] = args.get(i).toString();
                }
            }
            Object script = this.getTriggerScript(sValue, tKey.substring(tKey.lastIndexOf(46)), strArgs, timeout);
            if (action != null && script != null) {
                this.addToActionMap(result, tValue, Arrays.asList(script, action));
                continue;
            }
            if (action != null) {
                this.addToActionMap(result, tValue, action);
                continue;
            }
            if (script != null) {
                this.addToActionMap(result, tValue, script);
                continue;
            }
            this.addToActionMap(result, aKey, "RESTART");
        }
        return result;
    }

    private Object getTriggerScript(String script, String key, String[] args, int timeout) {
        final Script s = ScriptFactory.createScript(script, key, (WrappedProcess)this, args, this.getInternalWrapperLogger(), timeout);
        if (s == null) {
            this.getWrapperLogger().info("error initializing script " + script);
            return null;
        }
        this.getWrapperLogger().info("found script " + s.getScript());
        final Logger wl = this.getWrapperLogger();
        return new TriggerAction(){

            @Override
            public Object execute(final String line) {
                scriptExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractWrappedProcess.this.getWrapperLogger().info("start script " + s.getScript());
                        wl.severe("running script " + line + " with " + s.toString());
                        s.executeWithTimeout(new String(line));
                        AbstractWrappedProcess.this.getWrapperLogger().info("end script " + s.getScript());
                    }
                });
                return null;
            }
        };
    }

    private Object getTriggerAction(String value) {
        if ("RESTART".equals(value)) {
            return new TriggerAction(){

                @Override
                public Object execute(String line) {
                    if (AbstractWrappedProcess.this.allowRestart()) {
                        AbstractWrappedProcess.this.restartInternal();
                    } else if (AbstractWrappedProcess.this.getState() == 4) {
                        AbstractWrappedProcess.this.stop("TRIGGER");
                    }
                    return null;
                }
            };
        }
        if ("SHUTDOWN".equals(value)) {
            return new TriggerAction(){

                @Override
                public Object execute(String line) {
                    AbstractWrappedProcess.this.stop("TRIGGER");
                    return null;
                }
            };
        }
        return null;
    }

    @Override
    public synchronized void stopTimer() {
        this._timer.stop();
    }

    public synchronized void stopCondition() {
        this._condition.stop();
    }

    @Override
    public void stop() {
        this.stop("USER");
    }

    @Override
    public void stop(String reason) {
        if (this._debug) {
            this.getWrapperLogger().info("stop from Thread " + Thread.currentThread().getName() + " reason: " + reason);
        }
        this._stopReason = reason;
        this._startRequested = false;
        if (this._state != 4 && this._state != 0) {
            this.getWrapperLogger().info("process not in state RUNNING -> Delaying stop");
            this._stopRequested = true;
        }
        this.stopInternal();
    }

    public synchronized void stopInternal() {
        this.setAppReportedReady(false);
        if (this._state == 2) {
            this._appStopped = new Date();
            this.setState(6);
            this._stopReason = "RESTART";
        } else if (this._state == 4) {
            this._appStopped = new Date();
            this.setState(8);
        } else {
            return;
        }
        int shutdownWaitTime = this._config.getInt("wrapper.shutdown.timeout", 30) * 1000;
        this.getWrapperLogger().info("stopping process with pid/timeout " + this._osProcess.getPid() + " " + (shutdownWaitTime += this._config.getInt("wrapper.jvm_exit.timeout", 15) * 1000));
        this.stopController(shutdownWaitTime, this._stopReason);
        this.stopOsProcess(shutdownWaitTime);
        this._appStopped = new Date();
        if (this._state == 8 && !this._exiting) {
            this.setState(0);
        }
        this.removeShutdownHooks();
    }

    private void removeShutdownHooks() {
        if (this._exiting) {
            return;
        }
        for (Thread hook : this._shutdownHooks) {
            Runtime.getRuntime().removeShutdownHook(hook);
        }
        this._shutdownHooks.clear();
    }

    private void stopOsProcess(int shutdownWaitTime) {
        boolean externalStop = false;
        String stopConfigName = this._config.getString("wrapper.stop.conf");
        this.getWrapperLogger().info("stop config name " + stopConfigName);
        File stopConfigFile = null;
        if (stopConfigName != null) {
            stopConfigFile = new File(stopConfigName);
            try {
                stopConfigName = stopConfigFile.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            externalStop = stopConfigFile.isFile() && stopConfigFile.exists();
        }
        WrappedProcess stopper = null;
        this.getWrapperLogger().info("externalStop " + externalStop);
        if (externalStop) {
            this.getWrapperLogger().info("starting stop application");
            BaseConfiguration stopLocalConf = new BaseConfiguration();
            stopLocalConf.setProperty("wrapper.config", (Object)stopConfigName);
            YajswConfigurationImpl stopConf = new YajswConfigurationImpl((Configuration)stopLocalConf, this._useSystemProperties);
            stopper = WrappedProcessFactory.createProcess(stopConf);
            stopper.getLocalConfiguration().setProperty("wrapper.config", (Object)stopConfigName);
            stopper.setUseSystemProperties(this._useSystemProperties);
            stopper.setStopper(true);
            stopper.init();
            stopper.start();
        }
        if (shutdownWaitTime > 0) {
            this._osProcess.waitFor(shutdownWaitTime);
        }
        long remainStopWait = this.getRemainStopWaitTime();
        while (this._osProcess.isRunning() && remainStopWait > 0L) {
            if (this._debug) {
                this.getAppLogger().info("extending wait time " + remainStopWait);
            }
            if (this._service != null) {
                ((StopableService)this._service).signalStopping(remainStopWait);
            }
            this._osProcess.waitFor(remainStopWait);
            remainStopWait = this.getRemainStopWaitTime();
        }
        if (this._osProcess.isRunning()) {
            this.getWrapperLogger().info("process did not stop after " + shutdownWaitTime + " sec. -> hard kill");
        }
        this._osProcess.kill(999);
        if (stopper != null && stopper.getState() != 0) {
            stopper.stop();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        this._osProcess.destroy();
        this.getWrapperLogger().info("process exit code: " + this._osProcess.getExitCode());
    }

    private long getRemainStopWaitTime() {
        this._stoppingHintLock.lock();
        long d = this._stoppingHintSetTime - System.currentTimeMillis();
        long result = this._stoppingHint + d;
        this._stoppingHintLock.unlock();
        return result;
    }

    abstract void stopController(int var1, String var2);

    protected boolean allowRestart() {
        if (System.currentTimeMillis() - this._firstRestartTime > this._successfulInvocationTime) {
            this._restartCount = 0;
        }
        if (this._state == 8 || this._state == 2 || this._state == 6 || this._state == 7) {
            return false;
        }
        if (this._restartCount < this._config.getInt("wrapper.max_failed_invocations", 5)) {
            return true;
        }
        this.getWrapperLogger().info("too many restarts ");
        return false;
    }

    @Override
    public void restart() {
        if (this._state != 4) {
            return;
        }
        this.restartInternal();
    }

    @Override
    public void restartByTimer() {
        if (this._timerRestart) {
            return;
        }
        this._timerRestart = true;
        this.stop("TIMER");
        try {
            Thread.sleep(this.getRestartDelay());
        }
        catch (InterruptedException e) {
            if (this._debug) {
                this.getWrapperLogger().log(Level.SEVERE, this.getClass().getName() + " restart", e);
            }
            Thread.currentThread().interrupt();
        }
        this.startByTimer();
        this._timerRestart = false;
    }

    boolean isDebug() {
        return this._debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    @Override
    public int getAppPid() {
        if (this._osProcess != null) {
            return this._osProcess.getPid();
        }
        return -1;
    }

    private void savePidFile() {
        String file = this._config.getString("wrapper.pidfile");
        if (file != null) {
            try {
                this._pidFile = new File(file);
                if (!this._pidFile.exists()) {
                    this._pidFile.createNewFile();
                }
                FileWriter out = new FileWriter(this._pidFile, false);
                out.write("" + OperatingSystem.instance().processManagerInstance().currentProcessId());
                out.flush();
                out.close();
                Thread hook = new Thread(){

                    @Override
                    public void run() {
                        AbstractWrappedProcess.this.removePidFile();
                    }
                };
                Runtime.getRuntime().addShutdownHook(hook);
                this._shutdownHooks.add(hook);
                if (this._debug) {
                    this.getWrapperLogger().info("created pid file " + this._pidFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void removePidFile() {
        if (this._pidFile != null) {
            try {
                this._pidFile.delete();
                if (this._config.getBoolean("wrapper.service", false)) {
                    this.stop();
                }
                if (this._debug) {
                    this.getWrapperLogger().info("removed pid file " + this._pidFile.getAbsolutePath());
                }
                this._pidFile = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean saveLockFile() {
        if (this._lock != null) {
            return true;
        }
        String file = this._config.getString("wrapper.lockfile", null);
        if (file != null && !"".equals(file)) {
            try {
                this._lockFile = new File(file);
                if (this._lockFile.exists()) {
                    this._lockFile.delete();
                }
                this._lockFileChannel = new RandomAccessFile(this._lockFile, "rw").getChannel();
                this._lock = this._lockFileChannel.tryLock();
                if (this._lock == null) {
                    this._lockFileChannel.close();
                    this.getWrapperLogger().warning("Lock file " + file + " already locked by another application -> abort");
                    return false;
                }
                if (this._debug) {
                    this.getWrapperLogger().info("created lock file " + this._lockFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void removeLockFile() {
        if (this._lock != null) {
            try {
                this._lock.release();
                if (this._debug) {
                    this.getWrapperLogger().info("removed lock file " + this._lockFile.getAbsolutePath());
                }
                this._lock = null;
                this._lockFileChannel.close();
                this._lockFileChannel = null;
                this._lockFile.delete();
                this._lockFile = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private FileWriter FileWriter(String file) {
        return null;
    }

    @Override
    public void waitFor() {
        this.waitFor(Long.MAX_VALUE);
    }

    @Override
    public void waitFor(long t) {
        if (this._state == 0) {
            return;
        }
        final ReentrantLock lock = new ReentrantLock();
        final java.util.concurrent.locks.Condition isIdle = lock.newCondition();
        StateChangeListener listener = new StateChangeListener(){

            @Override
            public void stateChange(int newState, int oldState) {
                lock.lock();
                isIdle.signal();
                lock.unlock();
            }
        };
        this.addStateChangeListener(0, listener);
        if (this._state != 0) {
            try {
                lock.lock();
                isIdle.await(t, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        lock.unlock();
        this.removeStateChangeListener(listener);
    }

    @Override
    public Configuration getLocalConfiguration() {
        return this._localConfiguration;
    }

    @Override
    public void setLocalConfiguration(Configuration config) {
        this._localConfiguration = config;
    }

    @Override
    public int getExitCode() {
        return this._exitCode;
    }

    @Override
    public Logger getWrapperLogger() {
        if (this._wrapperLogger != null) {
            return this._wrapperLogger;
        }
        this._wrapperLogger = new MyLogger();
        ((MyLogger)this._wrapperLogger).setPID(this._wrapperLoggerName);
        ((MyLogger)this._wrapperLogger).setName(this.getName());
        this._wrapperLogger.setUseParentHandlers(false);
        if (this._controller != null) {
            this._controller.setLogger(this._appLogger);
        }
        if (this.getFileHandler() != null) {
            this._wrapperLogger.addHandler(this.getFileHandler());
        }
        if (this.getConsoleHandler() != null) {
            this._wrapperLogger.addHandler(this.getConsoleHandler());
        }
        return this._wrapperLogger;
    }

    @Override
    public InternalLogger getInternalWrapperLogger() {
        if (this._internalLoggerFactory == null) {
            this._internalLoggerFactory = new JdkLogger2Factory(this.getWrapperLogger());
        }
        return JdkLogger2Factory.getInstance("");
    }

    @Override
    public void setUseSystemProperties(boolean useSystemProperties) {
        this._useSystemProperties = useSystemProperties;
    }

    public String getTmpPath() {
        return this._tmpPath;
    }

    @Override
    public synchronized void startDrain() {
        if (this._gobler_err != null) {
            this._gobler_err.setDrain(true);
        }
        if (this._gobler_in != null) {
            this._gobler_in.setDrain(true);
        }
        this._drainActive = true;
    }

    @Override
    public synchronized void stopDrain() {
        if (this._gobler_err != null) {
            this._gobler_err.setDrain(false);
        }
        if (this._gobler_in != null) {
            this._gobler_in.setDrain(false);
        }
        this._drainActive = false;
    }

    @Override
    public String readDrainLine() {
        String result = null;
        if (!this._drainActive) {
            return null;
        }
        if (this._gobler_err != null) {
            try {
                if (!this._gobler_err.isDrain()) {
                    this.startDrain();
                }
                result = this._gobler_err.getDrainReader().readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (result == null && this._gobler_in != null) {
            try {
                if (!this._gobler_in.isDrain()) {
                    this.startDrain();
                }
                result = this._gobler_in.getDrainReader().readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public int getState() {
        return this._state;
    }

    @Override
    public void restartInternal() {
        this.setAppReportedReady(false);
        this.getWrapperLogger().info("restart internal " + this.getStringState());
        if (this._state != 4 && this._state != 1 && this._state != 5) {
            return;
        }
        this.setState(2);
        ++this._restartCount;
        if (this._debug) {
            this.getWrapperLogger().info("restarting " + this._restartCount + " time");
        }
        this.stopInternal();
        if (!this._stopRequested) {
            this.setState(7);
            try {
                Thread.sleep(this.getRestartDelay());
            }
            catch (InterruptedException e) {
                if (this._debug) {
                    this.getWrapperLogger().log(Level.SEVERE, this.getClass().getName() + " restart", e);
                }
                Thread.currentThread().interrupt();
            }
            if (!this._stopRequested) {
                this.startInternal();
            } else {
                this.getWrapperLogger().log(Level.SEVERE, "Process " + this.getName() + " stop requested, setting IDLE in restart internal");
                this._stopRequested = false;
                if (!this._osProcess.isRunning()) {
                    this.setState(0);
                }
            }
        } else {
            if (this._debug) {
                this.getWrapperLogger().info(" stop requested, setting IDLE in restart internal");
            }
            this._stopRequested = false;
            if (!this._osProcess.isRunning()) {
                this.setState(0);
            }
        }
    }

    private long getRestartDelay() {
        Object time;
        Script script = this.getRestartDelayScript();
        if (script != null && (time = script.execute()) instanceof Number) {
            return ((Number)time).longValue() * 1000L;
        }
        return this._config.getLong("wrapper.restart.delay", 5L) * 1000L;
    }

    private Script getRestartDelayScript() {
        if (this._restartDelayScript != null) {
            return this._restartDelayScript;
        }
        String script = this._config.getString("wrapper.restart.delay.script", null);
        if (script != null) {
            List args = this._config.getList("wrapper.restart.delay.script.args", null);
            int timeout = this._config.getInt("wrapper.restart.delay.script.timeout", 0);
            this._restartDelayScript = ScriptFactory.createScript(script, "", (WrappedProcess)this, args, this.getInternalWrapperLogger(), 0);
        }
        return this._restartDelayScript;
    }

    @Override
    public void addStateChangeListener(int state, StateChangeListener listener) {
        this._listeners.put((Object)state, (Object)listener);
    }

    @Override
    public void addStateChangeListener(StateChangeListener listener) {
        this._listeners.put((Object)999, (Object)listener);
    }

    @Override
    public void removeStateChangeListener(StateChangeListener listener) {
    }

    @Override
    public void removeStateChangeListener(int state) {
        this._listeners.remove((Object)state);
    }

    @Override
    public int getRestartCount() {
        return this._restartCount;
    }

    @Override
    public String getStringState() {
        return AbstractWrappedProcess.getStringState(this._state);
    }

    @Override
    public String getName() {
        String name;
        String result = "";
        if (this._config == null) {
            return result;
        }
        if (this._config.getBoolean("wrapper.service", false)) {
            result = result + "Service ";
        }
        if ((name = this._config.getString("wrapper.console.title")) == null) {
            name = this._config.getString("wrapper.ntservice.name");
        }
        if (name == null) {
            name = this._config.getString("wrapper.image");
        }
        if (name == null) {
            name = this._config.getString("wrapper.groovy");
        }
        if (name == null) {
            name = this._config.getString("wrapper.java.app.mainclass");
        }
        if (name == null) {
            name = this._config.getString("wrapper.java.app.jar");
        }
        if (name == null) {
            name = "";
        }
        result = result + name;
        return result;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this._osProcess != null) {
            return this._osProcess.getOutputStream();
        }
        return null;
    }

    @Override
    public Date getAppStarted() {
        return this._appStarted;
    }

    @Override
    public Date getAppStopped() {
        return this._appStopped;
    }

    @Override
    public Date getWrapperStarted() {
        return this._wrapperStarted;
    }

    @Override
    public int getAppThreads() {
        if (this._osProcess != null) {
            return this._osProcess.getCurrentThreads();
        }
        return -1;
    }

    @Override
    public long getAppVMemory() {
        if (this._osProcess != null) {
            return this._osProcess.getCurrentVirtualMemory();
        }
        return -1L;
    }

    @Override
    public long getAppPMemory() {
        if (this._osProcess != null) {
            return this._osProcess.getCurrentPhysicalMemory();
        }
        return -1L;
    }

    @Override
    public int getAppCpu() {
        if (this._osProcess != null) {
            return this._osProcess.getCurrentCpu();
        }
        return -1;
    }

    @Override
    public int getAppHandles() {
        if (this._osProcess != null) {
            return this._osProcess.getCurrentHandles();
        }
        return -1;
    }

    @Override
    public void addTriggerListener(TriggerListener listener) {
    }

    @Override
    public int getWrapperPid() {
        return OperatingSystem.instance().processManagerInstance().currentProcessId();
    }

    @Override
    public boolean isTimerActive() {
        return this._timer != null && this._timer.isTriggered();
    }

    @Override
    public boolean isConditionActive() {
        return this._condition != null && this._condition.isTriggered();
    }

    @Override
    public void threadDump() {
        if (this._osProcess != null && this instanceof WrappedJavaProcess && this._osProcess.isRunning()) {
            ((WrappedJavaProcess)this).requestThreadDump();
        }
    }

    @Override
    public void gc() {
        if (this._osProcess != null && this instanceof WrappedJavaProcess && this._osProcess.isRunning()) {
            ((WrappedJavaProcess)this).requestGc();
        }
    }

    @Override
    public void dumpHeap(String fileName) {
        if (this._osProcess != null && this instanceof WrappedJavaProcess && this._osProcess.isRunning()) {
            ((WrappedJavaProcess)this).requestDumpHeap(fileName);
        }
    }

    @Override
    public void wrapperThreadDump() {
        Message m = new Message(118, null);
        Action a = ActionFactory.getAction(m);
        try {
            ByteArrayOutputStream str = new ByteArrayOutputStream();
            PrintStream pr = new PrintStream(str);
            a.execute(m, null, pr, null);
            pr.flush();
            this.getWrapperLogger().info(str.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stopTimerCondition() {
        this.stopTimer();
        this.stopCondition();
    }

    @Override
    public boolean isOSProcessRunning() {
        if (this._osProcess == null) {
            return false;
        }
        return this._osProcess.isRunning();
    }

    @Override
    public int getTotalRestartCount() {
        return this._totalRestartCount;
    }

    public boolean isService() {
        return this._config.getBoolean("wrapper.service", false);
    }

    @Override
    public String getType() {
        if (this._config.getBoolean("wrapper.service", false)) {
            return "Service";
        }
        if (this._config.getBoolean("wrapper.console.visible", false)) {
            return "Console";
        }
        return "Process";
    }

    @Override
    public void shutdown() {
        this.setState(10);
    }

    @Override
    public void osProcessTerminated() {
        Process process = this._osProcess;
        if (process != null) {
            this._exitCode = process.getExitCode();
        }
    }

    @Override
    public boolean isHaltWrapperOnApp() {
        return this._haltWrapperOnApp;
    }

    @Override
    public boolean isHaltAppOnWrapper() {
        return this._haltAppOnWrapper;
    }

    @Override
    public void setExiting() {
        this._exiting = true;
    }

    @Override
    public boolean isExiting() {
        return this._exiting;
    }

    @Override
    public TrayIconProxy getTrayIcon() {
        return this._trayIconMessages;
    }

    @Override
    public String[][] getTrayIconMessages() {
        if (this._trayIconMessages == null) {
            return null;
        }
        String[][] result = this._trayIconMessages.toArrayAndClear();
        if (this._debug && result != null) {
            this.getWrapperLogger().info("sending tray icon messages: #" + result.length);
        }
        return result;
    }

    @Override
    public void stopWrapper() {
        if (this._haltAppOnWrapper) {
            this.stop("WRAPPER SHUTDOWN");
        }
        this.shutdown();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    @Override
    public boolean hasOutput() {
        return this.getOutputStream() != null;
    }

    @Override
    public void writeOutput(String txt) {
        ((PrintStream)this.getOutputStream()).println(txt);
    }

    @Override
    public void writeInquireResponse(String s) {
        if (this._trayIconMessages != null) {
            this._trayIconMessages._inquireResponse = s;
            this._trayIconMessages._inquireMessage = null;
        }
    }

    @Override
    public String getInquireMessage() {
        if (this._trayIconMessages != null) {
            return this._trayIconMessages._inquireMessage;
        }
        return null;
    }

    @Override
    public void setService(Object service) {
        this._service = service;
    }

    public Object getService() {
        return this._service;
    }

    @Override
    public void setProperty(String key, String value) {
        this.getWrapperLogger().info("set property " + key + " " + value);
        this._localConfiguration.setProperty(key, (Object)value);
    }

    @Override
    public void resetCache() {
        this.getWrapperLogger().info("reset cache ");
        this._cache = null;
    }

    @Override
    public long getMaxStartTime() {
        if (this._config == null) {
            return 0L;
        }
        long startDelay = this._config.getLong("wrapper.startup.delay", 0L);
        long startupTimeout = this._config.getInt("wrapper.startup.timeout", 30) * 1000;
        if (startDelay < Integer.MAX_VALUE && startupTimeout < Integer.MAX_VALUE) {
            return startDelay + startupTimeout;
        }
        return Integer.MAX_VALUE;
    }

    public boolean isReconnecting() {
        return this._reconnecting;
    }

    void setReconnecting(boolean reconnecting) {
        this._reconnecting = reconnecting;
    }

    @Override
    public void setStopper(boolean b) {
        this._stopper = b;
    }

    public void monitorConf() {
        boolean monitor = this._config.getBoolean("wrapper.monitor.config", false);
        if (!monitor) {
            return;
        }
        if (this._config.isStopper()) {
            return;
        }
        final long fileTime = this._config.getConfigFileTime();
        if (fileTime <= 0L) {
            this.getWrapperLogger().info("wrapper.monitor.config: cannot start: could not get file time");
            return;
        }
        this._localConfiguration.setProperty("wrapper.restart.reload_configuration", (Object)true);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                AbstractWrappedProcess.this.getWrapperLogger().info("wrapper.monitor.config: start");
                while (AbstractWrappedProcess.this.getState() == 4) {
                    long t = AbstractWrappedProcess.this._config.getConfigFileTime();
                    if (t > fileTime) {
                        AbstractWrappedProcess.this.getWrapperLogger().info("wrapper.monitor.config: config file changed: " + new Date(fileTime) + " -> " + new Date(t) + " Restarting Application");
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                AbstractWrappedProcess.this.restart();
                            }
                        });
                        break;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
                AbstractWrappedProcess.this.getWrapperLogger().info("wrapper.monitor.config: end");
            }
        });
    }

    public Object getCluster() {
        return this._cluster;
    }

    @Override
    public Configuration getYajswConfig() {
        return this._config;
    }

    @Override
    public void signalStopping(long waitHint) {
        if (this._debug) {
            this.getAppLogger().info("received signalStopping hint " + waitHint);
        }
        if (this._state == 4) {
            this.stop("APPLICATION");
        }
        this._stoppingHintLock.lock();
        this._stoppingHint = waitHint;
        this._stoppingHintSetTime = System.currentTimeMillis();
        this._stoppingHintLock.unlock();
    }

    @Override
    public boolean isAppReportedReady() {
        return this._appReportedReady;
    }

    @Override
    public void setAppReportedReady(boolean appReportedReady) {
        this._appReportedReady = appReportedReady;
    }

    @Override
    public Color getUserTrayColor() {
        if (this._trayIconMessages == null) {
            return null;
        }
        return this._trayIconMessages.getUserColor();
    }

    protected void createOSProcess() {
        this._osProcess = this._config.getBoolean("wrapper.fork_hack", false) ? new BSDProcess() : OperatingSystem.instance().processManagerInstance().createProcess();
    }

    protected class Gobler
    implements Runnable {
        InputStream _inputStream;
        String _name;
        Logger _goblerLog;
        Map _actionsRegex;
        Map _missingActionsRegex;
        Pattern[] _actionTriggersRegex;
        Pattern[] _missingActionTriggersRegex;
        Map _actions;
        Map _missingActions;
        String[] _actionTriggers;
        String[] _missingActionTriggers;
        volatile boolean _drain;
        volatile CircularBuffer _drainBuffer;
        volatile BufferedReader _drainReader;
        volatile int _pid;

        public void setDrain(boolean drain) {
            if (drain && !this._drain) {
                this._drainBuffer = new CircularBuffer(16384, false);
                this._drainReader = new BufferedReader(this._drainBuffer);
            } else if (!drain && this._drain) {
                try {
                    this._drainReader.close();
                    this._drainBuffer = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this._drain = drain;
        }

        public BufferedReader getDrainReader() {
            return this._drainReader;
        }

        public Gobler(InputStream stream, Logger log, Map events, Map eventsRegex, Map missingEvents, Map missingEventsRegex, String name, int pid) {
            Iterator it;
            int i;
            this._inputStream = stream;
            this._name = name;
            this._goblerLog = log;
            this._actions = events;
            if (events != null) {
                this._actionTriggers = new String[events.size()];
                i = 0;
                it = events.keySet().iterator();
                while (it.hasNext()) {
                    this._actionTriggers[i] = (String)it.next();
                    ++i;
                }
            }
            this._actionsRegex = eventsRegex;
            if (eventsRegex != null) {
                this._actionTriggersRegex = new Pattern[eventsRegex.size()];
                i = 0;
                for (String s : eventsRegex.keySet()) {
                    try {
                        this._actionTriggersRegex[i] = new Pattern(s);
                    }
                    catch (Throwable ex) {
                        AbstractWrappedProcess.this.getWrapperLogger().log(Level.SEVERE, "error in regular expression " + s, ex);
                    }
                    ++i;
                }
            }
            this._missingActions = missingEvents;
            if (this._missingActions != null) {
                this._missingActionTriggers = new String[this._missingActions.size()];
                i = 0;
                it = this._missingActions.keySet().iterator();
                while (it.hasNext()) {
                    this._missingActionTriggers[i] = (String)it.next();
                    ++i;
                }
            }
            this._missingActionsRegex = missingEventsRegex;
            if (this._missingActionsRegex != null) {
                this._missingActionTriggersRegex = new Pattern[this._missingActionsRegex.size()];
                i = 0;
                for (String s : missingEventsRegex.keySet()) {
                    try {
                        this._missingActionTriggersRegex[i] = new Pattern(s);
                    }
                    catch (Throwable ex) {
                        AbstractWrappedProcess.this.getWrapperLogger().log(Level.SEVERE, "error in regular expression " + s, ex);
                    }
                    ++i;
                }
            }
        }

        @Override
        public void run() {
            Iterator it;
            block29: {
                try {
                    Iterator it2;
                    if (this._inputStream == null) {
                        this._goblerLog.info("cannot run stream gobler with a null stream");
                        return;
                    }
                    InputStreamReader isr = new InputStreamReader(this._inputStream);
                    BufferedReader br = new BufferedReader(isr);
                    String line = null;
                    int k = 0;
                    if (this._missingActions != null) {
                        it2 = this._missingActions.values().iterator();
                        while (it2.hasNext()) {
                            ((MissingTriggerAction)it2.next()).start();
                        }
                    }
                    if (this._missingActionsRegex != null) {
                        it2 = this._missingActionsRegex.values().iterator();
                        while (it2.hasNext()) {
                            ((MissingTriggerAction)it2.next()).start();
                        }
                    }
                    while ((line = br.readLine()) != null) {
                        Collection c;
                        TriggerAction action;
                        Object obj;
                        if (this._drain) {
                            this._drainBuffer.write(line);
                        }
                        if (k > 40) {
                            this._goblerLog.finest(line);
                        } else {
                            this._goblerLog.info(line);
                            ++k;
                        }
                        if (this._actionTriggers != null) {
                            for (int i = 0; i < this._actionTriggers.length; ++i) {
                                if (!line.contains(this._actionTriggers[i])) continue;
                                obj = this._actions.get(this._actionTriggers[i]);
                                if (obj instanceof TriggerAction) {
                                    action = (TriggerAction)obj;
                                    AbstractWrappedProcess.this.getWrapperLogger().info("Trigger found: " + this._actionTriggers[i]);
                                    action.execute(new String(line));
                                    break;
                                }
                                if (!(obj instanceof Collection)) break;
                                c = (Collection)obj;
                                for (TriggerAction action2 : c) {
                                    AbstractWrappedProcess.this.getWrapperLogger().info("Trigger found: " + this._actionTriggers[i]);
                                    action2.execute(new String(line));
                                }
                                break;
                            }
                        }
                        if (this._actionTriggersRegex != null) {
                            for (int i = 0; i < this._actionTriggersRegex.length; ++i) {
                                if (!this._actionTriggersRegex[i].contains(line)) continue;
                                obj = (TriggerAction)this._actionsRegex.get(this._actionTriggersRegex[i].getRegEx());
                                if (obj instanceof TriggerAction) {
                                    action = (TriggerAction)obj;
                                    AbstractWrappedProcess.this.getWrapperLogger().info("Trigger found: " + this._actionTriggersRegex[i]);
                                    action.execute(new String(line));
                                    break;
                                }
                                if (!(obj instanceof Collection)) break;
                                c = (Collection)obj;
                                for (TriggerAction action2 : c) {
                                    AbstractWrappedProcess.this.getWrapperLogger().info("Trigger found: " + this._actionTriggersRegex[i]);
                                    action2.execute(new String(line));
                                }
                                break;
                            }
                        }
                        if (this._missingActionTriggers != null) {
                            for (int i = 0; i < this._missingActionTriggers.length; ++i) {
                                if (!"".equals(this._missingActionTriggers[i]) && !line.contains(this._missingActionTriggers[i]) || !((obj = (TriggerAction)this._missingActions.get(this._missingActionTriggers[i])) instanceof TriggerAction)) continue;
                                action = (TriggerAction)obj;
                                action.execute(new String(line));
                            }
                        }
                        if (this._missingActionTriggersRegex != null) {
                            for (int i = 0; i < this._missingActionTriggersRegex.length; ++i) {
                                if (!this._missingActionTriggersRegex[i].contains(line) || !((obj = (TriggerAction)this._actionsRegex.get(this._missingActionTriggersRegex[i].getRegEx())) instanceof TriggerAction)) continue;
                                action = (TriggerAction)obj;
                                action.execute(new String(line));
                            }
                        }
                        Thread.yield();
                    }
                }
                catch (Exception ioe) {
                    if (!AbstractWrappedProcess.this._debug) break block29;
                    this._goblerLog.log(Level.INFO, " gobler exeception " + this._name, ioe);
                }
            }
            if (AbstractWrappedProcess.this._osProcess != null && this._pid == AbstractWrappedProcess.this._osProcess.getPid() && AbstractWrappedProcess.this._osProcess.isRunning()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractWrappedProcess.this._state != 5 && AbstractWrappedProcess.this._state != 2 && AbstractWrappedProcess.this._state != 6 && AbstractWrappedProcess.this._state != 7) {
                            Gobler.this._goblerLog.warning("yajsw panicking: gobler stopped but process is still running -> restart process");
                            AbstractWrappedProcess.this.restartInternal();
                        }
                    }
                });
            }
            if (AbstractWrappedProcess.this._debug) {
                this._goblerLog.info("gobler terminated " + this._name);
            }
            if (this._missingActions != null) {
                it = this._missingActions.values().iterator();
                while (it.hasNext()) {
                    ((MissingTriggerAction)it.next()).stop();
                }
            }
            if (this._missingActionsRegex != null) {
                it = this._missingActionsRegex.values().iterator();
                while (it.hasNext()) {
                    ((MissingTriggerAction)it.next()).stop();
                }
            }
        }

        public boolean isDrain() {
            return this._drain;
        }
    }
}

