/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray.ahessian.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.ipfilter.IpFilterRuleHandler;
import org.jboss.netty.handler.ipfilter.IpFilterRuleList;
import org.rzo.netty.mcast.discovery.DiscoveryServer;
import org.rzo.yajsw.tray.ahessian.server.AHessianServerPipelineFactory;

public class AHessianJmxServer {
    public AHessianJmxServer(MBeanServer mbeanServer, String ipFilter, String serviceDiscoveryName, int port, Logger log) {
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)executor, (Executor)executor));
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new AHessianServerPipelineFactory(executor, new IpFilterRuleHandler(new IpFilterRuleList(ipFilter)), mbeanServer, log));
        int serverPort = port;
        Channel channel = bootstrap.bind((SocketAddress)new InetSocketAddress(serverPort));
        if (serverPort == 0) {
            serverPort = ((InetSocketAddress)channel.getLocalAddress()).getPort();
        }
        log.info("ahessian jmx service bound to port " + serverPort);
        DiscoveryServer discovery = new DiscoveryServer();
        discovery.setIpSet(new IpFilterRuleList("+n:localhost, -n:*"));
        discovery.setName(serviceDiscoveryName);
        discovery.setPort(serverPort);
        try {
            discovery.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error starting tray icon server", e);
        }
    }
}

