/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.script;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.rzo.yajsw.script.Script;
import org.rzo.yajsw.wrapper.WrappedProcess;

public abstract class AbstractScript
implements Script {
    String _name;
    int _timeout = 30000;
    WrappedProcess _process;
    String _id;
    String[] _args;
    static ExecutorService pool = Executors.newCachedThreadPool();

    public AbstractScript(String script, String id, WrappedProcess process, String[] args, int timeout) {
        this._name = script;
        this._process = process;
        this._id = id;
        this._args = args;
        if (timeout > 0) {
            this._timeout = timeout * 1000;
        }
    }

    @Override
    public abstract Object execute(String var1);

    @Override
    public Object executeWithTimeout(final String line) {
        Future<Object> future = pool.submit(new Callable<Object>(){

            @Override
            public Object call() {
                return AbstractScript.this.execute(line);
            }
        });
        try {
            return future.get(this._timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            System.out.println("script did not terminate within " + this._timeout + " ms");
            future.cancel(true);
            return null;
        }
    }

    @Override
    public String getScript() {
        return this._name;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }
}

