/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.rzo.yajsw.util.DaemonThreadFactory;

public class Utils {
    protected static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("util.osCommand"));
    protected Logger _logger;

    public void setLog(Logger logger) {
        this._logger = logger;
    }

    public String readFile(String file) {
        String result = null;
        File f = new File(file);
        if (f.exists()) {
            try {
                FileInputStream in = new FileInputStream(f);
                byte[] buffer = new byte[10240];
                int size = ((InputStream)in).read(buffer);
                for (int i = 0; i < size; ++i) {
                    if (buffer[i] != 0) continue;
                    buffer[i] = 32;
                }
                result = new String(buffer);
                ((InputStream)in).close();
            }
            catch (Exception e) {
                if (this._logger != null) {
                    this._logger.throwing(Utils.class.getName(), "readFile", e);
                }
            }
        } else if (this._logger != null) {
            this._logger.info("could not find file " + f.getAbsolutePath());
        }
        return result;
    }

    public String osCommand(String cmd) {
        StringBuffer result;
        block3: {
            result = new StringBuffer();
            try {
                int x;
                Process p = Runtime.getRuntime().exec(cmd);
                InputStream in = p.getInputStream();
                while ((x = in.read()) != -1) {
                    result.append((char)x);
                }
            }
            catch (Exception ex) {
                if (this._logger == null) break block3;
                this._logger.warning("Error executing \"" + cmd + "\": " + ex);
            }
        }
        return result.toString();
    }

    public String osCommand(String cmd, long timeout) {
        Process p = null;
        try {
            final Process fp = p = Runtime.getRuntime().exec(cmd);
            FutureTask future = new FutureTask(new Callable(){

                public String call() throws Exception {
                    int x;
                    StringBuffer result = new StringBuffer();
                    InputStream in = fp.getInputStream();
                    while ((x = in.read()) != -1) {
                        result.append((char)x);
                    }
                    return result.toString();
                }
            });
            executor.execute(future);
            String result = (String)future.get(timeout, TimeUnit.MILLISECONDS);
            return result;
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.warning("Error executing \"" + cmd + "\": " + e);
            }
            if (p != null) {
                p.destroy();
            }
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(new Utils().osCommand("cmd /C dir", 500L));
    }
}

