/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rzo.yajsw.io.CyclicBufferFileInputStream;
import org.rzo.yajsw.io.CyclicBufferFilePrintStream;
import org.rzo.yajsw.os.AbstractProcess;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.os.posix.Utils;
import org.rzo.yajsw.util.DaemonThreadFactory;

public class PosixProcess
extends AbstractProcess {
    protected int[] _inPipe = new int[2];
    protected int[] _outPipe = new int[2];
    protected int[] _errPipe = new int[2];
    public IntByReference status = new IntByReference();
    int _exitCodeKill = -1;
    protected static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("posix.process.terminate"));
    protected boolean lock = true;
    protected volatile boolean _terminated = false;
    protected Utils _utils = new Utils();
    boolean _stopWaiter = false;
    String[] _env = null;
    long _currentTotalCPU = -1L;
    long _oldTotalCPU = -1L;
    long _lastCPUReadTime = Long.MAX_VALUE;

    @Override
    public void destroy() {
        if (this._outputStream != null) {
            try {
                this._outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._inputStream != null) {
            try {
                this._inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._errorStream != null) {
            try {
                this._errorStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        CLibrary.INSTANCE.close(this._inPipe[1]);
        CLibrary.INSTANCE.close(this._outPipe[0]);
        CLibrary.INSTANCE.close(this._errPipe[0]);
        CLibrary.INSTANCE.close(this._inPipe[0]);
        CLibrary.INSTANCE.close(this._outPipe[1]);
        CLibrary.INSTANCE.close(this._errPipe[1]);
    }

    @Override
    public Collection getChildren() {
        return null;
    }

    @Override
    public int getCurrentPageFaults() {
        return 0;
    }

    @Override
    public int getCurrentPhysicalMemory() {
        return 0;
    }

    @Override
    public int getCurrentVirtualMemory() {
        int result;
        block4: {
            result = -1;
            if (!this.isRunning()) {
                return result;
            }
            String stat2 = this._utils.readFile("/proc/" + this._pid + "/stat");
            if (this.status != null) {
                try {
                    String sp = "(?:[^\\s]+[\\s]+){22}(\\d+).+";
                    Pattern p = Pattern.compile(sp, 32);
                    Matcher m = p.matcher(stat2);
                    m.find();
                    result = Integer.parseInt(m.group(1).trim());
                }
                catch (Exception ex) {
                    if (this._logger == null) break block4;
                    this._logger.info("Error in getCurrentVirtualMemory() " + ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isRunning() {
        if (this._pid < 1) {
            return false;
        }
        return this._exitCode < 0;
    }

    @Override
    public int getExitCode() {
        if (this._exitCodeKill >= 0) {
            return this._exitCodeKill;
        }
        return this._exitCode;
    }

    @Override
    public boolean kill(int code) {
        if (this._logger != null) {
            this._logger.info("killing " + this._pid);
        }
        int count = 0;
        while (this._exitCode < 0 && count < 3) {
            int r;
            ++count;
            if (this._logger != null) {
                this._logger.info("send kill sig");
            }
            if ((r = CLibrary.INSTANCE.kill(this._pid, 9)) == 0) {
                this._exitCodeKill = code;
                return true;
            }
            if (this._logger != null) {
                this._logger.fine("error calling kill: " + r);
            }
            if (this._exitCode >= 0) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    @Override
    public boolean killTree(int code) {
        return false;
    }

    @Override
    public boolean start() {
        if (this._arrCmd == null && this._cmd == null) {
            return false;
        }
        if (this._arrCmd == null) {
            this._arrCmd = this._cmd.split(" ");
            this.log("exec: " + this._cmd);
        } else {
            String cmd = "";
            for (String c : this._arrCmd) {
                if (c == null) continue;
                cmd = cmd + c + " ";
            }
            this.log("exec:" + cmd);
        }
        if (this._environment.size() > 0) {
            this._env = new String[this._environment.size()];
            int i = 0;
            for (String[] entry : this._environment) {
                this._env[i++] = entry[0] + "=" + entry[1];
            }
        } else {
            this._env = null;
        }
        int pid = 0;
        this._exitCode = -2;
        String title = this._title == null ? "yajsw" : this._title;
        this._terminated = false;
        if (this._visible) {
            this.setCommand(String.format("xterm -hold -sb -T %1$s -e %2$s", title, this.getCommand()));
        }
        if (this._visible) {
            this._pipeStreams = false;
        }
        CLibrary.INSTANCE.pipe(this._inPipe);
        CLibrary.INSTANCE.pipe(this._outPipe);
        CLibrary.INSTANCE.pipe(this._errPipe);
        String forkLogName = "forkLog" + System.currentTimeMillis() + ".log";
        pid = CLibrary.INSTANCE.fork();
        if (pid == 0) {
            int stdout = this.getStdOutNo();
            int stderr = this.getStdErrNo();
            int stdin = this.getStdInNo();
            if (this.getWorkingDir() != null && CLibrary.INSTANCE.chdir(this.getWorkingDir()) != 0) {
                this.log("could not set working dir");
            }
            if (this._priority == -1) {
                if (CLibrary.INSTANCE.nice(1) == -1) {
                    this.log("could not set priority ");
                }
            } else if (this._priority == -2) {
                if (CLibrary.INSTANCE.nice(2) == -1) {
                    this.log("could not set priority ");
                }
            } else if (this._priority == 1) {
                if (CLibrary.INSTANCE.nice(-1) == -1) {
                    this.log("could not set priority ");
                }
            } else if (this._priority == 2 && CLibrary.INSTANCE.nice(-2) == -1) {
                this.log("could not set priority ");
            }
            if (this.getUser() != null) {
                this.switchUser(this.getUser(), this.getPassword());
            }
            CLibrary.INSTANCE.close(this._inPipe[1]);
            this.moveDescriptor(this._inPipe[0], stdin);
            CLibrary.INSTANCE.close(this._outPipe[0]);
            this.moveDescriptor(this._outPipe[1], stdout);
            CLibrary.INSTANCE.close(this._errPipe[0]);
            this.moveDescriptor(this._errPipe[1], stderr);
            try {
                CLibrary.INSTANCE.umask(0);
                if (CLibrary.INSTANCE.setsid() < 0) {
                    CLibrary.INSTANCE.exit(-1);
                }
                int res = this._env != null ? CLibrary.INSTANCE.execve(this._arrCmd[0], this._arrCmd, this._env) : CLibrary.INSTANCE.execvp(this._arrCmd[0], this._arrCmd);
                int err = Native.getLastError();
                this.log("error in execv: errno " + err + " " + CLibrary.INSTANCE.strerror(err));
                this.log("exec res " + res);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.lock = false;
        } else {
            if (pid > 0) {
                block47: {
                    this._pid = pid;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    if (this._teeName != null && this._tmpPath != null) {
                        block46: {
                            File f = new File(this._tmpPath);
                            try {
                                if (!f.exists()) {
                                    f.mkdir();
                                }
                            }
                            catch (Exception ex) {
                                if (this._logger != null) {
                                    this._logger.throwing(PosixProcess.class.getName(), "start", ex);
                                }
                                Thread.currentThread().interrupt();
                            }
                            try {
                                this._inputStream = new CyclicBufferFileInputStream(this.createRWfile(this._tmpPath, "out_" + this._teeName));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                this._errorStream = new CyclicBufferFileInputStream(this.createRWfile(this._tmpPath, "err_" + this._teeName));
                            }
                            catch (Exception e) {
                                if (this._logger == null) break block46;
                                this._logger.throwing(PosixProcess.class.getName(), "start", e);
                            }
                        }
                        try {
                            this._outputStream = new CyclicBufferFilePrintStream(this.createRWfile(this._tmpPath, "in_" + this._teeName));
                        }
                        catch (Exception e) {
                            if (this._logger == null) break block47;
                            this._logger.throwing(PosixProcess.class.getName(), "start", e);
                        }
                    }
                }
                if (this._pipeStreams && this._teeName == null && this._tmpPath == null) {
                    this.writefd(this.in_fd, this._inPipe[1]);
                    this.writefd(this.out_fd, this._outPipe[0]);
                    this.writefd(this.err_fd, this._errPipe[0]);
                    this._outputStream = new BufferedOutputStream(new FileOutputStream(this.in_fd));
                    this._inputStream = new BufferedInputStream(new FileInputStream(this.out_fd));
                    this._errorStream = new BufferedInputStream(new FileInputStream(this.err_fd));
                    CLibrary.INSTANCE.close(this._inPipe[0]);
                    CLibrary.INSTANCE.close(this._outPipe[1]);
                    CLibrary.INSTANCE.close(this._errPipe[1]);
                }
                if (this._cpuAffinity != -99) {
                    IntByReference affinity = new IntByReference();
                    affinity.setValue(this._cpuAffinity);
                    if (CLibrary.INSTANCE.sched_setaffinity(this._pid, 4, affinity) == -1) {
                        this.log("error setting affinity");
                    }
                }
                this._stopWaiter = true;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        int r = 0;
                        r = CLibrary.INSTANCE.waitpid(PosixProcess.this._pid, PosixProcess.this.status, 0);
                        if (PosixProcess.this._logger != null) {
                            PosixProcess.this._logger.info("waitpid " + r + " " + PosixProcess.this.status.getValue());
                        }
                        if (r == PosixProcess.this._pid) {
                            PosixProcess.this._exitCode = PosixProcess.this.status.getValue();
                        }
                        if (PosixProcess.this._logger != null) {
                            PosixProcess.this._logger.info("exit code linux process " + PosixProcess.this._exitCode);
                        }
                        PosixProcess.this._terminated = true;
                    }
                });
                if (this._logger != null) {
                    this._logger.info("started process " + this._pid);
                }
                return true;
            }
            if (pid < 0) {
                if (this._logger != null) {
                    this._logger.info("failed to fork: " + pid);
                }
                return false;
            }
        }
        return false;
    }

    protected File createRWfile(String path, String fname) throws IOException {
        File result = new File(path, fname);
        if (!result.exists()) {
            // empty if block
        }
        String name = result.getCanonicalPath();
        return result;
    }

    @Override
    public boolean stop(int timeout, int code) {
        if (this._logger != null) {
            this._logger.info("killing " + this._pid);
        }
        if (!this.isRunning()) {
            return true;
        }
        int r = CLibrary.INSTANCE.kill(this._pid, 15);
        this.waitFor(timeout);
        int count = 0;
        while (this.isRunning() && count++ < 4) {
            CLibrary.INSTANCE.kill(this._pid, 9);
            if (!this.isRunning()) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (this._logger != null) {
                    this._logger.throwing(PosixProcess.class.getName(), "stop", e);
                }
                Thread.currentThread().interrupt();
            }
        }
        return !this.isRunning();
    }

    protected void moveDescriptor(int fd_from, int fd_to) {
        if (fd_from != fd_to) {
            CLibrary.INSTANCE.dup2(fd_from, fd_to);
            CLibrary.INSTANCE.close(fd_from);
        }
    }

    int closeDescriptors(int[] avoid) {
        int i;
        for (i = 10; i < 54; ++i) {
            CLibrary.INSTANCE.close(i);
        }
        for (i = 56; i < 76; ++i) {
            CLibrary.INSTANCE.close(i);
        }
        return 1;
    }

    @Override
    public void waitFor() {
        this.waitFor(Long.MAX_VALUE);
    }

    @Override
    public void waitFor(long timeout) {
        long start = System.currentTimeMillis();
        File f = new File("/proc/" + this._pid);
        while (System.currentTimeMillis() - start < timeout) {
            if (!this.isRunning() || !f.exists()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (this._logger != null) {
                    this._logger.throwing(PosixProcess.class.getName(), "waitFor", e);
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        PosixProcess[] p = new PosixProcess[1];
        boolean pipe = true;
        for (int i = 0; i < p.length; ++i) {
            p[i] = new PosixProcess();
            p[i].setCommand("/usr/java/jre1.5.0_10/bin/java -classpath /home/test/rzodyndns/test/wrapper.jar -Dwrapper.config=/home/test/rzodyndns/test/bat/../conf/wrapper.conf -Dwrapper.port=15003 -Dwrapper.key=6566092584194115879 -Dwrapper.teeName=6566092584194115879$1225016378236 -Dwrapper.tmpPath=/tmp org.rzo.yajsw.app.WrapperJVMMain");
            p[i].setVisible(false);
            p[i].setPipeStreams(pipe, false);
        }
        boolean doit = true;
        while (doit) {
            int i;
            doit = false;
            for (i = 0; i < p.length; ++i) {
                p[i].start();
                try {
                    Thread.yield();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (!pipe) continue;
                InputStreamReader isr = new InputStreamReader(p[i].getInputStream());
                BufferedReader br = new BufferedReader(isr);
                String line = "?";
                try {
                    for (int k = 0; k < 10 && (line = br.readLine()) != null; ++k) {
                        System.out.println(line);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            p[0].waitFor(1000L);
            System.out.println("KILL");
            for (i = 0; i < p.length; ++i) {
                p[i].kill(999);
                System.out.println("exit code " + p[i].getExitCode());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void writefd(FileDescriptor fd, int pointer) {
        try {
            Field handleField = FileDescriptor.class.getDeclaredField("fd");
            handleField.setAccessible(true);
            Field peerField = Pointer.class.getDeclaredField("peer");
            peerField.setAccessible(true);
            long value = pointer;
            handleField.setInt(fd, (int)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean reconnectStreams() {
        if (this._teeName != null) {
            try {
                this._inputStream = new CyclicBufferFileInputStream(new File(this._tmpPath, "out_" + this._teeName));
                this._errorStream = new CyclicBufferFileInputStream(new File(this._tmpPath, "err_" + this._teeName));
                this._outputStream = new CyclicBufferFilePrintStream(new File(this._tmpPath, "in_" + this._teeName));
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private String getCommandInternal() {
        String result = this._utils.readFile("/proc/" + this.getPid() + "/cmdline");
        if (result == null) {
            result = "?";
        }
        return result;
    }

    private List<String[]> getEnvironmentInternal() {
        String result = this._utils.readFile("/proc/" + this.getPid() + "/environ");
        return this.parseEnvironment(result);
    }

    private List<String[]> parseEnvironment(String env) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (env == null || "".equals(env)) {
            return result;
        }
        String sp = "(\\S+)=([^=.]+)( |$)";
        Pattern p = Pattern.compile(sp, 32);
        Matcher m = p.matcher(env);
        while (m.find()) {
            String[] str = m.group().trim().split("=", 2);
            if (str.length != 2) continue;
            result.add(new String[]{str[0], str[1]});
        }
        return result;
    }

    protected String getWorkingDirInternal() {
        String result = null;
        File f = new File("/proc/" + this.getPid() + "/cwd");
        try {
            result = f.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getWorkingDir() {
        return this._workingDir;
    }

    public static Process getProcess(int pid) {
        PosixProcess result = null;
        File f = new File("/proc/" + pid);
        if (f.exists()) {
            result = (PosixProcess)OperatingSystem.instance().processManagerInstance().createProcess();
            result._pid = pid;
            result._user = result.getUserInternal();
            result._cmd = result.getCommandInternal();
            result._workingDir = result.getWorkingDirInternal();
            result._environment = result.getEnvironmentInternal();
        }
        return result;
    }

    public static int currentProcessId() {
        return CLibrary.INSTANCE.getpid();
    }

    public String currentUser() {
        int euid = CLibrary.INSTANCE.geteuid();
        Pointer p = CLibrary.INSTANCE.getpwuid(euid);
        if (p == null) {
            this.log("could not get current user");
        }
        return new CLibrary.passwd(p).getName();
    }

    public String currentGroup() {
        int egid = CLibrary.INSTANCE.getegid();
        Pointer pg = CLibrary.INSTANCE.getgrgid(egid);
        if (pg == null) {
            this.log("could not get current group");
            return null;
        }
        return new CLibrary.group(pg).getName();
    }

    public String defaultGroup(String user) {
        Pointer p = CLibrary.INSTANCE.getpwnam(user);
        if (p == null) {
            this.log("could not get user " + user);
            return null;
        }
        int gid = new CLibrary.passwd(p).getGid();
        System.out.println("default group gid " + gid);
        Pointer pg = CLibrary.INSTANCE.getgrgid(gid);
        if (pg == null) {
            this.log("could not get default group for user " + user);
            return null;
        }
        return new CLibrary.group(pg).getName();
    }

    public void switchUser(String name, String password) {
        Pointer p;
        String group2;
        if (name == null || "".equals(name)) {
            return;
        }
        String[] x = name.split("\\\\");
        String user = x.length == 1 ? x[0] : x[1];
        String string = group2 = x.length == 1 ? null : x[0];
        if (group2 == null) {
            group2 = this.defaultGroup(user);
        }
        String currentUser = this.currentUser();
        String currentGroup = this.currentGroup();
        this.log("switch group " + currentGroup + " -> " + group2);
        if (currentGroup != null && !currentGroup.equals(group2)) {
            int res;
            p = CLibrary.INSTANCE.getgrnam(group2);
            CLibrary.group g = new CLibrary.group(p);
            int newGid = g.getGid();
            String nam = g.getName();
            if (newGid == 0) {
                this.log("could not get group " + group2);
            }
            if ((res = CLibrary.INSTANCE.setregid(newGid, newGid)) != 0) {
                this.log("could not change to group " + group2);
            }
        }
        this.log("switch user " + currentUser + " -> " + user);
        if (currentUser != null && !currentUser.equals(user)) {
            int res;
            p = CLibrary.INSTANCE.getpwnam(user);
            int newUid = new CLibrary.passwd(p).getUid();
            if (newUid == 0) {
                this.log("could not get user " + user);
            }
            if ((res = CLibrary.INSTANCE.setreuid(newUid, newUid)) != 0) {
                this.log("could not change to user " + user);
            }
        }
        if (!user.equals(currentUser = this.currentUser())) {
            this.log("could not set user. current user: " + currentUser);
        }
        if (!group2.equals(currentGroup = this.currentGroup())) {
            this.log("could not set group. current group: " + currentGroup);
        }
    }

    public String getUserInternal() {
        String status = this._utils.readFile("/proc/" + this._pid + "/status");
        if (status != null) {
            try {
                String sp = ".*[U|u]id:\\s*(\\d+)\\s*(\\d+)\\s*(\\d+)\\s*(\\d+).*";
                Pattern p = Pattern.compile(sp, 32);
                Matcher m = p.matcher(status);
                m.find();
                int ruid = Integer.parseInt(m.group(1));
                System.out.println("rudi " + ruid);
                Pointer po = CLibrary.INSTANCE.getpwuid(ruid);
                if (po == null) {
                    System.out.println("could not get user");
                }
                return new CLibrary.passwd(po).getName().trim();
            }
            catch (Exception ex) {
                this.log("Error in getUser() " + ex.getMessage());
            }
        }
        return "";
    }

    @Override
    public String getUser() {
        return this._user;
    }

    public String getStdInName() {
        return "stdin";
    }

    public String getStdOutName() {
        return "stdout";
    }

    public String getStdErrName() {
        return "stderr";
    }

    public int getStdOutNo() {
        return CLibrary.INSTANCE.fileno(NativeLibrary.getInstance((String)"c").getFunction(this.getStdOutName()).getPointer(0L));
    }

    public int getStdErrNo() {
        return CLibrary.INSTANCE.fileno(NativeLibrary.getInstance((String)"c").getFunction(this.getStdErrName()).getPointer(0L));
    }

    public int getStdInNo() {
        return CLibrary.INSTANCE.fileno(NativeLibrary.getInstance((String)"c").getFunction(this.getStdInName()).getPointer(0L));
    }

    @Override
    public int getCurrentHandles() {
        if (!this.isRunning()) {
            return -1;
        }
        File f = new File("/proc/" + this._pid + "/fd");
        if (!f.exists() || !f.isDirectory()) {
            return -1;
        }
        return f.list().length;
    }

    @Override
    public int getCurrentThreads() {
        int result;
        block4: {
            result = -1;
            if (!this.isRunning()) {
                return result;
            }
            String status = this._utils.readFile("/proc/" + this._pid + "/status");
            if (status != null) {
                try {
                    String sp = ".*[T|t]hreads:\\s*(\\d+).*";
                    Pattern p = Pattern.compile(sp, 32);
                    Matcher m = p.matcher(status);
                    m.find();
                    result = Integer.parseInt(m.group(1));
                }
                catch (Exception ex) {
                    if (this._logger == null) break block4;
                    this._logger.info("Error in getCurrentThreads() " + ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public int getCurrentCpu() {
        int result;
        block5: {
            result = -1;
            if (!this.isRunning()) {
                return result;
            }
            String stat2 = this._utils.readFile("/proc/" + this._pid + "/stat");
            if (this.status != null) {
                try {
                    String sp = "(?:[^\\s]+[\\s]+){13}(\\d+)\\s+(\\d+).+";
                    Pattern p = Pattern.compile(sp, 32);
                    Matcher m = p.matcher(stat2);
                    m.find();
                    int ucpu = Integer.parseInt(m.group(1).trim());
                    int scpu = Integer.parseInt(m.group(2).trim());
                    this._oldTotalCPU = this._currentTotalCPU;
                    this._currentTotalCPU = ucpu + scpu;
                    double elapsed = (double)(System.currentTimeMillis() - this._lastCPUReadTime) / 1000.0;
                    double used = this._currentTotalCPU - this._oldTotalCPU;
                    if (elapsed > 0.0) {
                        result = (int)(used / elapsed);
                    }
                    this._lastCPUReadTime = System.currentTimeMillis();
                }
                catch (Exception ex) {
                    if (this._logger == null) break block5;
                    this._logger.info("Error in getCurrentCPU() " + ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isTerminated() {
        return this._terminated;
    }

    public boolean setWorkingDirectory(String name) {
        boolean result;
        String dir;
        File f = new File(name);
        if (!f.exists() || !f.isDirectory()) {
            this.log("setWorkingDirectory failed. file not found " + name);
            return false;
        }
        try {
            dir = f.getCanonicalPath();
        }
        catch (IOException e) {
            if (this._logger != null) {
                this._logger.throwing(PosixProcess.class.getName(), "setWorkingDirectory", e);
            }
            return false;
        }
        boolean bl = result = CLibrary.INSTANCE.chdir(name) == 0;
        if (result) {
            System.setProperty("user.dir", dir);
        }
        return result;
    }

    public void setTerminated(boolean terminated) {
        this._terminated = terminated;
    }

    @Override
    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this._utils.setLog(logger);
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)(Platform.isLinux() ? "libc.so.6" : "c"), CLibrary.class);
        public static final int SIGTERM = 15;
        public static final int SIGKILL = 9;
        public static final int ESRCH = 3;
        public static final int WNOHANG = 1;
        public static final int WUNTRACED = 2;
        public static final int S_IFIFO = 4096;
        public static final int S_IFCHR = 8192;
        public static final int S_IFDIR = 16384;
        public static final int S_IFBLK = 24576;
        public static final int S_IFREG = 32768;
        public static final int S_IFLNK = 40960;
        public static final int S_IFSOCK = 49152;
        public static final int S_IFMT = 61440;
        public static final int S_ISUID = 2048;
        public static final int S_ISGID = 1024;
        public static final int S_ISVTX = 512;
        public static final int S_IRUSR = 256;
        public static final int S_IWUSR = 128;
        public static final int S_IXUSR = 64;
        public static final int S_IRGRP = 32;
        public static final int S_IWGRP = 16;
        public static final int S_IXGRP = 8;
        public static final int S_IROTH = 4;
        public static final int S_IWOTH = 2;
        public static final int S_IXOTH = 1;
        public static final int ALL_READ = 292;
        public static final int ALL_WRITE = 146;
        public static final int S_IXUGO = 73;

        public int fork();

        public void exit(int var1);

        public String strerror(int var1);

        public short readlink(String var1, Memory var2, short var3);

        public int execvp(String var1, String[] var2);

        public int execve(String var1, String[] var2, String[] var3);

        public int pipe(int[] var1);

        public int dup2(int var1, int var2);

        public int close(Pointer var1);

        public int close(int var1);

        public void umask(int var1);

        public int setsid();

        public Pointer freopen(String var1, String var2, int var3);

        public int kill(int var1, int var2);

        public int waitpid(int var1, IntByReference var2, int var3);

        public int chdir(String var1);

        public int fputc(int var1, Pointer var2);

        public Pointer fdopen(Pointer var1, String var2);

        public int fileno(Pointer var1);

        public Pointer opendir(String var1);

        public dirent64 readdir64(Pointer var1);

        public int closedir(Pointer var1);

        public int nice(int var1);

        public int sched_setaffinity(int var1, int var2, IntByReference var3);

        public int getpid();

        public int symlink(String var1, String var2);

        public Pointer getpwnam(String var1);

        public int geteuid();

        public Pointer getpwuid(int var1);

        public int setreuid(int var1, int var2);

        public Pointer getgrgid(int var1);

        public int getegid();

        public Pointer getgrnam(String var1);

        public int setregid(int var1, int var2);

        public int chmod(String var1, int var2);

        public int fstat(int var1, Pointer var2);

        public static class stat
        extends Structure {
            public long st_dev;
            public short __pad1;
            public int st_ino;
            public int st_mode;
            public int st_nlink;
            public int st_uid;
            public int st_gid;
            public long st_rdev;
            public short __pad2;
            public int st_size;
            public int st_blksize;
            public int st_blocks;
            public int st_atime;
            public int st_atimensec;
            public int st_mtime;
            public int st_mtimensec;
            public int st_ctime;
            public int st_ctimensec;
            public int __unused4;
            public int __unused5;

            public boolean isSocket() {
                return (this.st_mode & 0xF000) == 49152;
            }
        }

        public static class stat64
        extends Structure {
            public long st_dev;
            public long st_ino;
            public long st_nlink;
            public int st_mode;
            public int st_uid;
            public int st_gid;
            public long st_rdev;
            public long st_size;
            public long st_blksize;
            public long st_blocks;
            public long st_atime;
            public long st_atimensec;
            public long st_mtime;
            public long st_mtimensec;
            public long st_ctime;
            public long st_ctimensec;
            public long __unused4;
            public long __unused5;
            public long __unused6;

            public boolean isSocket() {
                return (this.st_mode & 0xF000) == 49152;
            }
        }

        public static class group
        extends Structure {
            public String gr_name = null;
            public String gr_password = null;
            public int gr_gid = 0;
            public Pointer gr_mem = null;

            public group(Pointer p) {
                if (p != null) {
                    this.useMemory(p);
                    this.read();
                }
            }

            public String getName() {
                return this.gr_name;
            }

            public int getGid() {
                return this.gr_gid;
            }
        }

        public static class passwd
        extends Structure {
            public String pw_name;
            public String pw_passwd;
            public int pw_uid;
            public int pw_gid;
            public String pw_gecos;
            public String pw_dir;
            public String pw_shell;

            public passwd(Pointer p) {
                if (p != null) {
                    this.useMemory(p);
                    this.read();
                }
            }

            public String getName() {
                return this.pw_name;
            }

            public int getUid() {
                return this.pw_uid;
            }

            public int getGid() {
                return this.pw_gid;
            }
        }

        public static class dirent
        extends Structure {
            public int d_ino;
            public int d_off;
            public short d_reclen;
            public String d_name;
        }

        public static class dirent64
        extends Structure {
            public long d_ino;
            public long d_off;
            public short d_reclen;
            public char d_type;
            public char[] d_name = new char[256];

            public String getName() {
                return this.getPointer().getString(19L, false);
            }
        }
    }
}

