/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import org.rzo.yajsw.os.ms.win.w32.PdhCounter;

public class PdhBufferedCounter
implements PdhCounter {
    PdhCounter _counter;
    int[] iBuff;
    double[] dBuff;
    long _frequency;
    long _lastAdd;
    long _nextAdd;
    int _head = -1;
    int _tail = -1;
    int _count = 0;
    int _iAvg;
    double _dAvg;

    public PdhBufferedCounter(PdhCounter counter, int buffSize, long frequency, Class valueType) {
        this._counter = counter;
        this._frequency = frequency;
        if (valueType.equals(Integer.TYPE)) {
            this.iBuff = new int[buffSize];
        } else if (valueType.equals(Double.TYPE)) {
            this.dBuff = new double[buffSize];
        }
    }

    @Override
    public double getDoubleValue() {
        return this._counter.getDoubleValue();
    }

    @Override
    public int getIntValue() {
        return this._counter.getIntValue();
    }

    @Override
    public boolean isValid() {
        return this._counter.isValid();
    }

    @Override
    public void close() {
        this._counter.close();
    }

    private void add() {
        if (this.iBuff != null) {
            if (this._count < this.iBuff.length) {
                ++this._count;
            }
            this._head = (this._head + 1) % this.iBuff.length;
            if (this._head == this._tail || this._tail == -1) {
                this._tail = (this._tail + 1) % this.iBuff.length;
            }
            this.iBuff[this._head] = this._counter.getIntValue();
            this._iAvg = (this._iAvg * (this._count - 1) + this.iBuff[this._head]) / this._count;
        } else if (this.dBuff != null) {
            if (this._count < this.dBuff.length) {
                ++this._count;
            }
            this._head = (this._head + 1) % this.dBuff.length;
            if (this._head == this._tail || this._tail == -1) {
                this._tail = (this._tail + 1) % this.dBuff.length;
            }
            this.dBuff[this._head] = this._counter.getDoubleValue();
            this._dAvg = (this._dAvg * (double)(this._count - 1) + this.dBuff[this._head]) / (double)this._count;
        }
    }

    public void tick() {
        long t = System.currentTimeMillis();
        if (t >= this._nextAdd) {
            this.add();
            this._lastAdd = t;
            this._nextAdd = this._lastAdd + this._frequency;
        }
    }

    public int getIntAvg() {
        return this._iAvg;
    }

    public double getDoubleAvg() {
        return this._dAvg;
    }

    public int getIntHead() {
        if (this.iBuff != null && this._head >= 0) {
            return this.iBuff[this._head];
        }
        return -1;
    }

    public double getDoubleHead() {
        if (this.dBuff != null && this._head >= 0) {
            return this.dBuff[this._head];
        }
        return -1.0;
    }

    public int[] getIntBuffer() {
        return this.iBuff;
    }

    public double[] getDoubleBuffer() {
        return this.dBuff;
    }
}

