/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.log;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class DateFileHandler
extends Handler {
    volatile FileHandler _handler;
    volatile long _endDate;
    volatile String _pattern;
    volatile int _limit;
    volatile int _count;
    volatile boolean _append;
    final SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    volatile boolean _init = false;
    volatile long _startDate = System.currentTimeMillis();

    public DateFileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        this._pattern = pattern;
        this._limit = limit;
        this._count = count;
        this._append = append;
        this.rotateDate();
        this._init = true;
    }

    @Override
    public void close() throws SecurityException {
        this._handler.close();
    }

    @Override
    public void flush() {
        this._handler.flush();
    }

    @Override
    public void publish(LogRecord record) {
        if (this._endDate < record.getMillis()) {
            this.rotateDate();
        }
        if (System.currentTimeMillis() - this._startDate > 90000000L) {
            String msg = record.getMessage();
            record.setMessage("missed file rolling at: " + new Date(this._endDate) + "\n" + msg);
        }
        this._handler.publish(record);
    }

    @Override
    public void setFormatter(Formatter newFormatter) {
        super.setFormatter(newFormatter);
        if (this._handler != null) {
            this._handler.setFormatter(newFormatter);
        }
    }

    private void rotateDate() {
        this._startDate = System.currentTimeMillis();
        if (this._handler != null) {
            this._handler.close();
        }
        String pattern = this._pattern.replace("%d", this.format.format(new Date()));
        Calendar next = Calendar.getInstance();
        next.set(11, 0);
        next.set(12, 0);
        next.set(13, 0);
        next.set(14, 0);
        next.add(5, 1);
        this._endDate = next.getTimeInMillis();
        try {
            this._handler = new FileHandler(pattern, this._limit, this._count, this._append);
            if (this._init) {
                this._handler.setEncoding(this.getEncoding());
                this._handler.setErrorManager(this.getErrorManager());
                this._handler.setFilter(this.getFilter());
                this._handler.setFormatter(this.getFormatter());
                this._handler.setLevel(this.getLevel());
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

