/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.boot;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang.text.StrSubstitutor;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.app.WrapperJVMMain;
import org.rzo.yajsw.boot.WrapperClassLoader;

public class WrapperLoader {
    private static boolean checkPath(String path) {
        int ix = path.indexOf("!");
        if (ix == -1) {
            System.out.println("<yajsw>/wrapper.jar not found, please check classpath. aborting wrapper !");
            Runtime.getRuntime().halt(999);
            return false;
        }
        return true;
    }

    public static String getWrapperJar() {
        String cn = Constants.class.getCanonicalName();
        String rn = cn.replace('.', '/') + ".class";
        String path = ".";
        try {
            path = Constants.class.getClassLoader().getResource(rn).getPath();
            if (!WrapperLoader.checkPath(path)) {
                return null;
            }
            path = path.substring(0, path.indexOf("!"));
            path = new URI(path).getPath();
            path.replaceAll("%20", " ");
            return path;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static String getWrapperAppJar() {
        String cn = WrapperJVMMain.class.getCanonicalName();
        String rn = cn.replace('.', '/') + ".class";
        String path = ".";
        try {
            path = WrapperJVMMain.class.getClassLoader().getResource(rn).getPath();
            if (!WrapperLoader.checkPath(path)) {
                return null;
            }
            path = path.substring(0, path.indexOf("!"));
            path = new URI(path).getPath();
            path.replaceAll("%20", " ");
            return path;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static ArrayList getGroovyClasspath() {
        File[] groovyLibs;
        ArrayList<URL> result = new ArrayList<URL>();
        String wrapperHome = WrapperLoader.getWrapperHome();
        File groovyLib = new File(wrapperHome, "lib");
        if (!groovyLib.exists()) {
            System.out.println("<yajsw>/lib folder not found. Please check that relative the lib folder is in the same folder as <yajsw>/wrapper.jar");
            return result;
        }
        for (File file : groovyLibs = groovyLib.listFiles()) {
            if (file.isDirectory()) {
                result.addAll(WrapperLoader.getFiles(file));
                continue;
            }
            try {
                result.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                System.out.println("Error in getGroovyClasspath: " + e.getMessage());
            }
        }
        return result;
    }

    private static Collection getFiles(File parent) {
        File[] files;
        ArrayList<URL> result = new ArrayList<URL>();
        for (File file : files = parent.listFiles()) {
            if (file.isDirectory()) {
                result.addAll(WrapperLoader.getFiles(file));
                continue;
            }
            try {
                result.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                System.out.println("Error in getGroovyClasspath: " + e.getMessage());
            }
        }
        return result;
    }

    public static URL[] getWrapperClasspath(String type, boolean logErrors) {
        Manifest manifest;
        String wrapperJar = "App".equals(type) ? WrapperLoader.getWrapperAppJar() : WrapperLoader.getWrapperJar();
        try {
            manifest = new JarFile(wrapperJar).getManifest();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        Attributes attr = manifest.getMainAttributes();
        String cl = attr.getValue("Class-Path-" + type);
        if (cl == null) {
            return null;
        }
        ArrayList<File> classpath = new ArrayList<File>();
        classpath.add(new File(wrapperJar));
        String[] clArr = cl.split(" ");
        File parent = new File(wrapperJar).getParentFile();
        StrSubstitutor x = new StrSubstitutor();
        x.setEnableSubstitutionInVariables(true);
        for (int i = 0; i < clArr.length; ++i) {
            String file = clArr[i];
            try {
                String replacement = x.replace(file);
                File myFile = !x.equals(file) ? new File(file) : new File(parent, file);
                if (!myFile.exists() && logErrors) {
                    System.out.println("WARNING: lib not found: " + myFile.getCanonicalPath());
                }
                classpath.add(myFile);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ("App".equals(type)) {
            try {
                String rt = WrapperLoader.getRTJar();
                File rtf = new File(rt);
                if (!rtf.exists()) {
                    System.out.println("could not find rt.jar");
                } else {
                    classpath.add(rtf);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        URL[] urlsArr = new URL[classpath.size()];
        int i = 0;
        Iterator it = classpath.iterator();
        while (it.hasNext()) {
            try {
                urlsArr[i] = ((File)it.next()).toURI().toURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return urlsArr;
    }

    public static URLClassLoader getWrapperClassLoader() {
        URL[] core = WrapperLoader.getWrapperClasspath("Wrapper-Core", true);
        URL[] extended = WrapperLoader.getWrapperClasspath("Wrapper-Extended", false);
        if (core == null) {
            core = new URL[]{};
        }
        if (extended == null) {
            extended = new URL[]{};
        }
        URL[] urls = new URL[core.length + extended.length];
        System.arraycopy(core, 0, urls, 0, core.length);
        System.arraycopy(extended, 0, urls, core.length, extended.length);
        return new WrapperClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    public static String getWrapperHome() {
        return new File(WrapperLoader.getWrapperJar()).getParent();
    }

    public static String getRTJar() {
        String cn = Object.class.getCanonicalName();
        String rn = cn.replace('.', '/') + ".class";
        String path = ".";
        try {
            path = WrapperJVMMain.class.getClassLoader().getResource(rn).getPath();
            if (!WrapperLoader.checkPath(path)) {
                return null;
            }
            path = path.substring(0, path.indexOf("!"));
            path = new URI(path).getPath();
            path.replaceAll("%20", " ");
            return path;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }
}

