/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.app;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.configuration.Configuration;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.SimpleLoggerFactory;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.action.Action;
import org.rzo.yajsw.action.ActionFactory;
import org.rzo.yajsw.app.WrapperManager;
import org.rzo.yajsw.app.WrapperManagerImplMBean;
import org.rzo.yajsw.config.ConfigUtils;
import org.rzo.yajsw.config.YajswConfiguration;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.MessageDecoder;
import org.rzo.yajsw.controller.jvm.MessageEncoder;
import org.rzo.yajsw.io.CyclicBufferFileInputStream;
import org.rzo.yajsw.io.CyclicBufferFilePrintStream;
import org.rzo.yajsw.io.TeeInputStream;
import org.rzo.yajsw.io.TeeOutputStream;
import org.rzo.yajsw.nettyutils.SystemOutLoggingFilter;
import org.rzo.yajsw.script.Script;
import org.rzo.yajsw.script.ScriptFactory;
import org.rzo.yajsw.util.Cycler;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.wrapper.AlphanumComparator;

public class WrapperManagerImpl
implements WrapperManager,
Constants,
WrapperManagerImplMBean {
    int _port = 15003;
    boolean _debug = false;
    final InternalLogger log = SimpleLoggerFactory.getInstance("WrapperManager");
    volatile boolean _started = false;
    String _key;
    int _pingInterval = 5;
    ClientBootstrap connector;
    volatile Channel _session;
    volatile boolean _stopping = false;
    Configuration _config;
    static WrapperManagerImpl instance;
    int _exitCode = 0;
    Method mainMethod = null;
    String[] mainMethodArgs = null;
    int exitOnMainTerminate = -1;
    private int exitOnException = 999;
    volatile int _myPid = -1;
    boolean _externalStop = false;
    String _groovyScript = null;
    Cycler _pinger;
    OutputStream _outStream;
    OutputStream _errStream;
    volatile boolean _appearHanging = false;
    boolean _overrideStdErr = false;
    boolean _haltAppOnWrapper = false;
    Lock _lock = new ReentrantLock();
    Condition _connectEnd = this._lock.newCondition();
    Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("yajsw-pool"));
    long _startupTimeout = 0L;
    String shutdownScript = null;
    Properties _properties;
    volatile boolean _dumpingHeap = false;
    volatile String _stopReason = null;
    volatile boolean _heapNotified = false;

    @Override
    public void init(String[] args, ClassLoader wrapperClassLoader) {
        boolean visible;
        System.out.println("initializing wrapped process");
        String commonsLog = System.getProperty("org.apache.commons.logging.Log");
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wrapperClassLoader);
        instance = this;
        String outFile = System.getProperty("wrapper.teeName");
        String outPath = System.getProperty("wrapper.tmpPath");
        String vStr = System.getProperty("wrapper.console.visible");
        boolean bl = visible = vStr != null && vStr.equals("true");
        if (outFile != null) {
            this.teeSystemStreams(outFile, outPath, visible);
        }
        this.logJavaInfo(args);
        String preScript = System.getProperty("wrapper.app.pre.script");
        if (preScript != null & !"".equals(preScript)) {
            try {
                System.out.println("wrapped process: executing pre script " + preScript);
                Script script = ScriptFactory.createScript(preScript, "wrapper.app.pre.script", null, new String[0], this.log, 0);
                if (script != null) {
                    script.execute();
                } else {
                    System.out.println("wrapped process: executing pre script error: could not open script");
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        YajswConfigurationImpl config = new YajswConfigurationImpl();
        config.init();
        this._debug = config.getBoolean("wrapper.debug", false);
        try {
            this._overrideStdErr = config.getBoolean("wrapper.java.dump.override", false);
        }
        catch (Exception ex) {
            System.out.println("Error getting wrapper.java.dump.override " + ex.getMessage());
        }
        try {
            String control;
            String mainClassName = config.getString("wrapper.java.app.mainclass");
            String jarName = config.getString("wrapper.java.app.jar");
            String groovyScript = config.getString("wrapper.groovy");
            if (mainClassName == null && jarName == null && groovyScript == null) {
                mainClassName = config.getString("wrapper.app.parameter.1");
            }
            if (this._debug) {
                System.out.println("mainClass/jar/script: " + mainClassName + "/" + jarName + "/" + groovyScript);
            }
            if (jarName == null && mainClassName == null && groovyScript == null) {
                System.out.println("missing main class name or jar file or groovy file. please check configuration");
                return;
            }
            if (jarName != null) {
                this.mainMethod = this.loadJar(jarName);
            } else if (mainClassName != null) {
                try {
                    Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(mainClassName);
                    this.mainMethod = cls.getMethod("main", String[].class);
                }
                catch (Exception e) {
                    System.out.println("error finding main method in class: " + mainClassName + " : " + e.getMessage());
                    e.printStackTrace();
                    return;
                }
            } else {
                this._groovyScript = groovyScript;
            }
            String stopConfig = config.getString("wrapper.stop.conf");
            if (stopConfig != null) {
                File f = new File(stopConfig);
                this._externalStop = true;
            }
            if (this._debug) {
                System.out.println("external stop " + this._externalStop);
            }
            this.exitOnMainTerminate = config.getInt("wrapper.exit_on_main_terminate", -1);
            this.exitOnException = config.getInt("wrapper.exit_on_main_exception", 999);
            this.mainMethodArgs = this.getAppParam((Configuration)config);
            this.setConfiguration((Configuration)config);
            if (this._config.getBoolean("wrapper.java.jmx", false)) {
                this.registerMBean(config);
            }
            if ("TIGHT".equals(control = this._config.getString("wrapper.control", "TIGHT")) || "APPLICATION".equals(control)) {
                this._haltAppOnWrapper = true;
            }
            this.setKey(this._config.getString("wrapper.key"));
            this.setPort(this._config.getInt("wrapper.port"));
            this.setPingInterval(this._config.getInt("wrapper.ping.interval", 5));
            this._startupTimeout = this._config.getInt("wrapper.startup.timeout", 30) * 1000;
            this.shutdownScript = this._config.getString("wrapper.app.shutdown.script", null);
            if (this.shutdownScript != null && !"".equals(this.shutdownScript)) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        WrapperManagerImpl.this.executeShutdownScript();
                    }
                });
            }
            this.monitorDeadLocks(config);
            this.monitorHeap(config);
            this.monitorGc(config);
            if (this._debug) {
                System.out.println("terminated WrapperManager.init()");
            }
            if (commonsLog != null) {
                System.setProperty("org.apache.commons.logging.Log", commonsLog);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (currentClassLoader != null) {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private void monitorDeadLocks(YajswConfigurationImpl config) {
        if (config.getBoolean("wrapper.java.monitor.deadlock", false)) {
            final long cycle = config.getLong("wrapper.java.monitor.deadlock.interval", 30L) * 1000L;
            final ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (this._debug) {
                System.out.println("monitor deadlock: start");
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    while (!WrapperManagerImpl.this._stopping) {
                        long[] ids = bean.findDeadlockedThreads();
                        if (ids != null && ids.length > 0) {
                            System.err.println("wrapper.java.monitor.deadlock: DEADLOCK IN THREADS: ");
                            WrapperManagerImpl.this.threadDump(ids);
                            return;
                        }
                        try {
                            Thread.sleep(cycle);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            });
        }
    }

    private void monitorHeap(YajswConfigurationImpl config) {
        if (config.getBoolean("wrapper.java.monitor.heap", false)) {
            final long cycle = config.getLong("wrapper.java.monitor.heap.interval", 30L) * 1000L;
            final int thresholdPercent = config.getInt("wrapper.java.monitor.heap.threshold.percent", 95);
            final MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
            final long maxHeap = bean.getHeapMemoryUsage().getMax();
            if (this._debug) {
                System.out.println("monitor heap: start");
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    while (!WrapperManagerImpl.this._stopping) {
                        float currentPercent = (float)bean.getHeapMemoryUsage().getUsed() / (float)maxHeap * 100.0f;
                        if (currentPercent > (float)thresholdPercent) {
                            if (!WrapperManagerImpl.this._heapNotified) {
                                System.err.println("wrapper.java.monitor.heap: HEAP SIZE EXCEEDS THRESHOLD: " + bean.getHeapMemoryUsage().getUsed() + "/" + maxHeap);
                                WrapperManagerImpl.this._heapNotified = true;
                            }
                        } else if (WrapperManagerImpl.this._heapNotified) {
                            System.err.println("wrapper.java.monitor.heap: HEAP SIZE OK: " + bean.getHeapMemoryUsage().getUsed() + "/" + maxHeap);
                            WrapperManagerImpl.this._heapNotified = false;
                        }
                        try {
                            Thread.sleep(cycle);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            });
        }
    }

    private void monitorGc(YajswConfigurationImpl config) {
        String mFormat = config.getString("wrapper.java.monitor.gc", null);
        if (mFormat != null) {
            try {
                if (this._debug) {
                    System.out.println("monitor GC: " + mFormat);
                }
                MessageFormat format = new MessageFormat(mFormat);
                long cycle = config.getLong("wrapper.java.monitor.gc.interval", 1L) * 1000L;
                GarbageCollectorMXBean minorGCBeanX = null;
                MemoryManagerMXBean fullGCBeanX = null;
                List<GarbageCollectorMXBean> gcMBeans = ManagementFactory.getGarbageCollectorMXBeans();
                for (GarbageCollectorMXBean gcBean : gcMBeans) {
                    if (gcBean.getName().toLowerCase().contains("copy")) {
                        minorGCBeanX = gcBean;
                        continue;
                    }
                    if ("ParNew".equals(gcBean.getName())) {
                        minorGCBeanX = gcBean;
                        continue;
                    }
                    if (gcBean.getName().toLowerCase().contains("scavenge")) {
                        minorGCBeanX = gcBean;
                        continue;
                    }
                    if (gcBean.getName().toLowerCase().contains("marksweep")) {
                        fullGCBeanX = gcBean;
                        continue;
                    }
                    System.err.println("Unable to classify GarbageCollectorMXBean [" + gcBean.getName() + "]");
                }
                final GarbageCollectorMXBean minorGCBean = minorGCBeanX;
                MemoryManagerMXBean fullGCBean = fullGCBeanX;
                MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
                if (this._debug) {
                    System.out.println("monitor gc: minorGCBean/fullGCBean: " + minorGCBean.getName() + "/" + fullGCBean.getName());
                    System.out.println("monitor gc: start cycle " + cycle + "ms");
                }
                this.executor.execute(new Runnable((GarbageCollectorMXBean)fullGCBean, bean, format, cycle){
                    private long lastMinorCollectionCount;
                    private long lastMinorCollectionTime;
                    private long lastFullCollectionCount;
                    private long lastFullCollectionTime;
                    Long usedHeap = null;
                    Long timeMinorGC = null;
                    Long timeFullGC = null;
                    final /* synthetic */ GarbageCollectorMXBean val$fullGCBean;
                    final /* synthetic */ MemoryMXBean val$bean;
                    final /* synthetic */ MessageFormat val$format;
                    final /* synthetic */ long val$cycle;
                    {
                        this.val$fullGCBean = garbageCollectorMXBean2;
                        this.val$bean = memoryMXBean;
                        this.val$format = messageFormat;
                        this.val$cycle = l;
                    }

                    @Override
                    public void run() {
                        if (minorGCBean == null) {
                            System.err.println("monitor gc: could not find minorGCBean -> abort monitor");
                            return;
                        }
                        if (this.val$fullGCBean == null) {
                            System.err.println("monitor gc: could not find fullGCBean -> abort monitor");
                            return;
                        }
                        try {
                            while (!WrapperManagerImpl.this._stopping) {
                                long diffTime;
                                long diffCount;
                                if (minorGCBean.getCollectionCount() != this.lastMinorCollectionCount) {
                                    diffCount = minorGCBean.getCollectionCount() - this.lastMinorCollectionCount;
                                    diffTime = minorGCBean.getCollectionTime() - this.lastMinorCollectionTime;
                                    this.timeMinorGC = diffCount != 0L && diffCount != 1L ? Long.valueOf(diffTime / diffCount) : Long.valueOf(diffTime);
                                    this.usedHeap = this.val$bean.getHeapMemoryUsage().getUsed();
                                    this.lastMinorCollectionCount = minorGCBean.getCollectionCount();
                                    this.lastMinorCollectionTime = minorGCBean.getCollectionTime();
                                }
                                if (this.val$fullGCBean.getCollectionCount() != this.lastFullCollectionCount) {
                                    diffCount = this.val$fullGCBean.getCollectionCount() - this.lastFullCollectionCount;
                                    diffTime = this.val$fullGCBean.getCollectionTime() - this.lastFullCollectionTime;
                                    this.timeFullGC = diffCount != 0L && diffCount != 1L ? Long.valueOf(diffTime / diffCount) : Long.valueOf(diffTime);
                                    this.usedHeap = this.val$bean.getHeapMemoryUsage().getUsed();
                                    this.lastFullCollectionCount = this.val$fullGCBean.getCollectionCount();
                                    this.lastFullCollectionTime = this.val$fullGCBean.getCollectionTime();
                                }
                                if (this.usedHeap != null) {
                                    if (this.timeMinorGC == null) {
                                        this.timeMinorGC = 0L;
                                    }
                                    if (this.timeFullGC == null) {
                                        this.timeFullGC = 0L;
                                    }
                                    System.err.println(this.val$format.format(new Object[]{this.usedHeap, this.timeMinorGC, this.timeFullGC}));
                                    this.usedHeap = null;
                                    this.timeMinorGC = null;
                                    this.timeFullGC = null;
                                }
                                Thread.sleep(this.val$cycle);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        System.err.println("monitor gc: end");
                    }
                });
            }
            catch (Exception ex) {
                System.err.println("monitor gc: exception: " + ex);
            }
        }
    }

    private void registerMBean(YajswConfiguration config) {
        MBeanServer server = null;
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        try {
            if (servers != null && servers.size() > 0) {
                server = servers.get(0);
            }
            if (server != null) {
                String name = config.getString("wrapper.console.title");
                if (name == null) {
                    name = config.getString("wrapper.ntservice.name");
                }
                if (name == null) {
                    name = "yajsw.noname";
                }
                ObjectName oName = new ObjectName("Wrapper", "name", name);
                server.registerMBean(this, oName);
            } else {
                System.out.println("ERROR: no mbean server found ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Method getMainMethod() {
        return this.mainMethod;
    }

    @Override
    public Object[] getMainMethodArgs() {
        return this.mainMethodArgs;
    }

    @Override
    public int getExitOnMainTerminate() {
        if (this._debug) {
            System.out.println("exit on main terminate " + this.exitOnMainTerminate);
        }
        return this.exitOnMainTerminate;
    }

    @Override
    public int getExitOnException() {
        if (this._debug) {
            System.out.println("exit on main exception " + this.exitOnException);
        }
        return this.exitOnException;
    }

    private Method loadJar(String jarName) {
        String mainClassName;
        Manifest manifest;
        URL url = null;
        try {
            url = new File(jarName).toURI().toURL();
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            return null;
        }
        try {
            manifest = new JarFile(new File(jarName)).getManifest();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        Attributes attr = manifest.getMainAttributes();
        String cl = attr.getValue("Class-Path");
        ClassLoader loader = null;
        if (cl != null) {
            ArrayList<File> classpath = new ArrayList<File>();
            String[] clArr = cl.split(" ");
            for (int i = 0; i < clArr.length; ++i) {
                String file = clArr[i];
                try {
                    File myFile = new File(file);
                    classpath.add(myFile);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            URL[] urlsArr = new URL[classpath.size()];
            int i = 0;
            Iterator it = classpath.iterator();
            while (it.hasNext()) {
                try {
                    urlsArr[i] = ((File)it.next()).toURI().toURL();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            loader = new URLClassLoader(urlsArr, ClassLoader.getSystemClassLoader());
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((mainClassName = attr.getValue("Main-Class")) == null) {
            return null;
        }
        Method mainMethod = null;
        try {
            Class<?> cls = loader.loadClass(mainClassName);
            mainMethod = cls.getMethod("main", String[].class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mainMethod;
    }

    private File createRWfile(String path, String fname) {
        File result = new File(path, fname);
        try {
            if (!result.exists()) {
                // empty if block
            }
            String name = result.getCanonicalPath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private void teeSystemStreams(String outFile, String path, boolean visible) {
        File fOut = this.createRWfile(path, "out_" + outFile);
        File fErr = this.createRWfile(path, "err_" + outFile);
        File fIn = this.createRWfile(path, "in_" + outFile);
        try {
            CyclicBufferFilePrintStream wrapperOut = new CyclicBufferFilePrintStream(fOut);
            TeeOutputStream newOut = new TeeOutputStream();
            newOut.connect(wrapperOut);
            if (visible) {
                newOut.connect(System.out);
            }
            this._outStream = wrapperOut;
            System.setOut(new PrintStream(newOut));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            CyclicBufferFilePrintStream wrapperErr = new CyclicBufferFilePrintStream(fErr);
            TeeOutputStream newErr = new TeeOutputStream();
            newErr.connect(wrapperErr);
            if (visible) {
                newErr.connect(System.err);
            }
            this._errStream = newErr;
            System.setErr(new PrintStream(newErr));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            CyclicBufferFileInputStream wrapperIn = new CyclicBufferFileInputStream(fIn);
            TeeInputStream newIn = new TeeInputStream();
            newIn.connect(wrapperIn);
            newIn.connect(System.in);
            System.setIn(newIn);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void logJavaInfo(String[] args) {
        if (this._debug) {
            System.out.println("APP user name=" + System.getProperty("user.name"));
            System.out.println("APP working dir=" + System.getProperty("user.dir"));
            System.out.println("APP java version=" + System.getProperty("java.version"));
            System.out.println("APP class path=" + System.getProperty("java.class.path"));
            System.out.println("APP library path=" + System.getProperty("java.library.path"));
        }
        String[] files = System.getProperty("java.class.path").split(File.pathSeparator);
        for (int i = 0; i < files.length; ++i) {
            File f = new File(files[i]);
            if (f.exists()) continue;
            System.err.println("Classpath File not found: " + files[i]);
        }
        if (this._debug) {
            String argsStr = "Application args: ";
            if (args != null && args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    argsStr = argsStr + args[i] + " ";
                }
            } else {
                argsStr = argsStr + "no args";
            }
            System.out.println(argsStr);
        }
    }

    private String[] getAppParam(Configuration config) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList keys = new ArrayList();
        ListIterator it = config.getKeys("wrapper.app.parameter");
        while (it.hasNext()) {
            keys.add(it.next());
        }
        Collections.sort(keys, new AlphanumComparator());
        it = keys.listIterator();
        while (it.hasNext()) {
            result.add(config.getString((String)it.next()));
        }
        String[] args = new String[result.size()];
        int i = 0;
        Iterator it2 = result.iterator();
        while (it2.hasNext()) {
            args[i] = (String)it2.next();
            ++i;
        }
        if (this._debug) {
            System.out.println("args: ");
            for (String arg : args) {
                System.out.println(arg);
            }
        }
        return args;
    }

    void setConfiguration(Configuration config) {
        this._config = config;
    }

    @Override
    public void start() {
        this.connector = new ClientBootstrap((ChannelFactory)new OioClientSocketChannelFactory(this.executor));
        if (this._debug) {
            this.connector.getPipeline().addLast("logger", (ChannelHandler)new SystemOutLoggingFilter("WrapperManager"));
            System.out.println("Logging ON");
        }
        this.connector.getPipeline().addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(8192, true, Delimiters.nulDelimiter()));
        this.connector.getPipeline().addLast("messageEncoder", (ChannelHandler)new MessageEncoder());
        this.connector.getPipeline().addLast("messageDecoder", (ChannelHandler)new MessageDecoder());
        this._pinger = new Cycler(this.getPingInterval(), 0L, Executors.newCachedThreadPool(new DaemonThreadFactory("pinger", 10)), new Runnable(){
            long start = System.currentTimeMillis();

            @Override
            public void run() {
                if (WrapperManagerImpl.this._session != null && WrapperManagerImpl.this._session.isConnected() && !WrapperManagerImpl.this._stopping && !WrapperManagerImpl.this._appearHanging) {
                    ChannelFuture future = WrapperManagerImpl.this._session.write((Object)new Message(103, null));
                    try {
                        future.await(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.start = System.currentTimeMillis();
                } else if (WrapperManagerImpl.this._haltAppOnWrapper && System.currentTimeMillis() - this.start > WrapperManagerImpl.this._startupTimeout && !WrapperManagerImpl.this._stopping) {
                    System.out.println("no connection to wrapper during " + WrapperManagerImpl.this._startupTimeout / 1000L + "seconds -> System.exit(-1)");
                    System.out.println("if this is due to server overload consider increasing yajsw configuration property wrapper.startup.timeout");
                    System.exit(-1);
                }
            }
        });
        this._pinger.start();
        this.connector.setOption("remoteAddress", (Object)new InetSocketAddress("127.0.0.1", this._port));
        this.connector.setOption("connectTimeoutMillis", (Object)10000);
        this.connector.setOption("reuseAddress", (Object)true);
        this.connector.setOption("tcpNoDelay", (Object)true);
        this.connector.getPipeline().addLast("handler", (ChannelHandler)new WrapperHandler());
        this.reconnect();
    }

    private void reconnect() {
        while (!this._started) {
            if (this._debug) {
                System.out.println("connecting to port " + this._port);
            }
            ChannelFuture future1 = this.connector.connect();
            try {
                future1.await();
                this._started = future1.isSuccess();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            if (this._started) {
                future1.getChannel().write((Object)new Message(110, this._key));
                continue;
            }
            try {
                if (this._debug) {
                    System.out.println("connection failed -> sleep then retry");
                }
                this._started = false;
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    boolean isDebug() {
        return this._debug;
    }

    void setDebug(boolean debug) {
        this._debug = debug;
    }

    String getKey() {
        return this._key;
    }

    public void setKey(String key) {
        this._key = key;
    }

    boolean isStarted() {
        return this._started;
    }

    int getPingInterval() {
        return this._pingInterval;
    }

    void setPingInterval(int pingInterval) {
        this._pingInterval = pingInterval * 1000;
    }

    @Override
    public void stop() {
        if (this._session != null) {
            while (this._session != null && !this._stopping) {
                this._session.write((Object)new Message(101, null));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.exit(0);
        }
    }

    @Override
    public void stopTimer() {
        if (this._session != null) {
            while (this._session != null && !this._stopping) {
                this._session.write((Object)new Message(117, null));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void restart() {
        if (this._session != null) {
            while (this._session != null && !this._stopping) {
                this._session.write((Object)new Message(102, null));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("not connected to wrapper -> cannot send restart command");
        }
    }

    public static WrapperManagerImpl instance() {
        return instance;
    }

    @Override
    public int getPid() {
        return this._myPid;
    }

    @Override
    public boolean isControlledByWrapper() {
        return this._started;
    }

    @Override
    public boolean isLaunchedAsService() {
        return this._config.getBoolean("wrapper.service", false);
    }

    @Override
    public String getGroovyScript() {
        return this._groovyScript;
    }

    @Override
    public void threadDump() {
        System.out.println("yajsw: thread dump requested");
        this.threadDump(null);
    }

    public void threadDump(long[] ids) {
        Message m = new Message(118, null);
        Action a = ActionFactory.getAction(m);
        try {
            if (this._overrideStdErr) {
                a.execute(m, this._session, new PrintStream(this._errStream), ids);
            } else {
                a.execute(m, this._session, System.err, ids);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void gc() {
        System.out.println("yajsw: gc requested");
        System.gc();
    }

    @Override
    public void dumpHeap(final String fileName) {
        if (this._dumpingHeap) {
            return;
        }
        System.out.println("yajsw: dumpHeap requested " + fileName);
        this._dumpingHeap = true;
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    File parent;
                    File file = fileName == null || fileName.length() < 1 ? new File(".") : new File(fileName);
                    if (file.isDirectory()) {
                        parent = file;
                        file = new File(parent, "dump_" + new SimpleDateFormat("yyyy_MM_dd-hh_mm").format(new Date()) + ".hprof");
                    } else {
                        parent = file.getParentFile();
                    }
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    List<HotSpotDiagnosticMXBean> list = ManagementFactory.getPlatformMXBeans(HotSpotDiagnosticMXBean.class);
                    HotSpotDiagnosticMXBean mb = list.get(0);
                    File dumpFile = new File(parent, file.getName());
                    mb.dumpHeap(dumpFile.getAbsolutePath(), true);
                    System.out.println("yajsw: dumpHeap done " + dumpFile.getAbsolutePath());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                finally {
                    WrapperManagerImpl.this._dumpingHeap = false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws MalformedURLException {
        String name = "c:/test test/start.jar";
        System.out.println(new File(name).exists());
        System.out.println(new File(new File(name).toURI().getPath()).exists());
        WrapperManagerImpl wm = new WrapperManagerImpl();
        wm.loadJar("c:/test test/start.jar");
        WrapperManagerImpl wrapperManagerImpl = wm;
        synchronized (wrapperManagerImpl) {
            wm.threadDump();
        }
    }

    @Override
    public boolean isAppearHanging() {
        return this._appearHanging;
    }

    @Override
    public void setAppearHanging(boolean appearHanging) {
        this._appearHanging = appearHanging;
    }

    @Override
    public void reportServiceStartup() {
        boolean reported = false;
        while (!reported && !this._stopping) {
            if (this._session == null || !this._session.isConnected()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
                continue;
            }
            this._session.write((Object)new Message(119, null));
            reported = true;
        }
    }

    private void executeShutdownScript() {
        Script script;
        if (this.shutdownScript != null & !"".equals(this.shutdownScript) && (script = ScriptFactory.createScript(this.shutdownScript, "wrapper.app.shutdown.script", null, new String[0], this.log, 0)) != null) {
            script.execute();
        }
    }

    @Override
    public void executeScript(String scriptFileName, ClassLoader wrapperClassLoader) {
        System.out.println("initializing wrapped process");
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wrapperClassLoader);
        try {
            Script script = ScriptFactory.createScript(scriptFileName, "", null, (String[])this.getMainMethodArgs(), null, 0);
            if (script != null) {
                script.execute();
            } else {
                System.err.println("error opening script script: " + scriptFileName);
            }
        }
        catch (Throwable ex) {
            System.err.println("error executing script: " + scriptFileName);
            ex.printStackTrace();
        }
        Thread.currentThread().setContextClassLoader(currentClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalStopping(int timeoutHint) {
        try {
            if (this._session == null || !this._session.isConnected()) {
                ChannelFuture future1 = this.connector.connect();
                future1.await();
                future1.isSuccess();
                this._session = future1.getChannel();
            }
            ChannelFuture wFuture = this._session.write((Object)new Message(104, String.valueOf(timeoutHint)));
            wFuture.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._session.close();
            this._session = null;
        }
    }

    @Override
    public Properties getProperties() {
        if (this._properties == null) {
            this._properties = ConfigUtils.asProperties(this._config);
        }
        return this._properties;
    }

    @Override
    public String getStopReason() {
        return this._stopReason;
    }

    @ChannelPipelineCoverage(value="one")
    class WrapperHandler
    extends SimpleChannelHandler {
        WrapperHandler() {
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (WrapperManagerImpl.this._debug) {
                System.out.println("session closed");
            }
            WrapperManagerImpl.this._started = false;
            try {
                WrapperManagerImpl.this._session.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            WrapperManagerImpl.this._session = null;
            if (!WrapperManagerImpl.this._stopping) {
                if (WrapperManagerImpl.this._debug) {
                    System.out.println("try reconnect");
                }
                WrapperManagerImpl.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        WrapperManagerImpl.this.reconnect();
                    }
                });
            }
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            if (WrapperManagerImpl.this._stopping) {
                return;
            }
            Channel session = ctx.getChannel();
            Message msg = (Message)e.getMessage();
            if (msg.getCode() == 101) {
                try {
                    System.out.println("wrapper manager received stop command");
                    WrapperManagerImpl.this._stopping = true;
                    if (session != null) {
                        session.close();
                    }
                    if (msg.getMessage() != null && msg.getMessage().length() > 0) {
                        try {
                            String[] txt = msg.getMessage().split(":");
                            if (txt[0].length() > 0) {
                                WrapperManagerImpl.this._exitCode = Integer.parseInt(txt[0]);
                            }
                            if (txt.length > 1 && txt[1].length() > 0) {
                                WrapperManagerImpl.this._stopReason = txt[1];
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (!WrapperManagerImpl.this._externalStop) {
                        System.exit(WrapperManagerImpl.this._exitCode);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (msg.getCode() == 116) {
                WrapperManagerImpl.this._session = session;
                try {
                    WrapperManagerImpl.this._myPid = Integer.parseInt(msg.getMessage());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (msg.getCode() == 118) {
                WrapperManagerImpl.this.threadDump();
            } else if (msg.getCode() == 120) {
                WrapperManagerImpl.this.gc();
            } else if (msg.getCode() == 121) {
                WrapperManagerImpl.this.dumpHeap(msg.getMessage());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (WrapperManagerImpl.this._debug) {
                e.getCause().printStackTrace();
            }
        }
    }
}

