/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.app;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jnacontrib.win32.Win32Service;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.StopableService;
import org.rzo.yajsw.wrapper.WrappedProcess;
import org.rzo.yajsw.wrapper.WrappedProcessFactory;
import org.rzo.yajsw.wrapper.WrappedProcessList;

public class WrapperMainServiceWin
extends Win32Service
implements StopableService {
    static volatile WrappedProcessList wList = new WrappedProcessList();
    static volatile WrappedProcess w;
    static volatile boolean _waitOnStop;
    static WrapperMainServiceWin service;
    static ExecutorService pool;

    public static void main(String[] args) {
        String wrapperJar = WrapperLoader.getWrapperJar();
        String homeDir = new File(wrapperJar).getParent();
        OperatingSystem.instance().setWorkingDir(homeDir);
        YajswConfigurationImpl _config = new YajswConfigurationImpl(false);
        service = new WrapperMainServiceWin();
        service.setServiceName(_config.getString("wrapper.ntservice.name"));
        int timeout = _config.getInt("wrapper.shutdown.timeout", 30) * 1000;
        timeout += _config.getInt("wrapper.script.STOP.timeout", 0) * 1000;
        timeout += _config.getInt("wrapper.script.SHUTDOWN.timeout", 0) * 1000;
        timeout += _config.getInt("wrapper.script.IDLE.timeout", 0) * 1000;
        service.setStopTimeout(timeout += _config.getInt("wrapper.script.ABORT.timeout", 0) * 1000);
        timeout = _config.getInt("wrapper.startup.timeout", 30) * 1000;
        service.setStartupTimeout(timeout);
        service.setAutoReportStartup(_config.getBoolean("wrapper.ntservice.autoreport.startup", true));
        if (_config.containsKey("wrapperx.config")) {
            List configs = _config.getList("wrapperx.config");
            wList = WrappedProcessFactory.createProcessList(new HashMap(), configs, true);
            for (WrappedProcess p : wList) {
                p.setService(service);
            }
        } else {
            WrappedProcess w = WrappedProcessFactory.createProcess(_config);
            w.setService(service);
            w.init();
            wList.add(w);
        }
        w = (WrappedProcess)wList.get(0);
        final long maxStartTime = w.getMaxStartTime();
        final Future<?> future = pool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.yield();
                    wList.startAll();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    w.getWrapperLogger().info("Win Service: error starting wrapper " + ex.getMessage());
                    Runtime.getRuntime().halt(999);
                }
            }
        });
        pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    future.get(maxStartTime, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    w.getWrapperLogger().info("Win Service: wrapper did not start within " + maxStartTime + " ms " + ex.getMessage());
                    Runtime.getRuntime().halt(999);
                }
            }
        });
        w.getWrapperLogger().info("Win service: before service init");
        service.init();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        w.getWrapperLogger().info("Win service: terminated correctly");
        Runtime.getRuntime().halt(0);
    }

    @Override
    public void onStart() {
        this.log("onstart");
    }

    @Override
    public void onStop() {
        pool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    w.getWrapperLogger().info("Win service stop - timeout: " + service.getStopTimeout());
                    if (w.isHaltAppOnWrapper()) {
                        w.getWrapperLogger().info("Win service wrapper.control -> stopping application");
                        wList.removeStateChangeListener(0);
                        wList.stopAll(WrapperMainServiceWin.this._stopReason);
                    }
                    wList.shutdown();
                    w.getWrapperLogger().info("Win service stop - after shutdown");
                    Object object = WrapperMainServiceWin.this.waitObject;
                    synchronized (object) {
                        w.getWrapperLogger().info("Win service stop - before notify");
                        WrapperMainServiceWin.this.waitObject.notifyAll();
                    }
                    w.getWrapperLogger().info("Win service terminated");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    w.getWrapperLogger().throwing(this.getClass().getName(), "error in win service doStop", e);
                }
            }
        });
    }

    @Override
    public void log(String txt) {
        if (w != null && w.getWrapperLogger() != null) {
            w.getWrapperLogger().info(txt);
        }
    }

    @Override
    public void waitOnStop() {
        int i = 0;
        try {
            while (!_waitOnStop && i++ < 20) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        _waitOnStop = false;
        pool = Executors.newFixedThreadPool(5);
    }
}

