/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.util.Timeout;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.session.Session;

class SessionImpl
implements Session {
    private String _id;
    private List<Runnable> _closedListeners = Collections.synchronizedList(new ArrayList());
    private List<Runnable> _invalidatedListeners = Collections.synchronizedList(new ArrayList());
    private Map<String, Object> _attributes = new HashMap<String, Object>();
    private long _created = System.currentTimeMillis();
    private volatile long _connected = System.currentTimeMillis();
    private volatile boolean _new = true;
    private volatile Timeout _timeout = null;
    private volatile boolean _valid = true;
    private volatile boolean _closed = false;
    private volatile long _messageCount = 0L;

    SessionImpl(String id) {
        this._id = id;
        this._created = System.currentTimeMillis();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void addClosedListener(Runnable listener) {
        this._closedListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this._closed = true;
        this._connected = -1L;
        List<Runnable> list = this._closedListeners;
        synchronized (list) {
            for (Runnable listener : this._closedListeners) {
                try {
                    listener.run();
                }
                catch (Throwable ex) {
                    Constants.ahessianLogger.warn(" execption in closedListener in session: " + this._id + " " + ex);
                }
            }
        }
    }

    @Override
    public void addInvalidatedListener(Runnable listener) {
        this._invalidatedListeners.add(listener);
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return new ArrayList<String>(this._attributes.keySet());
    }

    @Override
    public long getCreationTime() {
        return this._created;
    }

    @Override
    public long getLastConnectedTime() {
        return this._connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        this._valid = false;
        List<Runnable> list = this._invalidatedListeners;
        synchronized (list) {
            for (Runnable listener : this._invalidatedListeners) {
                try {
                    listener.run();
                }
                catch (Throwable ex) {
                    Constants.ahessianLogger.warn(" execption in invalidatedListener in session: " + this._id + " " + ex);
                }
            }
        }
    }

    @Override
    public boolean isNew() {
        return this._new;
    }

    @Override
    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    @Override
    public void setNew(boolean newValue) {
        this._new = newValue;
    }

    @Override
    public void setTimeOut(Timeout timeOut) {
        this._timeout = timeOut;
    }

    @Override
    public Timeout removeTimeout() {
        Timeout result = this._timeout;
        this._timeout = null;
        return result;
    }

    @Override
    public boolean isValid() {
        return this._valid;
    }

    @Override
    public void onMessage() {
        ++this._messageCount;
    }

    public void onConnected() {
        this._connected = System.currentTimeMillis();
    }

    @Override
    public long getMessageCount() {
        return this._messageCount;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public void setClosed(boolean b) {
        this._closed = b;
    }
}

