/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.buffer.ChannelBuffer;
import org.rzo.netty.ahessian.Constants;

public class InputStreamBuffer
extends InputStream {
    final LinkedList<ChannelBuffer> _bufs = new LinkedList();
    private volatile boolean _closed = false;
    private final Lock _lock = new ReentrantLock();
    private final Condition _notEmpty = this._lock.newCondition();
    private volatile int _available = 0;
    boolean blocking = false;
    long _readTimeout = 3000L;

    @Override
    public int read() throws IOException {
        int result = -1;
        if (this._closed) {
            return -1;
        }
        this._lock.lock();
        try {
            while (!this._closed && this.available() == 0) {
                if (this.blocking) {
                    if (this._readTimeout > 0L) {
                        if (this._notEmpty.await(this._readTimeout, TimeUnit.MILLISECONDS)) continue;
                        throw new IOException("read timeout");
                    }
                    this._notEmpty.await();
                    continue;
                }
                throw new IOException("no data");
            }
            if (!this._closed) {
                result = this._bufs.getFirst().readByte() & 0xFF;
                --this._available;
                this.checkBufs();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            this._lock.unlock();
        }
        return result;
    }

    private void checkBufs() {
        if (!this._bufs.isEmpty() && this._bufs.getFirst().readableBytes() == 0) {
            this._bufs.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this._lock.lock();
        try {
            this._closed = true;
            this._notEmpty.signal();
            super.close();
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("error closing input stream", (Throwable)ex);
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelBuffer buf) throws IOException {
        if (this._closed) {
            throw new IOException("stream closed");
        }
        this._lock.lock();
        try {
            if (this._bufs.isEmpty() || buf != this._bufs.getLast()) {
                this._bufs.addLast(buf);
            }
            this._available += buf.readableBytes();
            this._notEmpty.signal();
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", (Throwable)ex);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public int available() throws IOException {
        if (this._closed) {
            throw new IOException("stream closed");
        }
        return this._available;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = -1;
        if (this._closed) {
            return -1;
        }
        this._lock.lock();
        try {
            while (!this._closed && this.available() == 0) {
                if (this._readTimeout > 0L) {
                    if (this._notEmpty.await(this._readTimeout, TimeUnit.MILLISECONDS)) continue;
                    throw new IOException("read timeout");
                }
                this._notEmpty.awaitUninterruptibly();
            }
            if (!this._closed) {
                int length = Math.min(len, this._bufs.getFirst().readableBytes());
                this._bufs.getFirst().readBytes(b, off, length);
                result = length;
                this._available -= length;
                this.checkBufs();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            this._lock.unlock();
        }
        return result;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void setReadTimeout(long timeout) {
        this._readTimeout = timeout;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }
}

