/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;

public class JarBuilder {
    Map<String, Set<String>> _jar2class = new HashMap<String, Set<String>>();

    private void parseLog(String file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        Pattern p = Pattern.compile("\\[Loaded\\s(.*)\\s+from file\\:/(.*)\\]");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                String clazz = m.group(1);
                String jar = m.group(2);
                if (jar.endsWith("/rt.jar")) continue;
                this.addClazz(jar, clazz);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addClazz(String jar, String clazz) {
        Set<String> clazzes = this._jar2class.get(jar);
        System.out.println("add " + jar + "!" + clazz);
        if (clazzes == null) {
            clazzes = new HashSet<String>();
            this._jar2class.put(jar, clazzes);
        }
        clazzes.add(clazz);
    }

    private void addFile(FileObject f, String name, ZipOutputStream out) throws IOException {
        int len;
        InputStream in = f.getContent().getInputStream();
        out.putNextEntry(new ZipEntry(name));
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.closeEntry();
        in.close();
    }

    private void buildJar(String newJar) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(newJar));
        FileSystemManager fsManager = VFS.getManager();
        for (String jar : this._jar2class.keySet()) {
            FileObject jarFile = jar.endsWith(".jar") ? fsManager.resolveFile("jar:" + jar) : fsManager.resolveFile(jar);
            for (String file : this._jar2class.get(jar)) {
                file = file.replaceAll("\\.", "/");
                FileObject f = fsManager.resolveFile(jarFile, file = file + ".class");
                if (f.exists()) {
                    this.addFile(f, file, out);
                    continue;
                }
                System.out.println("file not found " + f);
            }
        }
        out.close();
    }

    public static void main(String[] args) throws Exception {
        String logFile = args[0];
        String newJar = args[1];
        new File(newJar).delete();
        JarBuilder b = new JarBuilder();
        b.parseLog(logFile);
        b.buildJar(newJar);
    }
}

