/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix.bsd;

import com.sun.jna.ptr.IntByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.io.CyclicBufferFileInputStream;
import org.rzo.yajsw.io.CyclicBufferFilePrintStream;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.os.posix.PosixProcess;
import org.rzo.yajsw.os.posix.bsd.AppStarter;

public class BSDProcess
extends PosixProcess {
    java.lang.Process _process;

    @Override
    public boolean start() {
        java.lang.Process p;
        this._terminated = false;
        this._exitCode = -1;
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.getCurrentJava());
        cmdList.add("-classpath");
        cmdList.add(this.getStartClasspath());
        if (this._pipeStreams) {
            cmdList.add("-Dwrapperx.pipeStreams=true");
        }
        if (this._user != null) {
            cmdList.add("-Dwrapperx.user=" + this._user);
        }
        if (this._password != null) {
            cmdList.add("-Dwrapperx.password=" + this._password);
        }
        String[] xenv = this.getXEnv();
        cmdList.add(AppStarter.class.getName());
        for (int i = 0; i < this._arrCmd.length; ++i) {
            cmdList.add(this._arrCmd[i]);
        }
        String[] cmd = new String[cmdList.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)cmdList.get(i);
            System.out.print(cmd[i] + " ");
        }
        System.out.println();
        System.out.flush();
        try {
            p = Runtime.getRuntime().exec(cmd, xenv, new File(this._workingDir));
        }
        catch (IOException e) {
            e.printStackTrace();
            this._terminated = true;
            return false;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String line;
            do {
                if ((line = in.readLine()) != null && line.contains("PID:")) {
                    this.setPid(Integer.parseInt(line.substring(4)));
                    line = null;
                    continue;
                }
                System.out.println(line);
            } while (line != null);
        }
        catch (IOException e) {
            e.printStackTrace();
            this._terminated = true;
            return false;
        }
        this._process = p;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                BSDProcess.this._terminated = true;
                BSDProcess.this._exitCode = p.exitValue();
                System.out.println("exit code bsd process " + BSDProcess.this._exitCode);
                BSDProcess.this.setTerminated(true);
            }
        });
        if (this._teeName != null && this._tmpPath != null) {
            File f = new File(this._tmpPath);
            try {
                if (!f.exists()) {
                    f.mkdir();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                this._inputStream = new CyclicBufferFileInputStream(this.createRWfile(this._tmpPath, "out_" + this._teeName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this._errorStream = new CyclicBufferFileInputStream(this.createRWfile(this._tmpPath, "err_" + this._teeName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this._outputStream = new CyclicBufferFilePrintStream(this.createRWfile(this._tmpPath, "in_" + this._teeName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this._pipeStreams && this._teeName == null && this._tmpPath == null) {
            this._outputStream = this._process.getOutputStream();
            this._inputStream = this._process.getInputStream();
            this._errorStream = this._process.getErrorStream();
        }
        if (this._cpuAffinity != -99) {
            IntByReference affinity = new IntByReference();
            affinity.setValue(this._cpuAffinity);
            if (PosixProcess.CLibrary.INSTANCE.sched_setaffinity(this._pid, 4, affinity) == -1) {
                System.out.println("error setting affinity");
            }
        }
        System.out.println("started process " + this._pid);
        return true;
    }

    private String[] getXEnv() {
        List<String[]> env = this.getEnvironment();
        if (env != null && !env.isEmpty()) {
            String[] result = new String[env.size()];
            int i = 0;
            for (String[] x : env) {
                result[i] = x[0] + "=" + x[1];
                System.out.println("bsd env " + result[i]);
                ++i;
            }
            return result;
        }
        return null;
    }

    private String getStartClasspath() {
        String wrapperJar = WrapperLoader.getWrapperJar();
        File wrapperHome = new File(wrapperJar).getParentFile();
        File jnaFile = new File(wrapperHome, "lib/core/jna/jna-3.3.0.jar");
        try {
            return wrapperJar + ":" + jnaFile.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getCurrentJava() {
        int myPid = OperatingSystem.instance().processManagerInstance().currentProcessId();
        Process myProcess = OperatingSystem.instance().processManagerInstance().getProcess(myPid);
        String cmd = myProcess.getCommand();
        String jvm = null;
        jvm = cmd.startsWith("\"") ? cmd.substring(0, cmd.indexOf("\" ") + 1) : cmd.substring(0, cmd.indexOf(" "));
        return jvm;
    }

    public String getCommandInternal() {
        if (this._pid < 0) {
            return null;
        }
        String cmd = String.format("ps -p %1$s -o command", this._pid);
        String res = this._utils.osCommand(cmd, 5000L);
        if (res == null) {
            return null;
        }
        String[] resx = res.split(System.getProperty("line.separator"));
        return resx[1];
    }

    @Override
    public String getUserInternal() {
        if (this._pid < 0) {
            return null;
        }
        String cmd = String.format("ps -p %1$s -o user", this._pid);
        String res = this._utils.osCommand(cmd, 5000L);
        if (res == null) {
            return null;
        }
        String[] resx = res.split(System.getProperty("line.separator"));
        return resx[1];
    }

    @Override
    public String getWorkingDirInternal() {
        if (this._pid < 0) {
            return null;
        }
        return null;
    }

    public static Process getProcess(int pid) {
        BSDProcess result = null;
        result = new BSDProcess();
        result.setPid(pid);
        result.setUser(result.getUserInternal());
        result.setCommand(result.getCommandInternal());
        result.setWorkingDir(result.getWorkingDirInternal());
        if (result.getCommand() == null) {
            return null;
        }
        return result;
    }

    public static void main(String[] args) {
        BSDProcess p = new BSDProcess();
        System.out.println(p.getCurrentJava());
        p.setCommand(new String[]{"ping", "localhost"});
        p.setPipeStreams(true, false);
        p.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String line;
            do {
                line = in.readLine();
                System.out.println(line);
            } while (line != null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

