/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix.bsd;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Iterator;
import org.rzo.yajsw.os.posix.PosixProcess;

public class AppStarter {
    public static void main(String[] args) {
        int pid = PosixProcess.CLibrary.INSTANCE.getpid();
        System.out.println("PID:" + pid);
        System.out.flush();
        PosixProcess.CLibrary.INSTANCE.umask(0);
        PosixProcess.CLibrary.INSTANCE.setsid();
        if (PosixProcess.CLibrary.INSTANCE.nice(1) == -1) {
            System.out.println("could not set priority ");
        }
        if (AppStarter.getUser() != null) {
            AppStarter.switchUser(AppStarter.getUser(), AppStarter.getPassword());
        }
        if (!AppStarter.isPipeStreams()) {
            System.out.close();
            System.err.close();
        }
        String[] env = null;
        try {
            if (env == null) {
                PosixProcess.CLibrary.INSTANCE.execvp(args[0], args);
            } else {
                PosixProcess.CLibrary.INSTANCE.execve(args[0], args, env);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isPipeStreams() {
        return System.getProperty("wrapperx.pipeStreams") != null;
    }

    private static String getPassword() {
        return System.getProperty("wrapperx.password");
    }

    private static String getUser() {
        return System.getProperty("wrapperx.user");
    }

    private static String[] getEnv() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : System.getenv().keySet()) {
            result.add(key + "=" + System.getenv(key));
        }
        if (result.isEmpty()) {
            return null;
        }
        String[] arr = new String[result.size()];
        int i = 0;
        Iterator i$ = result.iterator();
        while (i$.hasNext()) {
            String x;
            arr[i] = x = (String)i$.next();
            System.out.println(x);
            ++i;
        }
        return arr;
    }

    public static String currentUser() {
        int euid = PosixProcess.CLibrary.INSTANCE.geteuid();
        Pointer p = PosixProcess.CLibrary.INSTANCE.getpwuid(euid);
        if (p == null) {
            System.out.println("could not get current user");
        }
        return new PosixProcess.CLibrary.passwd(p).getName();
    }

    public static void switchUser(String name, String password) {
        System.out.println("setting to user " + name);
        if (name == null || "".equals(name)) {
            return;
        }
        String current = AppStarter.currentUser();
        System.out.println("current user" + current);
        if (current != null && !current.equals(name)) {
            int res;
            Pointer p = PosixProcess.CLibrary.INSTANCE.getpwnam(name);
            int newUid = new PosixProcess.CLibrary.passwd(p).getUid();
            if (newUid == 0) {
                System.out.println("could not get user " + name);
            }
            if ((res = PosixProcess.CLibrary.INSTANCE.setreuid(newUid, newUid)) != 0) {
                System.out.println("could not change to user " + name);
            }
            if (!name.equals(current = AppStarter.currentUser())) {
                System.out.println("could not set user");
            }
        }
    }
}

