/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix;

import java.util.HashSet;
import java.util.Set;

public class UpdateRcParser {
    Set<String> _startLinks = new HashSet<String>();
    Set<String> _stopLinks = new HashSet<String>();
    String _runLevelDir;
    String _serviceName;
    String _stopLevels = "";
    String _startLevels = "";

    public UpdateRcParser(String property, String runLevelDir, String serviceName) {
        if (runLevelDir == null || "".equals(runLevelDir)) {
            return;
        }
        if (serviceName == null || "".equals(serviceName)) {
            return;
        }
        this._runLevelDir = runLevelDir;
        this._serviceName = serviceName;
        if (property == null || "".equals(property)) {
            this.setDefault();
        } else {
            this.setLinks(property);
        }
    }

    private void setDefault() {
        this.setDefaultStartLinks(20);
        this.setDefaultStopLinks(20);
    }

    private void setDefaultStopLinks(int priority) {
        this.addStopLink(0, priority);
        this.addStopLink(1, priority);
        this.addStopLink(6, priority);
    }

    private void addStopLink(int level, int priority) {
        this._stopLinks.add(this._runLevelDir.replaceFirst("X", "" + level) + "/K" + priority + this._serviceName);
    }

    private void setDefaultStartLinks(int priority) {
        this.addStartLink(2, priority);
        this.addStartLink(3, priority);
        this.addStartLink(4, priority);
        this.addStartLink(5, priority);
    }

    private void addStartLink(int level, int priority) {
        this._startLinks.add(this._runLevelDir.replaceFirst("X", "" + level) + "/S" + priority + this._serviceName);
    }

    private void setLinks(String property) {
        block8: {
            try {
                String[] x = property.split(" ");
                if (x.length == 1) {
                    int priority = Integer.parseInt(x[0]);
                    this.setDefaultStartLinks(priority);
                    this.setDefaultStopLinks(priority);
                    break block8;
                }
                if (x.length == 2) {
                    int startPriority = Integer.parseInt(x[0]);
                    int stopPriority = Integer.parseInt(x[1]);
                    this.setDefaultStartLinks(startPriority);
                    this.setDefaultStopLinks(stopPriority);
                    break block8;
                }
                int i = 0;
                while (i < x.length) {
                    int level;
                    int priority;
                    String txt;
                    if ((txt = x[i++]).trim().equals("start")) {
                        priority = Integer.parseInt(x[i++]);
                        while (i < x.length && !".".equals(x[i].trim())) {
                            level = Integer.parseInt(x[i++]);
                            this.addStartLink(level, priority);
                            this._startLevels = this._startLevels + level + " ";
                        }
                        continue;
                    }
                    if (!txt.trim().equals("stop")) continue;
                    priority = Integer.parseInt(x[i++]);
                    while (i < x.length && !".".equals(x[i].trim())) {
                        level = Integer.parseInt(x[i++]);
                        this.addStopLink(level, priority);
                        this._stopLevels = this._stopLevels + level + " ";
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("error parsing wrapper.daemon.update_rc " + ex);
            }
        }
    }

    public Set<String> getStopLinks() {
        return this._stopLinks;
    }

    public Set<String> getStartLinks() {
        return this._startLinks;
    }

    public static void main(String[] args) {
        UpdateRcParser p = new UpdateRcParser(null, "/etc/rcX.d", "serviceName");
        System.out.println(p.getStartLinks());
        System.out.println(p.getStopLinks());
        p = new UpdateRcParser("91", "/etc/rcX.d", "serviceName");
        System.out.println(p.getStartLinks());
        System.out.println(p.getStopLinks());
        p = new UpdateRcParser("20 80", "/etc/rcX.d", "serviceName");
        System.out.println(p.getStartLinks());
        System.out.println(p.getStopLinks());
        p = new UpdateRcParser("start 20 2 3 4 . start 30 5 . stop 80 0 1 6", "/etc/rcX.d", "serviceName");
        System.out.println(p.getStartLinks());
        System.out.println(p.getStopLinks());
    }

    public String getStopLevels() {
        return this._stopLevels;
    }

    public String getStartLevels() {
        return this._startLevels;
    }
}

