/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.rzo.yajsw.os.ms.win.w32.PdhCounter;
import org.rzo.yajsw.script.Script;
import org.rzo.yajsw.script.ScriptFactory;
import org.rzo.yajsw.util.VFSUtils;

public class ScriptCounter
implements PdhCounter {
    InternalLogger _log = InternalLoggerFactory.getInstance(this.getClass().getName());
    Script _script;
    private String _scriptFile;
    String _counterString;
    private String[] _args;
    private long _lastModified;

    public ScriptCounter(String counterString) {
        this.init(counterString);
        this.checkScript();
    }

    private void init(String counterString) {
        this._counterString = counterString;
        this._scriptFile = StringUtils.substringBetween((String)counterString, (String)"(", (String)")");
        String argsString = StringUtils.substringAfter((String)counterString, (String)")\\");
        if (argsString != null) {
            this._args = StringUtils.split((String)argsString, (String)",");
        }
    }

    private void checkScript() {
        long lastModified;
        try {
            lastModified = VFSUtils.resolveFile(".", this._scriptFile).getContent().getLastModifiedTime();
        }
        catch (FileSystemException e) {
            throw new IllegalArgumentException("Cannot find script " + this._scriptFile + " ex=" + e.getMessage());
        }
        if (this._lastModified == lastModified) {
            return;
        }
        this._lastModified = lastModified;
        this._script = ScriptFactory.createScript(this._scriptFile, this._counterString, null, this._args, this._log, 0);
        if (this._script == null) {
            throw new IllegalArgumentException("Cannot find script " + this._scriptFile);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public double getDoubleValue() {
        this.checkScript();
        Object result = this._script.execute();
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return Double.parseDouble((String)result);
    }

    @Override
    public int getIntValue() {
        this.checkScript();
        Object result = this._script.execute();
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        return Integer.parseInt((String)result);
    }

    @Override
    public boolean isValid() {
        try {
            this.getIntValue();
            return true;
        }
        catch (Exception e) {
            try {
                this.getDoubleValue();
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }
}

