/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.rzo.yajsw.io.CyclicBufferFilePrintStream;
import org.rzo.yajsw.util.DaemonThreadFactory;

public class CyclicBufferFileInputStream
extends BufferedInputStream {
    public CyclicBufferFileInputStream(File file) throws FileNotFoundException, IOException {
        super(CyclicBufferFileInputStream.newInputStream(file));
    }

    public static InputStream newInputStream(final File file) throws IOException {
        return new InputStream(){
            boolean closed = false;
            boolean opened = false;
            Lock lock = new ReentrantLock();
            RandomAccessFile raf;
            ByteBuffer buf;
            ByteBuffer posBuf;
            ByteBuffer lockBuf;

            synchronized void open() {
                if (this.opened) {
                    return;
                }
                while (!this.opened && !this.closed) {
                    this.lock.lock();
                    if (file.exists()) {
                        try {
                            if (this.raf == null) {
                                this.raf = new RandomAccessFile(file, "r");
                            }
                            this.buf = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 5L, CyclicBufferFilePrintStream.length - 5);
                            this.posBuf = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 1L, 4L);
                            this.lockBuf = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 1L);
                            this.opened = true;
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                    }
                    this.lock.unlock();
                    if (this.opened) continue;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                }
            }

            @Override
            public void close() {
                this.closed = true;
                try {
                    if (this.raf != null) {
                        this.raf.close();
                    }
                    this.buf = null;
                    System.gc();
                    Thread.yield();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    this.buf.position(0);
                }
                while (this.getPosition() == this.buf.position() && !this.closed) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        return -1;
                    }
                }
                if (this.closed) {
                    return -1;
                }
                return this.buf.get();
            }

            private int getPosition() {
                this.posBuf.position(0);
                this.waitUnlocked();
                return this.posBuf.getInt();
            }

            private void waitUnlocked() {
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                this.open();
                this.lock.lock();
                if (!this.buf.hasRemaining()) {
                    this.buf.position(0);
                }
                while (!this.closed && this.getPosition() == this.buf.position()) {
                    try {
                        this.lock.unlock();
                        Thread.sleep(100L);
                        this.lock.lock();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        this.lock.unlock();
                        return -1;
                    }
                }
                if (this.closed) {
                    this.lock.unlock();
                    return -1;
                }
                int toRead = this.getPosition() - this.buf.position();
                if (toRead < 0) {
                    toRead = this.buf.remaining();
                }
                if (toRead > len) {
                    toRead = len;
                }
                this.buf.get(bytes, off, toRead);
                this.lock.unlock();
                return toRead;
            }
        };
    }

    public static void main(String[] args) {
        CyclicBufferFileInputStream reader = null;
        try {
            reader = new CyclicBufferFileInputStream(new File("test.dat"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStreamReader isr = new InputStreamReader(reader);
        final BufferedReader br = new BufferedReader(isr);
        ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory("test"));
        executor.execute(new Runnable(){

            @Override
            public void run() {
                String line = null;
                try {
                    while ((line = br.readLine()) != null) {
                        System.out.println(line);
                    }
                    System.out.println(line);
                    System.out.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }
}

