/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.server;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.ClientCallback;
import org.rzo.netty.ahessian.rpc.callback.ServerCallbackProxy;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.HessianSkeleton;
import org.rzo.netty.ahessian.rpc.server.ServiceSessionProvider;

public class ImmediateInvokeService
extends HessianSkeleton
implements Constants {
    public ImmediateInvokeService(Object service, Class apiClass, HessianRPCServiceHandler factory) {
        super(service, apiClass, factory);
    }

    @Override
    public void messageReceived(HessianRPCCallMessage message) {
        ServiceSessionProvider.set(message.getSession());
        this.invoke(message);
        ServiceSessionProvider.remove();
    }

    void invoke(HessianRPCCallMessage message) {
        Object result = null;
        Throwable fault = null;
        try {
            Method method = this.getMethod(message);
            Object[] args = message.getArgs();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof ClientCallback)) continue;
                    ClientCallback cc = (ClientCallback)args[i];
                    ClassLoader cl = cc.getClass().getClassLoader();
                    ArrayList clazzes = new ArrayList();
                    for (Class<?> clazz = cl.loadClass(cc.getCallbackClass()); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
                        clazzes.addAll(Arrays.asList(clazz.getInterfaces()));
                    }
                    args[i] = Proxy.newProxyInstance(cl, clazzes.toArray(new Class[clazzes.size()]), (InvocationHandler)new ServerCallbackProxy(this._factory, message, (ClientCallback)args[i]));
                }
            }
            result = method.invoke(this._service, args);
        }
        catch (Throwable ex) {
            Constants.ahessianLogger.warn("", ex);
            fault = ex;
        }
        HessianRPCReplyMessage reply = new HessianRPCReplyMessage(result, fault, message);
        reply.setCompleted(true);
        reply.setCallId((Long)message.getHeaders().get(CALL_ID_HEADER_KEY));
        reply.setGroup((Integer)message.getHeaders().get(GROUP_HEADER_KEY));
        this.writeResult(reply);
    }
}

