/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.util.Timeout;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.Callback;
import org.rzo.netty.ahessian.rpc.callback.CallbackReplyMessage;
import org.rzo.netty.ahessian.rpc.callback.ClientCallback;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;

public class HessianProxyFuture
implements Future<Object>,
Constants {
    private boolean _done = false;
    private boolean _canceled = false;
    private HessianRPCReplyMessage _result = null;
    private Lock _lock = new ReentrantLock();
    private Condition _resultReceived = this._lock.newCondition();
    private Collection<Runnable> _listeners = Collections.synchronizedCollection(new ArrayList());
    private volatile Map<Long, ClientCallback> _callbacks = Collections.synchronizedMap(new HashMap());
    private volatile Timeout _timeout = null;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this._canceled = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() throws InterruptedException, ExecutionException {
        Object result = null;
        this._lock.lock();
        try {
            while (this._result == null) {
                this._resultReceived.await();
            }
            if (this._result.getFault() != null) {
                throw new ExecutionException(this._result.getFault());
            }
            Object object = this._result.getValue();
            return object;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = null;
        this._lock.lock();
        try {
            if (this._result == null) {
                this._resultReceived.await(timeout, unit);
            }
            if (this._result == null) {
                throw new TimeoutException();
            }
            if (this._result.getFault() != null) {
                throw new ExecutionException(this._result.getFault());
            }
            Object object = this._result.getValue();
            return object;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public boolean isCancelled() {
        return this._canceled;
    }

    @Override
    public boolean isDone() {
        return this._done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void set(HessianRPCReplyMessage message) {
        this._lock.lock();
        if (this._timeout != null) {
            this._timeout.cancel();
        }
        try {
            if (message instanceof CallbackReplyMessage) {
                this.handleCallbackReply((CallbackReplyMessage)message);
            } else {
                this._done = true;
                this._result = message;
                this._resultReceived.signal();
                this.callListners();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private void handleCallbackReply(CallbackReplyMessage message) {
        Long callbackId = message.getCallbackId();
        if (callbackId == null) {
            return;
        }
        ClientCallback callback = this._callbacks.get(callbackId);
        if (callback == null) {
            System.out.println("no callback found for " + callbackId);
            return;
        }
        callback.invoke(message);
        if (message.isDone()) {
            this._callbacks.remove(callbackId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callListners() {
        Collection<Runnable> collection = this._listeners;
        synchronized (collection) {
            for (Runnable listener : this._listeners) {
                listener.run();
            }
        }
    }

    public void addListener(Runnable listener) {
        this._lock.lock();
        if (this.isDone()) {
            listener.run();
        } else {
            this._listeners.add(listener);
        }
        this._lock.unlock();
    }

    public void removeListener(Runnable listener) {
        this._listeners.remove(listener);
    }

    public void handleCallbacks(Object[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Callback)) continue;
            ClientCallback c = new ClientCallback((Callback)args[i]);
            this._callbacks.put(c.getId(), c);
            args[i] = c;
        }
    }

    public boolean hasCallbacks() {
        return this._callbacks.size() != 0;
    }

    public void setTimeout(Timeout timeout) {
        this._timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedOut() {
        this._lock.lock();
        this._timeout = null;
        try {
            this.set(new HessianRPCReplyMessage(null, new TimeoutException(), null));
        }
        finally {
            this._lock.unlock();
        }
    }
}

