/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.logging;

import org.jboss.netty.logging.InternalLogLevel;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.SimpleLoggerFactory;
import org.jboss.netty.util.internal.StackTraceSimplifier;

public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory = new SimpleLoggerFactory();

    public static InternalLoggerFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        InternalLoggerFactory.defaultFactory = defaultFactory;
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String name) {
        final InternalLogger logger = InternalLoggerFactory.getDefaultFactory().newInstance(name);
        return new InternalLogger(){

            public void debug(String msg) {
                logger.debug(msg);
            }

            public void debug(String msg, Throwable cause) {
                StackTraceSimplifier.simplify((Throwable)cause);
                logger.debug(msg, cause);
            }

            public void error(String msg) {
                logger.error(msg);
            }

            public void error(String msg, Throwable cause) {
                StackTraceSimplifier.simplify((Throwable)cause);
                logger.error(msg, cause);
            }

            public void info(String msg) {
                logger.info(msg);
            }

            public void info(String msg, Throwable cause) {
                StackTraceSimplifier.simplify((Throwable)cause);
                logger.info(msg, cause);
            }

            public boolean isDebugEnabled() {
                return logger.isDebugEnabled();
            }

            public boolean isErrorEnabled() {
                return logger.isErrorEnabled();
            }

            public boolean isInfoEnabled() {
                return logger.isInfoEnabled();
            }

            public boolean isWarnEnabled() {
                return logger.isWarnEnabled();
            }

            public void warn(String msg) {
                logger.warn(msg);
            }

            public void warn(String msg, Throwable cause) {
                StackTraceSimplifier.simplify((Throwable)cause);
                logger.warn(msg, cause);
            }

            public boolean isEnabled(InternalLogLevel level) {
                return logger.isEnabled(level);
            }

            public void log(InternalLogLevel level, String msg) {
                logger.log(level, msg);
            }

            public void log(InternalLogLevel level, String msg, Throwable cause) {
                StackTraceSimplifier.simplify((Throwable)cause);
                logger.log(level, msg, cause);
            }
        };
    }

    public abstract InternalLogger newInstance(String var1);

    static {
        StackTraceSimplifier.simplify((Throwable)new Exception());
    }
}

