/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.netty.handler.ipfilter.CIDR;
import org.jboss.netty.handler.ipfilter.IpSet;

public class IpSubnet
implements IpSet,
Comparable<IpSubnet> {
    private CIDR cidr = null;

    public IpSubnet() {
        this.cidr = null;
    }

    public IpSubnet(String netAddress) throws UnknownHostException {
        this.cidr = CIDR.newCIDR(netAddress);
    }

    public IpSubnet(InetAddress inetAddress, int cidrNetMask) throws UnknownHostException {
        this.cidr = CIDR.newCIDR(inetAddress, cidrNetMask);
    }

    public IpSubnet(InetAddress inetAddress, String netMask) throws UnknownHostException {
        this.cidr = CIDR.newCIDR(inetAddress, netMask);
    }

    public boolean contains(String ipAddr) throws UnknownHostException {
        InetAddress inetAddress1 = InetAddress.getByName(ipAddr);
        return this.contains(inetAddress1);
    }

    @Override
    public boolean contains(InetAddress inetAddress) {
        if (this.cidr == null) {
            return true;
        }
        return this.cidr.contains(inetAddress);
    }

    public String toString() {
        return this.cidr.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IpSubnet)) {
            return false;
        }
        IpSubnet ipSubnet = (IpSubnet)o;
        return ipSubnet.cidr.equals(this.cidr);
    }

    @Override
    public int compareTo(IpSubnet o) {
        return this.cidr.toString().compareTo(o.cidr.toString());
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            IpSubnet ipSubnet = null;
            try {
                ipSubnet = new IpSubnet(args[0]);
            }
            catch (UnknownHostException e) {
                return;
            }
            System.out.println("IpSubnet: " + ipSubnet.toString() + " from " + ipSubnet.cidr.getBaseAddress() + " to " + ipSubnet.cidr.getEndAddress() + " mask " + ipSubnet.cidr.getMask());
            if (args.length > 1) {
                try {
                    System.out.println("Is IN: " + args[1] + " " + ipSubnet.contains(args[1]));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
    }
}

