/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.utils.MyBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedBlockingPriorityQueue<T>
implements MyBlockingQueue<T> {
    int _defaultGroup = 0;
    LinkedList<T>[] _queues;
    int[] _sizes;
    long[] _timeouts;
    Map<T, Timeout> _timers = new HashMap<T, Timeout>();
    Timer _timer;
    Lock _lock = new ReentrantLock();
    Condition _hasData = this._lock.newCondition();
    volatile boolean waiting = false;
    int _size = 0;
    String _name = "?";
    T _last = null;

    public TimedBlockingPriorityQueue(Map<String, Object> options, Timer timer, String name) {
        this._name = name;
        ArrayList<Integer> groups = new ArrayList<Integer>();
        this._timer = timer;
        for (String key : options.keySet()) {
            if (!key.startsWith("group.")) continue;
            try {
                String rest = key.substring(key.indexOf(46) + 1);
                int x = Integer.parseInt(rest.substring(0, rest.indexOf(46)));
                if (groups.contains(x)) continue;
                groups.add(x);
            }
            catch (Exception ex) {
                Constants.ahessianLogger.warn("", (Throwable)ex);
            }
        }
        if (!groups.contains(0)) {
            groups.add(0);
        }
        Collections.sort(groups);
        int size = (Integer)groups.get(groups.size() - 1) + 1;
        this._queues = new LinkedList[size];
        this._timeouts = new long[size];
        this._sizes = new int[size];
        for (int i = 0; i < size; ++i) {
            int queueSize = options.containsKey("group." + i + ".size") ? (Integer)options.get("group." + i + ".size") : Integer.MAX_VALUE;
            this._queues[i] = new LinkedList();
            this._sizes[i] = queueSize;
            Object timeout = options.get("group." + i + ".timeout");
            long longTimeout = -1L;
            if (timeout instanceof Number) {
                longTimeout = ((Number)timeout).longValue();
            }
            this._timeouts[i] = longTimeout;
        }
    }

    public TimedBlockingPriorityQueue(String name) {
        this._name = name;
        this._queues = new LinkedList[1];
        this._timeouts = new long[1];
        this._sizes = new int[1];
        this._queues[0] = new LinkedList();
        this._timeouts[0] = -1L;
        this._sizes[0] = Integer.MAX_VALUE;
    }

    @Override
    public boolean add(Object e) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public T element() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean offer(T e) {
        return this.offer(e, this._defaultGroup);
    }

    public boolean offer(final T e, int group) {
        this._lock.lock();
        ++this._size;
        if (group >= this._queues.length) {
            Constants.ahessianLogger.warn("group " + group + " not defined -> using group 0");
            group = 0;
        }
        boolean result = false;
        final LinkedList<T> q = this._queues[group];
        result = q.offer(e);
        if (q.size() >= this._sizes[group]) {
            T o = q.remove();
            Timeout timer = this._timers.remove(o);
            if (timer != null) {
                timer.cancel();
            }
            Constants.ahessianLogger.warn("queue overflow -> removed " + e);
        }
        if (result) {
            this._last = e;
        }
        if (this._timer != null && result && this._timeouts[group] > 0L) {
            Timeout timer = this._timer.newTimeout(new TimerTask(){

                public void run(Timeout arg0) throws Exception {
                    TimedBlockingPriorityQueue.this._lock.lock();
                    q.remove(e);
                    Constants.ahessianLogger.warn("message timed out -> removed from queue " + e);
                    TimedBlockingPriorityQueue.this._lock.unlock();
                }
            }, this._timeouts[group], TimeUnit.MILLISECONDS);
        }
        if (result && this.waiting) {
            try {
                this._hasData.signal();
            }
            catch (Exception ex) {
                Constants.ahessianLogger.warn("", (Throwable)ex);
            }
        }
        this._lock.unlock();
        return result;
    }

    @Override
    public T poll() {
        T result = null;
        for (int i = this._queues.length - 1; i >= 0; --i) {
            result = this.poll(i);
            if (result == null) continue;
            --this._size;
            return result;
        }
        return null;
    }

    public T poll(int group) {
        Timeout timer;
        LinkedList<T> q = this._queues[group];
        T result = null;
        if (q != null && (result = (T)q.poll()) != null && (timer = this._timers.remove(result)) != null) {
            timer.cancel();
        }
        return result;
    }

    @Override
    public T peek() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public T remove() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean addAll(Collection c) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public void clear() {
        this._lock.lock();
        for (int i = 0; i < this._queues.length; ++i) {
            this.clear(i);
        }
        this._lock.unlock();
    }

    public void clear(int group) {
        this._lock.lock();
        if (this._queues[group] != null) {
            this._queues[group].clear();
        }
        this._lock.unlock();
    }

    @Override
    public boolean contains(Object o) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean isEmpty() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public Iterator iterator() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean remove(T o, Integer group) {
        if (this._queues[group] != null) {
            return this._queues[group].remove(o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public T[] toArray() {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public T[] toArray(Object[] a) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public int drainTo(Collection c) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public int drainTo(Collection c, int maxElements) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean offer(Object e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public void put(T e) throws InterruptedException {
        this.put(e, this._defaultGroup);
    }

    @Override
    public void put(T e, Integer group) {
        this.offer(e, group);
    }

    @Override
    public int remainingCapacity() {
        throw new RuntimeException("Unimplemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T take() throws InterruptedException {
        T result = null;
        this._lock.lock();
        do {
            if ((result = (T)this.poll()) != null) continue;
            try {
                this.waiting = true;
                this._hasData.await();
            }
            finally {
                this.waiting = false;
            }
        } while (result == null);
        if (result == this._last) {
            this._last = null;
        }
        this._lock.unlock();
        return result;
    }

    @Override
    public long getTimeout(Integer group) {
        if (group < this._timeouts.length) {
            return this._timeouts[group];
        }
        return -1L;
    }

    public T getLast() {
        return this._last;
    }
}

