/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.timeout;

import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.timeout.IntervalTimer;

abstract class AbstractHeartBeatHandler
extends SimpleChannelHandler {
    volatile long _lastCalled;
    volatile ChannelHandlerContext _ctx;
    final IntervalTimer _intervalTimer;
    final String _name;

    public AbstractHeartBeatHandler(String name, Timer timer, final long timeout) {
        this._name = name;
        TimerTask task = new TimerTask(){

            public void run(Timeout nTimeout) throws Exception {
                if (AbstractHeartBeatHandler.this.getLastCalled() + timeout <= System.currentTimeMillis() && AbstractHeartBeatHandler.this.isConnected()) {
                    try {
                        AbstractHeartBeatHandler.this.timedOut(AbstractHeartBeatHandler.this._ctx);
                    }
                    catch (Exception e) {
                        Constants.ahessianLogger.warn("", (Throwable)e);
                    }
                }
            }
        };
        this._intervalTimer = new IntervalTimer(timer, task, timeout);
    }

    abstract void timedOut(ChannelHandlerContext var1);

    long getLastCalled() {
        return this._lastCalled;
    }

    boolean isConnected() {
        return this._ctx != null && this._ctx.getChannel().isConnected();
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this._ctx = null;
        this._intervalTimer.stop();
        ctx.sendUpstream((ChannelEvent)e);
    }

    protected void ping() {
        this._lastCalled = System.currentTimeMillis();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.ping();
        this._ctx = ctx;
        this._intervalTimer.setName(this._name + ":" + this._ctx.getChannel().getId());
        Constants.ahessianLogger.info("AbstractHeartBeatHandler scheduler started: " + this._intervalTimer.getInterval());
        this._intervalTimer.start();
        ctx.sendUpstream((ChannelEvent)e);
    }
}

