/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.session.MixinPipeline;
import org.rzo.netty.ahessian.session.Session;
import org.rzo.netty.ahessian.session.SessionFactory;
import org.rzo.netty.ahessian.stopable.StopablePipeline;

@ChannelPipelineCoverage(value="all")
public class ClientSessionFilter
extends SimpleChannelUpstreamHandler {
    private Session _session = null;
    private boolean _hasSession = false;
    private String _sessionId = "";
    private SessionFactory _factory = new SessionFactory();
    private ChannelStateEvent _connectedEvent;
    private ChannelPipelineFactory _mixinFactory;
    private static Map<String, MixinPipeline> _sessionPipelines = Collections.synchronizedMap(new HashMap());
    private List<Runnable> _sessionClosedListeners = Collections.synchronizedList(new ArrayList());
    private List<Runnable> _sessionNewListeners = Collections.synchronizedList(new ArrayList());

    public ClientSessionFilter(ChannelPipelineFactory mixinFactory) {
        this._mixinFactory = mixinFactory;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this._connectedEvent = e;
        String id = this._session == null ? "?" : this._session.getId();
        ChannelFuture future = Channels.future((Channel)ctx.getChannel());
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)future, (Object)ChannelBuffers.wrappedBuffer((byte[])id.getBytes()));
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this._hasSession) {
            ctx.sendUpstream((ChannelEvent)e);
        } else {
            ChannelBuffer b = (ChannelBuffer)e.getMessage();
            this._sessionId = this._sessionId + b.toString("UTF-8");
            this.checkSession(ctx);
        }
    }

    private void checkSession(ChannelHandlerContext ctx) {
        if (this._sessionId.length() == this._factory.getSessionIdLength() * 2) {
            if (this._session == null) {
                this.newSession(ctx);
            } else if (this._session.getId().equals(this._sessionId)) {
                this.confirmSession(ctx);
            } else {
                this.changedSession(ctx);
            }
        }
    }

    private void changedSession(ChannelHandlerContext ctx) {
        this.closeSession(this._session);
        this.newSession(ctx);
    }

    private void closeSession(Session session) {
        for (Runnable listener : this._sessionClosedListeners) {
            try {
                listener.run();
            }
            catch (Throwable e) {
                Constants.ahessianLogger.warn("", e);
            }
        }
        ChannelPipeline p = _sessionPipelines.remove(session.getId());
        if (p instanceof StopablePipeline) {
            ((StopablePipeline)p).stop();
        }
    }

    private void confirmSession(ChannelHandlerContext ctx) {
        MixinPipeline pipeline = _sessionPipelines.get(this._session.getId());
        this.handleSession(ctx, pipeline);
    }

    private void newSession(ChannelHandlerContext ctx) {
        this._session = this._factory.createSession(this._sessionId);
        MixinPipeline pipeline = null;
        try {
            pipeline = (MixinPipeline)this._mixinFactory.getPipeline();
            _sessionPipelines.put(this._session.getId(), pipeline);
        }
        catch (Exception e) {
            Constants.ahessianLogger.warn("", (Throwable)e);
        }
        this.handleSession(ctx, pipeline);
        for (Runnable listener : this._sessionNewListeners) {
            try {
                listener.run();
            }
            catch (Throwable ex) {
                Constants.ahessianLogger.warn("", ex);
            }
        }
    }

    private void handleSession(ChannelHandlerContext ctx, MixinPipeline pipeline) {
        this._hasSession = true;
        ChannelPipeline currentPipeline = ctx.getPipeline();
        pipeline.mixin(currentPipeline);
        ctx.setAttachment((Object)this._session);
        ctx.sendUpstream((ChannelEvent)this._connectedEvent);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this._hasSession = false;
        this._sessionId = "";
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
    }

    public void addSessionClosedListener(Runnable listener) {
        this._sessionClosedListeners.add(listener);
    }

    public void removeSessionClosedListener(Runnable listener) {
        this._sessionClosedListeners.remove(listener);
    }

    public void addSessionNewListener(Runnable listener) {
        this._sessionNewListeners.add(listener);
    }
}

