/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.server;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.ClientCallback;
import org.rzo.netty.ahessian.rpc.callback.ServerCallbackProxy;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.HessianSkeleton;
import org.rzo.netty.ahessian.rpc.server.ServiceSessionProvider;

public class ExecutorInvokeService
extends HessianSkeleton
implements Constants {
    Executor _executor;

    public ExecutorInvokeService(Object service, Class apiClass, HessianRPCServiceHandler factory, Executor executor) {
        super(service, apiClass, factory);
        this._executor = executor;
    }

    public void messageReceived(HessianRPCCallMessage message) {
        this.invoke(message);
    }

    void invoke(final HessianRPCCallMessage message) {
        this._executor.execute(new Runnable(){

            public void run() {
                Object result = null;
                Throwable fault = null;
                try {
                    Method method = ExecutorInvokeService.this.getMethod(message);
                    Object[] args = message.getArgs();
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            if (!(args[i] instanceof ClientCallback)) continue;
                            ClientCallback cc = (ClientCallback)args[i];
                            ClassLoader cl = cc.getClass().getClassLoader();
                            ArrayList clazzes = new ArrayList();
                            for (Class<?> clazz = cl.loadClass(cc.getCallbackClass()); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
                                clazzes.addAll(Arrays.asList(clazz.getInterfaces()));
                            }
                            args[i] = Proxy.newProxyInstance(cl, clazzes.toArray(new Class[clazzes.size()]), (InvocationHandler)new ServerCallbackProxy(ExecutorInvokeService.this._factory, message, (ClientCallback)args[i]));
                        }
                    }
                    ServiceSessionProvider.set(message.getSession());
                    result = method.invoke(ExecutorInvokeService.this._service, args);
                    ServiceSessionProvider.remove();
                }
                catch (Throwable ex) {
                    ServiceSessionProvider.remove();
                    Constants.ahessianLogger.warn("", ex);
                    fault = ex;
                }
                HessianRPCReplyMessage reply = new HessianRPCReplyMessage(result, fault, message);
                reply.setCompleted(true);
                reply.setCallId((Long)message.getHeaders().get(Constants.CALL_ID_HEADER_KEY));
                reply.setGroup((Integer)message.getHeaders().get(Constants.GROUP_HEADER_KEY));
                ExecutorInvokeService.this.writeResult(reply);
            }
        });
    }
}

